/*
 * Copyright (c) 2020 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;

import java.util.Map;
import java.util.Objects;

/**
 * Helper class which consolidates names and tags for caching purposes.
 */
@Stability.Internal
public class NameAndTags {

  private final String name;
  private final Map<String, String> tags;

  public NameAndTags(String name, Map<String, String> tags) {
    this.name = name;
    this.tags = tags;
  }

  public String name() {
    return name;
  }

  public Map<String, String> tags() {
    return tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NameAndTags that = (NameAndTags) o;
    return Objects.equals(name, that.name) && Objects.equals(tags, that.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, tags);
  }

}
