/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/metric.proto

package com.couchbase.client.core.deps.com.google.api;

/**
 *
 *
 * <pre>
 * Defines a metric type and its schema. Once a metric descriptor is created,
 * deleting or altering it stops data collection and makes the metric type's
 * existing data unusable.
 * </pre>
 *
 * Protobuf type {@code google.api.MetricDescriptor}
 */
public final class MetricDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.MetricDescriptor)
    MetricDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MetricDescriptor.newBuilder() to construct.
  private MetricDescriptor(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MetricDescriptor() {
    name_ = "";
    type_ = "";
    labels_ = java.util.Collections.emptyList();
    metricKind_ = 0;
    valueType_ = 0;
    unit_ = "";
    description_ = "";
    displayName_ = "";
    launchStage_ = 0;
    monitoredResourceTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MetricDescriptor();
  }

  @java.lang.Override
  public final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.MetricProto.internal_static_google_api_MetricDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.MetricProto.internal_static_google_api_MetricDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.MetricDescriptor.class, com.google.api.MetricDescriptor.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The kind of measurement. It describes how the data is reported.
   * For information on setting the start time and end time based on
   * the MetricKind, see [TimeInterval][google.monitoring.v3.TimeInterval].
   * </pre>
   *
   * Protobuf enum {@code google.api.MetricDescriptor.MetricKind}
   */
  public enum MetricKind implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not use this default value.
     * </pre>
     *
     * <code>METRIC_KIND_UNSPECIFIED = 0;</code>
     */
    METRIC_KIND_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * An instantaneous measurement of a value.
     * </pre>
     *
     * <code>GAUGE = 1;</code>
     */
    GAUGE(1),
    /**
     *
     *
     * <pre>
     * The change in a value during a time interval.
     * </pre>
     *
     * <code>DELTA = 2;</code>
     */
    DELTA(2),
    /**
     *
     *
     * <pre>
     * A value accumulated over a time interval.  Cumulative
     * measurements in a time series should have the same start time
     * and increasing end times, until an event resets the cumulative
     * value to zero and sets a new start time for the following
     * points.
     * </pre>
     *
     * <code>CUMULATIVE = 3;</code>
     */
    CUMULATIVE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not use this default value.
     * </pre>
     *
     * <code>METRIC_KIND_UNSPECIFIED = 0;</code>
     */
    public static final int METRIC_KIND_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * An instantaneous measurement of a value.
     * </pre>
     *
     * <code>GAUGE = 1;</code>
     */
    public static final int GAUGE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The change in a value during a time interval.
     * </pre>
     *
     * <code>DELTA = 2;</code>
     */
    public static final int DELTA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A value accumulated over a time interval.  Cumulative
     * measurements in a time series should have the same start time
     * and increasing end times, until an event resets the cumulative
     * value to zero and sets a new start time for the following
     * points.
     * </pre>
     *
     * <code>CUMULATIVE = 3;</code>
     */
    public static final int CUMULATIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricKind valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MetricKind forNumber(int value) {
      switch (value) {
        case 0:
          return METRIC_KIND_UNSPECIFIED;
        case 1:
          return GAUGE;
        case 2:
          return DELTA;
        case 3:
          return CUMULATIVE;
        default:
          return null;
      }
    }

    public static com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<MetricKind> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<MetricKind> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MetricKind>() {
          public MetricKind findValueByNumber(int number) {
            return MetricKind.forNumber(number);
          }
        };

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.MetricDescriptor.getDescriptor().getEnumTypes().get(0);
    }

    private static final MetricKind[] VALUES = values();

    public static MetricKind valueOf(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MetricKind(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.MetricDescriptor.MetricKind)
  }

  /**
   *
   *
   * <pre>
   * The value type of a metric.
   * </pre>
   *
   * Protobuf enum {@code google.api.MetricDescriptor.ValueType}
   */
  public enum ValueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not use this default value.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    VALUE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The value is a boolean.
     * This value type can be used only if the metric kind is `GAUGE`.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    BOOL(1),
    /**
     *
     *
     * <pre>
     * The value is a signed 64-bit integer.
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    INT64(2),
    /**
     *
     *
     * <pre>
     * The value is a double precision floating point number.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * The value is a text string.
     * This value type can be used only if the metric kind is `GAUGE`.
     * </pre>
     *
     * <code>STRING = 4;</code>
     */
    STRING(4),
    /**
     *
     *
     * <pre>
     * The value is a [`Distribution`][google.api.Distribution].
     * </pre>
     *
     * <code>DISTRIBUTION = 5;</code>
     */
    DISTRIBUTION(5),
    /**
     *
     *
     * <pre>
     * The value is money.
     * </pre>
     *
     * <code>MONEY = 6;</code>
     */
    MONEY(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not use this default value.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The value is a boolean.
     * This value type can be used only if the metric kind is `GAUGE`.
     * </pre>
     *
     * <code>BOOL = 1;</code>
     */
    public static final int BOOL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The value is a signed 64-bit integer.
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    public static final int INT64_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The value is a double precision floating point number.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The value is a text string.
     * This value type can be used only if the metric kind is `GAUGE`.
     * </pre>
     *
     * <code>STRING = 4;</code>
     */
    public static final int STRING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The value is a [`Distribution`][google.api.Distribution].
     * </pre>
     *
     * <code>DISTRIBUTION = 5;</code>
     */
    public static final int DISTRIBUTION_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The value is money.
     * </pre>
     *
     * <code>MONEY = 6;</code>
     */
    public static final int MONEY_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ValueType forNumber(int value) {
      switch (value) {
        case 0:
          return VALUE_TYPE_UNSPECIFIED;
        case 1:
          return BOOL;
        case 2:
          return INT64;
        case 3:
          return DOUBLE;
        case 4:
          return STRING;
        case 5:
          return DISTRIBUTION;
        case 6:
          return MONEY;
        default:
          return null;
      }
    }

    public static com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<ValueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<ValueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ValueType>() {
          public ValueType findValueByNumber(int number) {
            return ValueType.forNumber(number);
          }
        };

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.MetricDescriptor.getDescriptor().getEnumTypes().get(1);
    }

    private static final ValueType[] VALUES = values();

    public static ValueType valueOf(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ValueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.MetricDescriptor.ValueType)
  }

  public interface MetricDescriptorMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.MetricDescriptor.MetricDescriptorMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Deprecated. Must use the
     * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
     * instead.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
     *
     * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is deprecated.
     *     See google/api/metric.proto;l=85
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Deprecated
    int getLaunchStageValue();
    /**
     *
     *
     * <pre>
     * Deprecated. Must use the
     * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
     * instead.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
     *
     * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is deprecated.
     *     See google/api/metric.proto;l=85
     * @return The launchStage.
     */
    @java.lang.Deprecated
    com.google.api.LaunchStage getLaunchStage();

    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     *
     * @return Whether the samplePeriod field is set.
     */
    boolean hasSamplePeriod();
    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     *
     * @return The samplePeriod.
     */
    com.google.protobuf.Duration getSamplePeriod();
    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getSamplePeriodOrBuilder();

    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     *
     * @return Whether the ingestDelay field is set.
     */
    boolean hasIngestDelay();
    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     *
     * @return The ingestDelay.
     */
    com.google.protobuf.Duration getIngestDelay();
    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getIngestDelayOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Additional annotations that can be used to guide the usage of a metric.
   * </pre>
   *
   * Protobuf type {@code google.api.MetricDescriptor.MetricDescriptorMetadata}
   */
  public static final class MetricDescriptorMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.MetricDescriptor.MetricDescriptorMetadata)
      MetricDescriptorMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MetricDescriptorMetadata.newBuilder() to construct.
    private MetricDescriptorMetadata(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MetricDescriptorMetadata() {
      launchStage_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MetricDescriptorMetadata();
    }

    @java.lang.Override
    public final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.MetricProto
          .internal_static_google_api_MetricDescriptor_MetricDescriptorMetadata_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MetricProto
          .internal_static_google_api_MetricDescriptor_MetricDescriptorMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.MetricDescriptor.MetricDescriptorMetadata.class,
              com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder.class);
    }

    public static final int LAUNCH_STAGE_FIELD_NUMBER = 1;
    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. Must use the
     * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
     * instead.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
     *
     * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is deprecated.
     *     See google/api/metric.proto;l=85
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Must use the
     * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
     * instead.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
     *
     * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is deprecated.
     *     See google/api/metric.proto;l=85
     * @return The launchStage.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.couchbase.client.core.deps.com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }

    public static final int SAMPLE_PERIOD_FIELD_NUMBER = 2;
    private com.couchbase.client.core.deps.com.google.protobuf.Duration samplePeriod_;
    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     *
     * @return Whether the samplePeriod field is set.
     */
    @java.lang.Override
    public boolean hasSamplePeriod() {
      return samplePeriod_ != null;
    }
    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     *
     * @return The samplePeriod.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Duration getSamplePeriod() {
      return samplePeriod_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : samplePeriod_;
    }
    /**
     *
     *
     * <pre>
     * The sampling period of metric data points. For metrics which are written
     * periodically, consecutive data points are stored at this time interval,
     * excluding data loss due to errors. Metrics with a higher granularity have
     * a smaller sampling period.
     * </pre>
     *
     * <code>.google.protobuf.Duration sample_period = 2;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getSamplePeriodOrBuilder() {
      return samplePeriod_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : samplePeriod_;
    }

    public static final int INGEST_DELAY_FIELD_NUMBER = 3;
    private com.couchbase.client.core.deps.com.google.protobuf.Duration ingestDelay_;
    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     *
     * @return Whether the ingestDelay field is set.
     */
    @java.lang.Override
    public boolean hasIngestDelay() {
      return ingestDelay_ != null;
    }
    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     *
     * @return The ingestDelay.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Duration getIngestDelay() {
      return ingestDelay_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : ingestDelay_;
    }
    /**
     *
     *
     * <pre>
     * The delay of data points caused by ingestion. Data points older than this
     * age are guaranteed to be ingested and available to be read, excluding
     * data loss due to errors.
     * </pre>
     *
     * <code>.google.protobuf.Duration ingest_delay = 3;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getIngestDelayOrBuilder() {
      return ingestDelay_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : ingestDelay_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, launchStage_);
      }
      if (samplePeriod_ != null) {
        output.writeMessage(2, getSamplePeriod());
      }
      if (ingestDelay_ != null) {
        output.writeMessage(3, getIngestDelay());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, launchStage_);
      }
      if (samplePeriod_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSamplePeriod());
      }
      if (ingestDelay_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIngestDelay());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.MetricDescriptor.MetricDescriptorMetadata)) {
        return super.equals(obj);
      }
      com.google.api.MetricDescriptor.MetricDescriptorMetadata other =
          (com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata) obj;

      if (launchStage_ != other.launchStage_) return false;
      if (hasSamplePeriod() != other.hasSamplePeriod()) return false;
      if (hasSamplePeriod()) {
        if (!getSamplePeriod().equals(other.getSamplePeriod())) return false;
      }
      if (hasIngestDelay() != other.hasIngestDelay()) return false;
      if (hasIngestDelay()) {
        if (!getIngestDelay().equals(other.getIngestDelay())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
      hash = (53 * hash) + launchStage_;
      if (hasSamplePeriod()) {
        hash = (37 * hash) + SAMPLE_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getSamplePeriod().hashCode();
      }
      if (hasIngestDelay()) {
        hash = (37 * hash) + INGEST_DELAY_FIELD_NUMBER;
        hash = (53 * hash) + getIngestDelay().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.api.MetricDescriptor.MetricDescriptorMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional annotations that can be used to guide the usage of a metric.
     * </pre>
     *
     * Protobuf type {@code google.api.MetricDescriptor.MetricDescriptorMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.MetricDescriptor.MetricDescriptorMetadata)
        com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder {
      public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.MetricProto
            .internal_static_google_api_MetricDescriptor_MetricDescriptorMetadata_descriptor;
      }

      @java.lang.Override
      protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.MetricProto
            .internal_static_google_api_MetricDescriptor_MetricDescriptorMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.MetricDescriptor.MetricDescriptorMetadata.class,
                com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder.class);
      }

      // Construct using com.google.api.MetricDescriptor.MetricDescriptorMetadata.newBuilder()
      private Builder() {}

      private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        launchStage_ = 0;
        samplePeriod_ = null;
        if (samplePeriodBuilder_ != null) {
          samplePeriodBuilder_.dispose();
          samplePeriodBuilder_ = null;
        }
        ingestDelay_ = null;
        if (ingestDelayBuilder_ != null) {
          ingestDelayBuilder_.dispose();
          ingestDelayBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.MetricProto
            .internal_static_google_api_MetricDescriptor_MetricDescriptorMetadata_descriptor;
      }

      @java.lang.Override
      public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata getDefaultInstanceForType() {
        return com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata build() {
        com.google.api.MetricDescriptor.MetricDescriptorMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata buildPartial() {
        com.google.api.MetricDescriptor.MetricDescriptorMetadata result =
            new com.google.api.MetricDescriptor.MetricDescriptorMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.launchStage_ = launchStage_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.samplePeriod_ =
              samplePeriodBuilder_ == null ? samplePeriod_ : samplePeriodBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.ingestDelay_ =
              ingestDelayBuilder_ == null ? ingestDelay_ : ingestDelayBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
        if (other instanceof com.google.api.MetricDescriptor.MetricDescriptorMetadata) {
          return mergeFrom((com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata other) {
        if (other == com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance())
          return this;
        if (other.launchStage_ != 0) {
          setLaunchStageValue(other.getLaunchStageValue());
        }
        if (other.hasSamplePeriod()) {
          mergeSamplePeriod(other.getSamplePeriod());
        }
        if (other.hasIngestDelay()) {
          mergeIngestDelay(other.getIngestDelay());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  launchStage_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getSamplePeriodFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getIngestDelayFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int launchStage_ = 0;
      /**
       *
       *
       * <pre>
       * Deprecated. Must use the
       * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
       * instead.
       * </pre>
       *
       * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
       *
       * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is
       *     deprecated. See google/api/metric.proto;l=85
       * @return The enum numeric value on the wire for launchStage.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public int getLaunchStageValue() {
        return launchStage_;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Must use the
       * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
       * instead.
       * </pre>
       *
       * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
       *
       * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is
       *     deprecated. See google/api/metric.proto;l=85
       * @param value The enum numeric value on the wire for launchStage to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setLaunchStageValue(int value) {
        launchStage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Must use the
       * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
       * instead.
       * </pre>
       *
       * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
       *
       * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is
       *     deprecated. See google/api/metric.proto;l=85
       * @return The launchStage.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.couchbase.client.core.deps.com.google.api.LaunchStage getLaunchStage() {
        com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
        return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Must use the
       * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
       * instead.
       * </pre>
       *
       * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
       *
       * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is
       *     deprecated. See google/api/metric.proto;l=85
       * @param value The launchStage to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setLaunchStage(com.couchbase.client.core.deps.com.google.api.LaunchStage value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        launchStage_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Must use the
       * [MetricDescriptor.launch_stage][google.api.MetricDescriptor.launch_stage]
       * instead.
       * </pre>
       *
       * <code>.google.api.LaunchStage launch_stage = 1 [deprecated = true];</code>
       *
       * @deprecated google.api.MetricDescriptor.MetricDescriptorMetadata.launch_stage is
       *     deprecated. See google/api/metric.proto;l=85
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearLaunchStage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        launchStage_ = 0;
        onChanged();
        return this;
      }

      private com.couchbase.client.core.deps.com.google.protobuf.Duration samplePeriod_;
      private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          samplePeriodBuilder_;
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       *
       * @return Whether the samplePeriod field is set.
       */
      public boolean hasSamplePeriod() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       *
       * @return The samplePeriod.
       */
      public com.couchbase.client.core.deps.com.google.protobuf.Duration getSamplePeriod() {
        if (samplePeriodBuilder_ == null) {
          return samplePeriod_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : samplePeriod_;
        } else {
          return samplePeriodBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public Builder setSamplePeriod(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
        if (samplePeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          samplePeriod_ = value;
        } else {
          samplePeriodBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public Builder setSamplePeriod(com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder builderForValue) {
        if (samplePeriodBuilder_ == null) {
          samplePeriod_ = builderForValue.build();
        } else {
          samplePeriodBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public Builder mergeSamplePeriod(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
        if (samplePeriodBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && samplePeriod_ != null
              && samplePeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getSamplePeriodBuilder().mergeFrom(value);
          } else {
            samplePeriod_ = value;
          }
        } else {
          samplePeriodBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public Builder clearSamplePeriod() {
        bitField0_ = (bitField0_ & ~0x00000002);
        samplePeriod_ = null;
        if (samplePeriodBuilder_ != null) {
          samplePeriodBuilder_.dispose();
          samplePeriodBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder getSamplePeriodBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSamplePeriodFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getSamplePeriodOrBuilder() {
        if (samplePeriodBuilder_ != null) {
          return samplePeriodBuilder_.getMessageOrBuilder();
        } else {
          return samplePeriod_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : samplePeriod_;
        }
      }
      /**
       *
       *
       * <pre>
       * The sampling period of metric data points. For metrics which are written
       * periodically, consecutive data points are stored at this time interval,
       * excluding data loss due to errors. Metrics with a higher granularity have
       * a smaller sampling period.
       * </pre>
       *
       * <code>.google.protobuf.Duration sample_period = 2;</code>
       */
      private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getSamplePeriodFieldBuilder() {
        if (samplePeriodBuilder_ == null) {
          samplePeriodBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getSamplePeriod(), getParentForChildren(), isClean());
          samplePeriod_ = null;
        }
        return samplePeriodBuilder_;
      }

      private com.couchbase.client.core.deps.com.google.protobuf.Duration ingestDelay_;
      private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          ingestDelayBuilder_;
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       *
       * @return Whether the ingestDelay field is set.
       */
      public boolean hasIngestDelay() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       *
       * @return The ingestDelay.
       */
      public com.couchbase.client.core.deps.com.google.protobuf.Duration getIngestDelay() {
        if (ingestDelayBuilder_ == null) {
          return ingestDelay_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : ingestDelay_;
        } else {
          return ingestDelayBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public Builder setIngestDelay(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
        if (ingestDelayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingestDelay_ = value;
        } else {
          ingestDelayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public Builder setIngestDelay(com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder builderForValue) {
        if (ingestDelayBuilder_ == null) {
          ingestDelay_ = builderForValue.build();
        } else {
          ingestDelayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public Builder mergeIngestDelay(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
        if (ingestDelayBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && ingestDelay_ != null
              && ingestDelay_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getIngestDelayBuilder().mergeFrom(value);
          } else {
            ingestDelay_ = value;
          }
        } else {
          ingestDelayBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public Builder clearIngestDelay() {
        bitField0_ = (bitField0_ & ~0x00000004);
        ingestDelay_ = null;
        if (ingestDelayBuilder_ != null) {
          ingestDelayBuilder_.dispose();
          ingestDelayBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder getIngestDelayBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getIngestDelayFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getIngestDelayOrBuilder() {
        if (ingestDelayBuilder_ != null) {
          return ingestDelayBuilder_.getMessageOrBuilder();
        } else {
          return ingestDelay_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : ingestDelay_;
        }
      }
      /**
       *
       *
       * <pre>
       * The delay of data points caused by ingestion. Data points older than this
       * age are guaranteed to be ingested and available to be read, excluding
       * data loss due to errors.
       * </pre>
       *
       * <code>.google.protobuf.Duration ingest_delay = 3;</code>
       */
      private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getIngestDelayFieldBuilder() {
        if (ingestDelayBuilder_ == null) {
          ingestDelayBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getIngestDelay(), getParentForChildren(), isClean());
          ingestDelay_ = null;
        }
        return ingestDelayBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.MetricDescriptor.MetricDescriptorMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.api.MetricDescriptor.MetricDescriptorMetadata)
    private static final com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.MetricDescriptor.MetricDescriptorMetadata();
    }

    public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptorMetadata> PARSER =
        new com.google.protobuf.AbstractParser<MetricDescriptorMetadata>() {
          @java.lang.Override
          public MetricDescriptorMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptorMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptorMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the metric descriptor.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the metric descriptor.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The metric type, including its DNS name prefix. The type is not
   * URL-encoded. All user-defined metric types have the DNS name
   * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
   * use a natural hierarchical grouping. For example:
   *     "custom.googleapis.com/invoice/paid/amount"
   *     "external.googleapis.com/prometheus/up"
   *     "appengine.googleapis.com/http/server/response_latencies"
   * </pre>
   *
   * <code>string type = 8;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The metric type, including its DNS name prefix. The type is not
   * URL-encoded. All user-defined metric types have the DNS name
   * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
   * use a natural hierarchical grouping. For example:
   *     "custom.googleapis.com/invoice/paid/amount"
   *     "external.googleapis.com/prometheus/up"
   *     "appengine.googleapis.com/http/server/response_latencies"
   * </pre>
   *
   * <code>string type = 8;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.LabelDescriptor> labels_;
  /**
   *
   *
   * <pre>
   * The set of labels that can be used to describe a specific
   * instance of this metric type. For example, the
   * `appengine.googleapis.com/http/server/response_latencies` metric
   * type has a label for the HTTP response code, `response_code`, so
   * you can look at latencies for successful responses or just
   * for responses that failed.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.LabelDescriptor> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that can be used to describe a specific
   * instance of this metric type. For example, the
   * `appengine.googleapis.com/http/server/response_latencies` metric
   * type has a label for the HTTP response code, `response_code`, so
   * you can look at latencies for successful responses or just
   * for responses that failed.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * The set of labels that can be used to describe a specific
   * instance of this metric type. For example, the
   * `appengine.googleapis.com/http/server/response_latencies` metric
   * type has a label for the HTTP response code, `response_code`, so
   * you can look at latencies for successful responses or just
   * for responses that failed.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of labels that can be used to describe a specific
   * instance of this metric type. For example, the
   * `appengine.googleapis.com/http/server/response_latencies` metric
   * type has a label for the HTTP response code, `response_code`, so
   * you can look at latencies for successful responses or just
   * for responses that failed.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LabelDescriptor getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of labels that can be used to describe a specific
   * instance of this metric type. For example, the
   * `appengine.googleapis.com/http/server/response_latencies` metric
   * type has a label for the HTTP response code, `response_code`, so
   * you can look at latencies for successful responses or just
   * for responses that failed.
   * </pre>
   *
   * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int METRIC_KIND_FIELD_NUMBER = 3;
  private int metricKind_ = 0;
  /**
   *
   *
   * <pre>
   * Whether the metric records instantaneous values, changes to a value, etc.
   * Some combinations of `metric_kind` and `value_type` might not be supported.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   *
   * @return The enum numeric value on the wire for metricKind.
   */
  @java.lang.Override
  public int getMetricKindValue() {
    return metricKind_;
  }
  /**
   *
   *
   * <pre>
   * Whether the metric records instantaneous values, changes to a value, etc.
   * Some combinations of `metric_kind` and `value_type` might not be supported.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   *
   * @return The metricKind.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricKind getMetricKind() {
    com.google.api.MetricDescriptor.MetricKind result =
        com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
    return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 4;
  private int valueType_ = 0;
  /**
   *
   *
   * <pre>
   * Whether the measurement is an integer, a floating-point number, etc.
   * Some combinations of `metric_kind` and `value_type` might not be supported.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * Whether the measurement is an integer, a floating-point number, etc.
   * Some combinations of `metric_kind` and `value_type` might not be supported.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.ValueType getValueType() {
    com.google.api.MetricDescriptor.ValueType result =
        com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
    return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
  }

  public static final int UNIT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object unit_ = "";
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported. It is only applicable
   * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
   * defines the representation of the stored metric values.
   * Different systems might scale the values to be more easily displayed (so a
   * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
   * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
   * `kBy`, then the value of the metric is always in thousands of bytes, no
   * matter how it might be displayed.
   * If you want a custom metric to record the exact number of CPU-seconds used
   * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
   * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
   * CPU-seconds, then the value is written as `12005`.
   * Alternatively, if you want a custom metric to record data in a more
   * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
   * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
   * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
   * The supported units are a subset of [The Unified Code for Units of
   * Measure](https://unitsofmeasure.org/ucum.html) standard:
   * **Basic units (UNIT)**
   * * `bit`   bit
   * * `By`    byte
   * * `s`     second
   * * `min`   minute
   * * `h`     hour
   * * `d`     day
   * * `1`     dimensionless
   * **Prefixes (PREFIX)**
   * * `k`     kilo    (10^3)
   * * `M`     mega    (10^6)
   * * `G`     giga    (10^9)
   * * `T`     tera    (10^12)
   * * `P`     peta    (10^15)
   * * `E`     exa     (10^18)
   * * `Z`     zetta   (10^21)
   * * `Y`     yotta   (10^24)
   * * `m`     milli   (10^-3)
   * * `u`     micro   (10^-6)
   * * `n`     nano    (10^-9)
   * * `p`     pico    (10^-12)
   * * `f`     femto   (10^-15)
   * * `a`     atto    (10^-18)
   * * `z`     zepto   (10^-21)
   * * `y`     yocto   (10^-24)
   * * `Ki`    kibi    (2^10)
   * * `Mi`    mebi    (2^20)
   * * `Gi`    gibi    (2^30)
   * * `Ti`    tebi    (2^40)
   * * `Pi`    pebi    (2^50)
   * **Grammar**
   * The grammar also includes these connectors:
   * * `/`    division or ratio (as an infix operator). For examples,
   *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
   *          have `/s` in a metric `unit`; rates should always be computed at
   *          query time from the underlying cumulative or delta value).
   * * `.`    multiplication or composition (as an infix operator). For
   *          examples, `GBy.d` or `k{watt}.h`.
   * The grammar for a unit is as follows:
   *     Expression = Component { "." Component } { "/" Component } ;
   *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
   *               | Annotation
   *               | "1"
   *               ;
   *     Annotation = "{" NAME "}" ;
   * Notes:
   * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
   *    is used alone, then the unit is equivalent to `1`. For examples,
   *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
   * * `NAME` is a sequence of non-blank printable ASCII characters not
   *    containing `{` or `}`.
   * * `1` represents a unitary [dimensionless
   *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
   *    as in `1/s`. It is typically used when none of the basic units are
   *    appropriate. For example, "new users per day" can be represented as
   *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
   *    users). Alternatively, "thousands of page views per day" would be
   *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
   *    value of `5.3` would mean "5300 page views per day").
   * * `%` represents dimensionless value of 1/100, and annotates values giving
   *    a percentage (so the metric values are typically in the range of 0..100,
   *    and a metric value `3` means "3 percent").
   * * `10^2.%` indicates a metric contains a ratio, typically in the range
   *    0..1, that will be multiplied by 100 and displayed as a percentage
   *    (so a metric value `0.03` means "3 percent").
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported. It is only applicable
   * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
   * defines the representation of the stored metric values.
   * Different systems might scale the values to be more easily displayed (so a
   * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
   * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
   * `kBy`, then the value of the metric is always in thousands of bytes, no
   * matter how it might be displayed.
   * If you want a custom metric to record the exact number of CPU-seconds used
   * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
   * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
   * CPU-seconds, then the value is written as `12005`.
   * Alternatively, if you want a custom metric to record data in a more
   * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
   * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
   * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
   * The supported units are a subset of [The Unified Code for Units of
   * Measure](https://unitsofmeasure.org/ucum.html) standard:
   * **Basic units (UNIT)**
   * * `bit`   bit
   * * `By`    byte
   * * `s`     second
   * * `min`   minute
   * * `h`     hour
   * * `d`     day
   * * `1`     dimensionless
   * **Prefixes (PREFIX)**
   * * `k`     kilo    (10^3)
   * * `M`     mega    (10^6)
   * * `G`     giga    (10^9)
   * * `T`     tera    (10^12)
   * * `P`     peta    (10^15)
   * * `E`     exa     (10^18)
   * * `Z`     zetta   (10^21)
   * * `Y`     yotta   (10^24)
   * * `m`     milli   (10^-3)
   * * `u`     micro   (10^-6)
   * * `n`     nano    (10^-9)
   * * `p`     pico    (10^-12)
   * * `f`     femto   (10^-15)
   * * `a`     atto    (10^-18)
   * * `z`     zepto   (10^-21)
   * * `y`     yocto   (10^-24)
   * * `Ki`    kibi    (2^10)
   * * `Mi`    mebi    (2^20)
   * * `Gi`    gibi    (2^30)
   * * `Ti`    tebi    (2^40)
   * * `Pi`    pebi    (2^50)
   * **Grammar**
   * The grammar also includes these connectors:
   * * `/`    division or ratio (as an infix operator). For examples,
   *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
   *          have `/s` in a metric `unit`; rates should always be computed at
   *          query time from the underlying cumulative or delta value).
   * * `.`    multiplication or composition (as an infix operator). For
   *          examples, `GBy.d` or `k{watt}.h`.
   * The grammar for a unit is as follows:
   *     Expression = Component { "." Component } { "/" Component } ;
   *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
   *               | Annotation
   *               | "1"
   *               ;
   *     Annotation = "{" NAME "}" ;
   * Notes:
   * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
   *    is used alone, then the unit is equivalent to `1`. For examples,
   *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
   * * `NAME` is a sequence of non-blank printable ASCII characters not
   *    containing `{` or `}`.
   * * `1` represents a unitary [dimensionless
   *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
   *    as in `1/s`. It is typically used when none of the basic units are
   *    appropriate. For example, "new users per day" can be represented as
   *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
   *    users). Alternatively, "thousands of page views per day" would be
   *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
   *    value of `5.3` would mean "5300 page views per day").
   * * `%` represents dimensionless value of 1/100, and annotates values giving
   *    a percentage (so the metric values are typically in the range of 0..100,
   *    and a metric value `3` means "3 percent").
   * * `10^2.%` indicates a metric contains a ratio, typically in the range
   *    0..1, that will be multiplied by 100 and displayed as a percentage
   *    (so a metric value `0.03` means "3 percent").
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A detailed description of the metric, which can be used in documentation.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A detailed description of the metric, which can be used in documentation.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * A concise name for the metric, which can be displayed in user interfaces.
   * Use sentence case without an ending period, for example "Request count".
   * This field is optional but it is recommended to be set for any metrics
   * associated with user-visible concepts, such as Quota.
   * </pre>
   *
   * <code>string display_name = 7;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A concise name for the metric, which can be displayed in user interfaces.
   * Use sentence case without an ending period, for example "Request count".
   * This field is optional but it is recommended to be set for any metrics
   * associated with user-visible concepts, such as Quota.
   * </pre>
   *
   * <code>string display_name = 7;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 10;
  private com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Optional. Metadata which can be used to guide usage of the metric.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Metadata which can be used to guide usage of the metric.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata getMetadata() {
    return metadata_ == null
        ? com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Metadata which can be used to guide usage of the metric.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 12;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the metric definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 12;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The launch stage of the metric definition.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 12;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LaunchStage getLaunchStage() {
    com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int MONITORED_RESOURCE_TYPES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.couchbase.client.core.deps.com.google.protobuf.LazyStringList monitoredResourceTypes_;
  /**
   *
   *
   * <pre>
   * Read-only. If present, then a [time
   * series][google.monitoring.v3.TimeSeries], which is identified partially by
   * a metric type and a
   * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
   * is associated with this metric type can only be associated with one of the
   * monitored resource types listed here.
   * </pre>
   *
   * <code>repeated string monitored_resource_types = 13;</code>
   *
   * @return A list containing the monitoredResourceTypes.
   */
  public com.couchbase.client.core.deps.com.google.protobuf.ProtocolStringList getMonitoredResourceTypesList() {
    return monitoredResourceTypes_;
  }
  /**
   *
   *
   * <pre>
   * Read-only. If present, then a [time
   * series][google.monitoring.v3.TimeSeries], which is identified partially by
   * a metric type and a
   * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
   * is associated with this metric type can only be associated with one of the
   * monitored resource types listed here.
   * </pre>
   *
   * <code>repeated string monitored_resource_types = 13;</code>
   *
   * @return The count of monitoredResourceTypes.
   */
  public int getMonitoredResourceTypesCount() {
    return monitoredResourceTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Read-only. If present, then a [time
   * series][google.monitoring.v3.TimeSeries], which is identified partially by
   * a metric type and a
   * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
   * is associated with this metric type can only be associated with one of the
   * monitored resource types listed here.
   * </pre>
   *
   * <code>repeated string monitored_resource_types = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The monitoredResourceTypes at the given index.
   */
  public java.lang.String getMonitoredResourceTypes(int index) {
    return monitoredResourceTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Read-only. If present, then a [time
   * series][google.monitoring.v3.TimeSeries], which is identified partially by
   * a metric type and a
   * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
   * is associated with this metric type can only be associated with one of the
   * monitored resource types listed here.
   * </pre>
   *
   * <code>repeated string monitored_resource_types = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the monitoredResourceTypes at the given index.
   */
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getMonitoredResourceTypesBytes(int index) {
    return monitoredResourceTypes_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(2, labels_.get(i));
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, metricKind_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, valueType_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, unit_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, displayName_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, type_);
    }
    if (metadata_ != null) {
      output.writeMessage(10, getMetadata());
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, launchStage_);
    }
    for (int i = 0; i < monitoredResourceTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 13, monitoredResourceTypes_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels_.get(i));
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, metricKind_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, valueType_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, unit_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, displayName_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, type_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMetadata());
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, launchStage_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < monitoredResourceTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(monitoredResourceTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMonitoredResourceTypesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.MetricDescriptor)) {
      return super.equals(obj);
    }
    com.google.api.MetricDescriptor other = (com.couchbase.client.core.deps.com.google.api.MetricDescriptor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (metricKind_ != other.metricKind_) return false;
    if (valueType_ != other.valueType_) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (launchStage_ != other.launchStage_) return false;
    if (!getMonitoredResourceTypesList().equals(other.getMonitoredResourceTypesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    hash = (37 * hash) + METRIC_KIND_FIELD_NUMBER;
    hash = (53 * hash) + metricKind_;
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    if (getMonitoredResourceTypesCount() > 0) {
      hash = (37 * hash) + MONITORED_RESOURCE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResourceTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(com.couchbase.client.core.deps.com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.couchbase.client.core.deps.com.google.api.MetricDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a metric type and its schema. Once a metric descriptor is created,
   * deleting or altering it stops data collection and makes the metric type's
   * existing data unusable.
   * </pre>
   *
   * Protobuf type {@code google.api.MetricDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.MetricDescriptor)
      com.google.api.MetricDescriptorOrBuilder {
    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.MetricProto.internal_static_google_api_MetricDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MetricProto
          .internal_static_google_api_MetricDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.MetricDescriptor.class, com.google.api.MetricDescriptor.Builder.class);
    }

    // Construct using com.google.api.MetricDescriptor.newBuilder()
    private Builder() {}

    private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = "";
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
      } else {
        labels_ = null;
        labelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      metricKind_ = 0;
      valueType_ = 0;
      unit_ = "";
      description_ = "";
      displayName_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      launchStage_ = 0;
      monitoredResourceTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.MetricProto.internal_static_google_api_MetricDescriptor_descriptor;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor getDefaultInstanceForType() {
      return com.google.api.MetricDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor build() {
      com.google.api.MetricDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor buildPartial() {
      com.google.api.MetricDescriptor result = new com.google.api.MetricDescriptor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.couchbase.client.core.deps.com.google.api.MetricDescriptor result) {
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        monitoredResourceTypes_ = monitoredResourceTypes_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.monitoredResourceTypes_ = monitoredResourceTypes_;
    }

    private void buildPartial0(com.couchbase.client.core.deps.com.google.api.MetricDescriptor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metricKind_ = metricKind_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.valueType_ = valueType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.unit_ = unit_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.launchStage_ = launchStage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.MetricDescriptor) {
        return mergeFrom((com.couchbase.client.core.deps.com.google.api.MetricDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.api.MetricDescriptor other) {
      if (other == com.google.api.MetricDescriptor.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000004);
            labelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (other.metricKind_ != 0) {
        setMetricKindValue(other.getMetricKindValue());
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (!other.monitoredResourceTypes_.isEmpty()) {
        if (monitoredResourceTypes_.isEmpty()) {
          monitoredResourceTypes_ = other.monitoredResourceTypes_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureMonitoredResourceTypesIsMutable();
          monitoredResourceTypes_.addAll(other.monitoredResourceTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.api.LabelDescriptor m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.api.LabelDescriptor.parser(), extensionRegistry);
                if (labelsBuilder_ == null) {
                  ensureLabelsIsMutable();
                  labels_.add(m);
                } else {
                  labelsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                metricKind_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                unit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 96:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMonitoredResourceTypesIsMutable();
                monitoredResourceTypes_.add(s);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the metric descriptor.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the metric descriptor.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the metric descriptor.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the metric descriptor.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the metric descriptor.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded. All user-defined metric types have the DNS name
     * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
     * use a natural hierarchical grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "external.googleapis.com/prometheus/up"
     *     "appengine.googleapis.com/http/server/response_latencies"
     * </pre>
     *
     * <code>string type = 8;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded. All user-defined metric types have the DNS name
     * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
     * use a natural hierarchical grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "external.googleapis.com/prometheus/up"
     *     "appengine.googleapis.com/http/server/response_latencies"
     * </pre>
     *
     * <code>string type = 8;</code>
     *
     * @return The bytes for type.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded. All user-defined metric types have the DNS name
     * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
     * use a natural hierarchical grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "external.googleapis.com/prometheus/up"
     *     "appengine.googleapis.com/http/server/response_latencies"
     * </pre>
     *
     * <code>string type = 8;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded. All user-defined metric types have the DNS name
     * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
     * use a natural hierarchical grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "external.googleapis.com/prometheus/up"
     *     "appengine.googleapis.com/http/server/response_latencies"
     * </pre>
     *
     * <code>string type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded. All user-defined metric types have the DNS name
     * `custom.googleapis.com` or `external.googleapis.com`. Metric types should
     * use a natural hierarchical grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "external.googleapis.com/prometheus/up"
     *     "appengine.googleapis.com/http/server/response_latencies"
     * </pre>
     *
     * <code>string type = 8;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.LabelDescriptor> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        labels_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.LabelDescriptor>(labels_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.LabelDescriptor> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LabelDescriptor getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder setLabels(int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(com.couchbase.client.core.deps.com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, com.google.api.LabelDescriptor value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(com.couchbase.client.core.deps.com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addLabels(int index, com.google.api.LabelDescriptor.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends com.google.api.LabelDescriptor> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LabelDescriptor.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LabelDescriptorOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<? extends com.google.api.LabelDescriptorOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LabelDescriptor.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(com.couchbase.client.core.deps.com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LabelDescriptor.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, com.google.api.LabelDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     * </pre>
     *
     * <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.LabelDescriptor.Builder> getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LabelDescriptor,
            com.google.api.LabelDescriptor.Builder,
            com.google.api.LabelDescriptorOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.LabelDescriptor,
                com.google.api.LabelDescriptor.Builder,
                com.google.api.LabelDescriptorOrBuilder>(
                labels_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private int metricKind_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The enum numeric value on the wire for metricKind.
     */
    @java.lang.Override
    public int getMetricKindValue() {
      return metricKind_;
    }
    /**
     *
     *
     * <pre>
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @param value The enum numeric value on the wire for metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKindValue(int value) {
      metricKind_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The metricKind.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricKind getMetricKind() {
      com.google.api.MetricDescriptor.MetricKind result =
          com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
      return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @param value The metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKind(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricKind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      metricKind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricKind() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metricKind_ = 0;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.ValueType getValueType() {
      com.google.api.MetricDescriptor.ValueType result =
          com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
      return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * Different systems might scale the values to be more easily displayed (so a
     * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
     * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
     * `kBy`, then the value of the metric is always in thousands of bytes, no
     * matter how it might be displayed.
     * If you want a custom metric to record the exact number of CPU-seconds used
     * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
     * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
     * CPU-seconds, then the value is written as `12005`.
     * Alternatively, if you want a custom metric to record data in a more
     * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
     * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
     * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
     * The supported units are a subset of [The Unified Code for Units of
     * Measure](https://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * * `1`     dimensionless
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10^3)
     * * `M`     mega    (10^6)
     * * `G`     giga    (10^9)
     * * `T`     tera    (10^12)
     * * `P`     peta    (10^15)
     * * `E`     exa     (10^18)
     * * `Z`     zetta   (10^21)
     * * `Y`     yotta   (10^24)
     * * `m`     milli   (10^-3)
     * * `u`     micro   (10^-6)
     * * `n`     nano    (10^-9)
     * * `p`     pico    (10^-12)
     * * `f`     femto   (10^-15)
     * * `a`     atto    (10^-18)
     * * `z`     zepto   (10^-21)
     * * `y`     yocto   (10^-24)
     * * `Ki`    kibi    (2^10)
     * * `Mi`    mebi    (2^20)
     * * `Gi`    gibi    (2^30)
     * * `Ti`    tebi    (2^40)
     * * `Pi`    pebi    (2^50)
     * **Grammar**
     * The grammar also includes these connectors:
     * * `/`    division or ratio (as an infix operator). For examples,
     *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
     *          have `/s` in a metric `unit`; rates should always be computed at
     *          query time from the underlying cumulative or delta value).
     * * `.`    multiplication or composition (as an infix operator). For
     *          examples, `GBy.d` or `k{watt}.h`.
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
     *    is used alone, then the unit is equivalent to `1`. For examples,
     *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing `{` or `}`.
     * * `1` represents a unitary [dimensionless
     *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
     *    as in `1/s`. It is typically used when none of the basic units are
     *    appropriate. For example, "new users per day" can be represented as
     *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
     *    users). Alternatively, "thousands of page views per day" would be
     *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
     *    value of `5.3` would mean "5300 page views per day").
     * * `%` represents dimensionless value of 1/100, and annotates values giving
     *    a percentage (so the metric values are typically in the range of 0..100,
     *    and a metric value `3` means "3 percent").
     * * `10^2.%` indicates a metric contains a ratio, typically in the range
     *    0..1, that will be multiplied by 100 and displayed as a percentage
     *    (so a metric value `0.03` means "3 percent").
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * Different systems might scale the values to be more easily displayed (so a
     * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
     * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
     * `kBy`, then the value of the metric is always in thousands of bytes, no
     * matter how it might be displayed.
     * If you want a custom metric to record the exact number of CPU-seconds used
     * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
     * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
     * CPU-seconds, then the value is written as `12005`.
     * Alternatively, if you want a custom metric to record data in a more
     * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
     * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
     * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
     * The supported units are a subset of [The Unified Code for Units of
     * Measure](https://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * * `1`     dimensionless
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10^3)
     * * `M`     mega    (10^6)
     * * `G`     giga    (10^9)
     * * `T`     tera    (10^12)
     * * `P`     peta    (10^15)
     * * `E`     exa     (10^18)
     * * `Z`     zetta   (10^21)
     * * `Y`     yotta   (10^24)
     * * `m`     milli   (10^-3)
     * * `u`     micro   (10^-6)
     * * `n`     nano    (10^-9)
     * * `p`     pico    (10^-12)
     * * `f`     femto   (10^-15)
     * * `a`     atto    (10^-18)
     * * `z`     zepto   (10^-21)
     * * `y`     yocto   (10^-24)
     * * `Ki`    kibi    (2^10)
     * * `Mi`    mebi    (2^20)
     * * `Gi`    gibi    (2^30)
     * * `Ti`    tebi    (2^40)
     * * `Pi`    pebi    (2^50)
     * **Grammar**
     * The grammar also includes these connectors:
     * * `/`    division or ratio (as an infix operator). For examples,
     *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
     *          have `/s` in a metric `unit`; rates should always be computed at
     *          query time from the underlying cumulative or delta value).
     * * `.`    multiplication or composition (as an infix operator). For
     *          examples, `GBy.d` or `k{watt}.h`.
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
     *    is used alone, then the unit is equivalent to `1`. For examples,
     *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing `{` or `}`.
     * * `1` represents a unitary [dimensionless
     *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
     *    as in `1/s`. It is typically used when none of the basic units are
     *    appropriate. For example, "new users per day" can be represented as
     *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
     *    users). Alternatively, "thousands of page views per day" would be
     *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
     *    value of `5.3` would mean "5300 page views per day").
     * * `%` represents dimensionless value of 1/100, and annotates values giving
     *    a percentage (so the metric values are typically in the range of 0..100,
     *    and a metric value `3` means "3 percent").
     * * `10^2.%` indicates a metric contains a ratio, typically in the range
     *    0..1, that will be multiplied by 100 and displayed as a percentage
     *    (so a metric value `0.03` means "3 percent").
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The bytes for unit.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * Different systems might scale the values to be more easily displayed (so a
     * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
     * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
     * `kBy`, then the value of the metric is always in thousands of bytes, no
     * matter how it might be displayed.
     * If you want a custom metric to record the exact number of CPU-seconds used
     * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
     * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
     * CPU-seconds, then the value is written as `12005`.
     * Alternatively, if you want a custom metric to record data in a more
     * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
     * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
     * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
     * The supported units are a subset of [The Unified Code for Units of
     * Measure](https://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * * `1`     dimensionless
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10^3)
     * * `M`     mega    (10^6)
     * * `G`     giga    (10^9)
     * * `T`     tera    (10^12)
     * * `P`     peta    (10^15)
     * * `E`     exa     (10^18)
     * * `Z`     zetta   (10^21)
     * * `Y`     yotta   (10^24)
     * * `m`     milli   (10^-3)
     * * `u`     micro   (10^-6)
     * * `n`     nano    (10^-9)
     * * `p`     pico    (10^-12)
     * * `f`     femto   (10^-15)
     * * `a`     atto    (10^-18)
     * * `z`     zepto   (10^-21)
     * * `y`     yocto   (10^-24)
     * * `Ki`    kibi    (2^10)
     * * `Mi`    mebi    (2^20)
     * * `Gi`    gibi    (2^30)
     * * `Ti`    tebi    (2^40)
     * * `Pi`    pebi    (2^50)
     * **Grammar**
     * The grammar also includes these connectors:
     * * `/`    division or ratio (as an infix operator). For examples,
     *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
     *          have `/s` in a metric `unit`; rates should always be computed at
     *          query time from the underlying cumulative or delta value).
     * * `.`    multiplication or composition (as an infix operator). For
     *          examples, `GBy.d` or `k{watt}.h`.
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
     *    is used alone, then the unit is equivalent to `1`. For examples,
     *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing `{` or `}`.
     * * `1` represents a unitary [dimensionless
     *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
     *    as in `1/s`. It is typically used when none of the basic units are
     *    appropriate. For example, "new users per day" can be represented as
     *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
     *    users). Alternatively, "thousands of page views per day" would be
     *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
     *    value of `5.3` would mean "5300 page views per day").
     * * `%` represents dimensionless value of 1/100, and annotates values giving
     *    a percentage (so the metric values are typically in the range of 0..100,
     *    and a metric value `3` means "3 percent").
     * * `10^2.%` indicates a metric contains a ratio, typically in the range
     *    0..1, that will be multiplied by 100 and displayed as a percentage
     *    (so a metric value `0.03` means "3 percent").
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      unit_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * Different systems might scale the values to be more easily displayed (so a
     * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
     * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
     * `kBy`, then the value of the metric is always in thousands of bytes, no
     * matter how it might be displayed.
     * If you want a custom metric to record the exact number of CPU-seconds used
     * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
     * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
     * CPU-seconds, then the value is written as `12005`.
     * Alternatively, if you want a custom metric to record data in a more
     * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
     * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
     * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
     * The supported units are a subset of [The Unified Code for Units of
     * Measure](https://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * * `1`     dimensionless
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10^3)
     * * `M`     mega    (10^6)
     * * `G`     giga    (10^9)
     * * `T`     tera    (10^12)
     * * `P`     peta    (10^15)
     * * `E`     exa     (10^18)
     * * `Z`     zetta   (10^21)
     * * `Y`     yotta   (10^24)
     * * `m`     milli   (10^-3)
     * * `u`     micro   (10^-6)
     * * `n`     nano    (10^-9)
     * * `p`     pico    (10^-12)
     * * `f`     femto   (10^-15)
     * * `a`     atto    (10^-18)
     * * `z`     zepto   (10^-21)
     * * `y`     yocto   (10^-24)
     * * `Ki`    kibi    (2^10)
     * * `Mi`    mebi    (2^20)
     * * `Gi`    gibi    (2^30)
     * * `Ti`    tebi    (2^40)
     * * `Pi`    pebi    (2^50)
     * **Grammar**
     * The grammar also includes these connectors:
     * * `/`    division or ratio (as an infix operator). For examples,
     *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
     *          have `/s` in a metric `unit`; rates should always be computed at
     *          query time from the underlying cumulative or delta value).
     * * `.`    multiplication or composition (as an infix operator). For
     *          examples, `GBy.d` or `k{watt}.h`.
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
     *    is used alone, then the unit is equivalent to `1`. For examples,
     *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing `{` or `}`.
     * * `1` represents a unitary [dimensionless
     *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
     *    as in `1/s`. It is typically used when none of the basic units are
     *    appropriate. For example, "new users per day" can be represented as
     *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
     *    users). Alternatively, "thousands of page views per day" would be
     *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
     *    value of `5.3` would mean "5300 page views per day").
     * * `%` represents dimensionless value of 1/100, and annotates values giving
     *    a percentage (so the metric values are typically in the range of 0..100,
     *    and a metric value `3` means "3 percent").
     * * `10^2.%` indicates a metric contains a ratio, typically in the range
     *    0..1, that will be multiplied by 100 and displayed as a percentage
     *    (so a metric value `0.03` means "3 percent").
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {
      unit_ = getDefaultInstance().getUnit();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * Different systems might scale the values to be more easily displayed (so a
     * value of `0.02kBy` _might_ be displayed as `20By`, and a value of
     * `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is
     * `kBy`, then the value of the metric is always in thousands of bytes, no
     * matter how it might be displayed.
     * If you want a custom metric to record the exact number of CPU-seconds used
     * by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is
     * `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005
     * CPU-seconds, then the value is written as `12005`.
     * Alternatively, if you want a custom metric to record data in a more
     * granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is
     * `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`),
     * or use `Kis{CPU}` and write `11.723` (which is `12005/1024`).
     * The supported units are a subset of [The Unified Code for Units of
     * Measure](https://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * * `1`     dimensionless
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10^3)
     * * `M`     mega    (10^6)
     * * `G`     giga    (10^9)
     * * `T`     tera    (10^12)
     * * `P`     peta    (10^15)
     * * `E`     exa     (10^18)
     * * `Z`     zetta   (10^21)
     * * `Y`     yotta   (10^24)
     * * `m`     milli   (10^-3)
     * * `u`     micro   (10^-6)
     * * `n`     nano    (10^-9)
     * * `p`     pico    (10^-12)
     * * `f`     femto   (10^-15)
     * * `a`     atto    (10^-18)
     * * `z`     zepto   (10^-21)
     * * `y`     yocto   (10^-24)
     * * `Ki`    kibi    (2^10)
     * * `Mi`    mebi    (2^20)
     * * `Gi`    gibi    (2^30)
     * * `Ti`    tebi    (2^40)
     * * `Pi`    pebi    (2^50)
     * **Grammar**
     * The grammar also includes these connectors:
     * * `/`    division or ratio (as an infix operator). For examples,
     *          `kBy/{email}` or `MiBy/10ms` (although you should almost never
     *          have `/s` in a metric `unit`; rates should always be computed at
     *          query time from the underlying cumulative or delta value).
     * * `.`    multiplication or composition (as an infix operator). For
     *          examples, `GBy.d` or `k{watt}.h`.
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT`. If the annotation
     *    is used alone, then the unit is equivalent to `1`. For examples,
     *    `{request}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing `{` or `}`.
     * * `1` represents a unitary [dimensionless
     *    unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such
     *    as in `1/s`. It is typically used when none of the basic units are
     *    appropriate. For example, "new users per day" can be represented as
     *    `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new
     *    users). Alternatively, "thousands of page views per day" would be
     *    represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric
     *    value of `5.3` would mean "5300 page views per day").
     * * `%` represents dimensionless value of 1/100, and annotates values giving
     *    a percentage (so the metric values are typically in the range of 0..100,
     *    and a metric value `3` means "3 percent").
     * * `10^2.%` indicates a metric contains a ratio, typically in the range
     *    0..1, that will be multiplied by 100 and displayed as a percentage
     *    (so a metric value `0.03` means "3 percent").
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      unit_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A detailed description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A detailed description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A detailed description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A detailed description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A detailed description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     * This field is optional but it is recommended to be set for any metrics
     * associated with user-visible concepts, such as Quota.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     * This field is optional but it is recommended to be set for any metrics
     * associated with user-visible concepts, such as Quota.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return The bytes for displayName.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     * This field is optional but it is recommended to be set for any metrics
     * associated with user-visible concepts, such as Quota.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     * This field is optional but it is recommended to be set for any metrics
     * associated with user-visible concepts, such as Quota.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     * This field is optional but it is recommended to be set for any metrics
     * associated with user-visible concepts, such as Quota.
     * </pre>
     *
     * <code>string display_name = 7;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata metadata_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor.MetricDescriptorMetadata,
            com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder,
            com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     *
     * @return The metadata.
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public Builder setMetadata(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public Builder setMetadata(
        com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public Builder mergeMetadata(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && metadata_ != null
            && metadata_
                != com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder
        getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.api.MetricDescriptor.MetricDescriptorMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata which can be used to guide usage of the metric.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricDescriptorMetadata metadata = 10;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor.MetricDescriptorMetadata,
            com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder,
            com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MetricDescriptor.MetricDescriptorMetadata,
                com.google.api.MetricDescriptor.MetricDescriptorMetadata.Builder,
                com.google.api.MetricDescriptor.MetricDescriptorMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the metric definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 12;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the metric definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 12;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the metric definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 12;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the metric definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 12;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.couchbase.client.core.deps.com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The launch stage of the metric definition.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00000200);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.LazyStringList monitoredResourceTypes_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureMonitoredResourceTypesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        monitoredResourceTypes_ =
            new com.google.protobuf.LazyStringArrayList(monitoredResourceTypes_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @return A list containing the monitoredResourceTypes.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ProtocolStringList getMonitoredResourceTypesList() {
      return monitoredResourceTypes_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @return The count of monitoredResourceTypes.
     */
    public int getMonitoredResourceTypesCount() {
      return monitoredResourceTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The monitoredResourceTypes at the given index.
     */
    public java.lang.String getMonitoredResourceTypes(int index) {
      return monitoredResourceTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the monitoredResourceTypes at the given index.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getMonitoredResourceTypesBytes(int index) {
      return monitoredResourceTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The monitoredResourceTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMonitoredResourceTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMonitoredResourceTypesIsMutable();
      monitoredResourceTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param value The monitoredResourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMonitoredResourceTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMonitoredResourceTypesIsMutable();
      monitoredResourceTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param values The monitoredResourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMonitoredResourceTypes(java.lang.Iterable<java.lang.String> values) {
      ensureMonitoredResourceTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoredResourceTypes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMonitoredResourceTypes() {
      monitoredResourceTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Read-only. If present, then a [time
     * series][google.monitoring.v3.TimeSeries], which is identified partially by
     * a metric type and a
     * [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor], that
     * is associated with this metric type can only be associated with one of the
     * monitored resource types listed here.
     * </pre>
     *
     * <code>repeated string monitored_resource_types = 13;</code>
     *
     * @param value The bytes of the monitoredResourceTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMonitoredResourceTypesBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMonitoredResourceTypesIsMutable();
      monitoredResourceTypes_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.MetricDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.api.MetricDescriptor)
  private static final com.couchbase.client.core.deps.com.google.api.MetricDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.MetricDescriptor();
  }

  public static com.couchbase.client.core.deps.com.google.api.MetricDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<MetricDescriptor>() {
        @java.lang.Override
        public MetricDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Parser<MetricDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
