/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.couchbase.client.core.deps.org.jctools.queues.unpadded;

import static com.couchbase.client.core.deps.org.jctools.util.UnsafeLongArrayAccess.*;
import com.couchbase.client.core.deps.org.jctools.queues.*;

/**
 * NOTE: This class was automatically generated by org.jctools.queues.unpadded.JavaParsingUnpaddedQueueGenerator
 * which can found in the jctools-build module. The original source file is ConcurrentSequencedCircularArrayQueue.java.
 */
public abstract class ConcurrentSequencedCircularUnpaddedArrayQueue<E> extends ConcurrentCircularUnpaddedArrayQueue<E> {

    protected final long[] sequenceBuffer;

    public ConcurrentSequencedCircularUnpaddedArrayQueue(int capacity) {
        super(capacity);
        int actualCapacity = (int) (this.mask + 1);
        // pad data on either end with some empty slots. Note that actualCapacity is <= MAX_POW2_INT
        sequenceBuffer = allocateLongArray(actualCapacity);
        for (long i = 0; i < actualCapacity; i++) {
            soLongElement(sequenceBuffer, calcCircularLongElementOffset(i, mask), i);
        }
    }
}
