/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.facet;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import reactor.util.annotation.Nullable;

@Stability.Internal
public abstract class CoreSearchFacet {
    private final String field;
    @Nullable
    private final Integer size;

    CoreSearchFacet(String field, @Nullable Integer size) {
        this.field = Validators.notNullOrEmpty(field, "Field");
        this.size = size;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public void injectParams(ObjectNode queryJson) {
        if (this.size != null) {
            queryJson.put("size", this.size);
        }
        queryJson.put("field", this.field);
    }
}

