/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.io.netty.SslHandlerFactory;
import com.couchbase.client.core.util.Bytes;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SecurityConfig {
    private final boolean nativeTlsEnabled;
    private final boolean hostnameVerificationEnabled;
    private final boolean tlsEnabled;
    private final List<X509Certificate> trustCertificates;
    private final TrustManagerFactory trustManagerFactory;
    private final List<String> ciphers;
    private final boolean userSpecifiedTrustSource;

    public static Builder builder() {
        return new Builder();
    }

    public static SecurityConfig create() {
        return new SecurityConfig(SecurityConfig.builder());
    }

    public static Builder enableTls(boolean tlsEnabled) {
        return SecurityConfig.builder().enableTls(tlsEnabled);
    }

    public static Builder enableHostnameVerification(boolean hostnameVerificationEnabled) {
        return SecurityConfig.builder().enableHostnameVerification(hostnameVerificationEnabled);
    }

    public static Builder enableNativeTls(boolean nativeTlsEnabled) {
        return SecurityConfig.builder().enableNativeTls(nativeTlsEnabled);
    }

    public static Builder trustCertificates(List<X509Certificate> certificates) {
        return SecurityConfig.builder().trustCertificates(certificates);
    }

    public static Builder trustCertificate(Path certificatePath) {
        return SecurityConfig.builder().trustCertificate(certificatePath);
    }

    public static Builder trustStore(KeyStore trustStore) {
        return SecurityConfig.builder().trustStore(trustStore);
    }

    public static Builder trustStore(Path trustStorePath, String trustStorePassword, Optional<String> trustStoreType) {
        return SecurityConfig.builder().trustStore(trustStorePath, trustStorePassword, trustStoreType);
    }

    public static Builder trustManagerFactory(TrustManagerFactory trustManagerFactory) {
        return SecurityConfig.builder().trustManagerFactory(trustManagerFactory);
    }

    public static Builder ciphers(List<String> ciphers) {
        return SecurityConfig.builder().ciphers(ciphers);
    }

    private SecurityConfig(Builder builder) {
        this.tlsEnabled = builder.tlsEnabled;
        this.nativeTlsEnabled = builder.nativeTlsEnabled;
        this.trustManagerFactory = builder.certificateVerificationEnabled ? builder.trustManagerFactory : InsecureTrustManagerFactory.INSTANCE;
        this.hostnameVerificationEnabled = builder.hostnameVerificationEnabled;
        this.ciphers = builder.ciphers;
        if (!this.tlsEnabled) {
            this.trustCertificates = builder.trustCertificates;
            this.userSpecifiedTrustSource = true;
            return;
        }
        if (builder.trustCertificates != null && builder.trustManagerFactory != null) {
            throw InvalidArgumentException.fromMessage("Either trust certificates or a trust manager factory can be provided, but not both!");
        }
        if (!builder.certificateVerificationEnabled) {
            this.userSpecifiedTrustSource = true;
            this.trustCertificates = null;
            return;
        }
        this.userSpecifiedTrustSource = builder.trustCertificates != null || builder.trustManagerFactory != null;
        this.trustCertificates = this.userSpecifiedTrustSource ? builder.trustCertificates : SecurityConfig.defaultCaCertificates();
    }

    public boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public boolean hostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    public List<X509Certificate> trustCertificates() {
        return this.trustCertificates;
    }

    public TrustManagerFactory trustManagerFactory() {
        return this.trustManagerFactory;
    }

    public boolean nativeTlsEnabled() {
        return this.nativeTlsEnabled;
    }

    public List<String> ciphers() {
        return this.ciphers;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("tlsEnabled", this.tlsEnabled);
        export.put("nativeTlsEnabled", this.nativeTlsEnabled);
        export.put("hostnameVerificationEnabled", this.hostnameVerificationEnabled);
        export.put("trustCertificates", this.trustCertificates != null ? this.trustCertificatesToString() : null);
        export.put("trustManagerFactory", this.trustManagerFactory != null ? this.trustManagerFactory.getClass().getSimpleName() : null);
        export.put("ciphers", this.ciphers);
        return export;
    }

    public static List<X509Certificate> decodeCertificates(List<String> certificates) {
        Validators.notNull(certificates, "Certificates");
        return certificates.stream().flatMap(it -> SecurityConfig.decodeCertificates(it.getBytes(StandardCharsets.UTF_8)).stream()).collect(Collectors.toList());
    }

    private static List<X509Certificate> decodeCertificates(byte[] bytes) {
        Validators.notNull(bytes, "bytes");
        try {
            return (List)SecurityConfig.getX509CertificateFactory().generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            String inputAsString = new String(bytes, StandardCharsets.UTF_8);
            throw InvalidArgumentException.fromMessage("Could not generate certificates from raw input: \"" + inputAsString + "\"", e);
        }
    }

    private static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CouchbaseException("Could not instantiate X.509 CertificateFactory", e);
        }
    }

    public static List<String> defaultCiphers(boolean nativeTlsEnabled) {
        return SslHandlerFactory.defaultCiphers(nativeTlsEnabled);
    }

    private String trustCertificatesToString() {
        if (CbCollections.isNullOrEmpty(this.trustCertificates)) {
            return null;
        }
        return this.trustCertificates.stream().map(it -> it.getSubjectDN() + " (valid from " + it.getNotBefore().toInstant() + " to " + it.getNotAfter().toInstant() + ")").collect(Collectors.toList()).toString();
    }

    @Stability.Volatile
    public static List<X509Certificate> defaultCaCertificates() {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        result.addAll(SecurityConfig.capellaCaCertificates());
        result.addAll(SecurityConfig.jvmCaCertificates());
        return result;
    }

    @Stability.Volatile
    public static List<X509Certificate> capellaCaCertificates() {
        return SecurityConfig.decodeCertificates(SecurityConfig.getResourceAsBytes("capella-ca.pem"));
    }

    @Stability.Volatile
    public static List<X509Certificate> jvmCaCertificates() {
        return Arrays.stream(SecurityConfig.getDefaultTrustManagerFactory().getTrustManagers()).filter(it -> it instanceof X509TrustManager).map(it -> (X509TrustManager)it).flatMap(it -> Arrays.stream(it.getAcceptedIssuers())).collect(Collectors.toList());
    }

    private static TrustManagerFactory getDefaultTrustManagerFactory() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            return tmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getResourceAsBytes(String resourceName) {
        byte[] byArray;
        block9: {
            InputStream is = SecurityConfig.class.getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new RuntimeException("Missing resource: " + resourceName);
                }
                byArray = Bytes.readAllBytes(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static class Builder {
        private boolean tlsEnabled = false;
        private boolean nativeTlsEnabled = true;
        private boolean hostnameVerificationEnabled = true;
        private boolean certificateVerificationEnabled = true;
        private List<X509Certificate> trustCertificates = null;
        private TrustManagerFactory trustManagerFactory = null;
        private List<String> ciphers = Collections.emptyList();

        public SecurityConfig build() {
            return new SecurityConfig(this);
        }

        public Builder enableTls(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public Builder enableHostnameVerification(boolean hostnameVerificationEnabled) {
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            return this;
        }

        @Stability.Volatile
        public Builder enableCertificateVerification(boolean certificateVerificationEnabled) {
            this.certificateVerificationEnabled = certificateVerificationEnabled;
            return this;
        }

        public Builder enableNativeTls(boolean nativeTlsEnabled) {
            this.nativeTlsEnabled = nativeTlsEnabled;
            return this;
        }

        public Builder trustCertificates(List<X509Certificate> certificates) {
            this.trustCertificates = Validators.notNullOrEmpty(certificates, "X509 Certificates");
            return this;
        }

        public Builder trustCertificate(Path certificatePath) {
            Builder builder;
            block8: {
                Validators.notNull(certificatePath, "CertificatePath");
                InputStream is = Files.newInputStream(certificatePath, new OpenOption[0]);
                try {
                    builder = this.trustCertificates(SecurityConfig.decodeCertificates(Bytes.readAllBytes(is)));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw InvalidArgumentException.fromMessage("Could not read trust certificates from file \"" + certificatePath + "\"", e);
                    }
                }
                is.close();
            }
            return builder;
        }

        public Builder trustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = Validators.notNull(trustManagerFactory, "TrustManagerFactory");
            return this;
        }

        public Builder trustStore(KeyStore trustStore) {
            Validators.notNull(trustStore, "TrustStore");
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                return this.trustManagerFactory(tmf);
            }
            catch (Exception ex) {
                throw InvalidArgumentException.fromMessage("Could not initialize TrustManagerFactory from TrustStore", ex);
            }
        }

        public Builder trustStore(Path trustStorePath, String trustStorePassword, Optional<String> trustStoreType) {
            Builder builder;
            block8: {
                Validators.notNull(trustStorePath, "TrustStorePath");
                Validators.notNull(trustStoreType, "TrustStoreType");
                InputStream trustStoreInputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
                try {
                    KeyStore store = KeyStore.getInstance(trustStoreType.orElse(KeyStore.getDefaultType()));
                    store.load(trustStoreInputStream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                    builder = this.trustStore(store);
                    if (trustStoreInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (trustStoreInputStream != null) {
                            try {
                                trustStoreInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw InvalidArgumentException.fromMessage("Could not initialize TrustStore", ex);
                    }
                }
                trustStoreInputStream.close();
            }
            return builder;
        }

        public Builder ciphers(List<String> ciphers) {
            this.ciphers = Validators.notNullOrEmpty(ciphers, "Ciphers");
            return this;
        }
    }

    @Stability.Internal
    public static class InternalMethods {
        public static boolean userSpecifiedTrustSource(SecurityConfig config) {
            return config.userSpecifiedTrustSource;
        }
    }

    @Stability.Internal
    public static class Defaults {
        public static final boolean DEFAULT_TLS_ENABLED = false;
        public static final boolean DEFAULT_NATIVE_TLS_ENABLED = true;
        public static final boolean DEFAULT_HOSTNAME_VERIFICATION_ENABLED = true;
        public static final boolean DEFAULT_CERTIFICATE_VERIFICATION_ENABLED = true;
    }
}

