/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class UserNotFoundException
extends CouchbaseException {
    private final String domain;
    private final String username;

    public UserNotFoundException(String domain, String username) {
        super("User [" + RedactableArgument.redactUser(username) + "] not found in " + domain + " domain.");
        this.domain = Objects.requireNonNull(domain);
        this.username = Objects.requireNonNull(username);
    }

    public static UserNotFoundException forUser(String domain, String username) {
        return new UserNotFoundException(domain, username);
    }

    public String domain() {
        return this.domain;
    }

    public String username() {
        return this.username;
    }
}

