/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueBaseResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Uncommitted
public class KeyValueErrorContext
extends ErrorContext {
    private final KeyValueRequest<?> request;
    @Nullable
    private final MemcacheProtocol.FlexibleExtras flexibleExtras;

    public KeyValueErrorContext(KeyValueRequest<?> request, ResponseStatus status, @Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        super(status);
        this.request = request;
        this.flexibleExtras = flexibleExtras;
    }

    public static KeyValueErrorContext completedRequest(KeyValueRequest<?> request, Response response) {
        MemcacheProtocol.FlexibleExtras flexibleExtras = null;
        if (response instanceof KeyValueBaseResponse) {
            flexibleExtras = ((KeyValueBaseResponse)response).flexibleExtras();
        }
        return new KeyValueErrorContext(request, response.status(), flexibleExtras);
    }

    public static KeyValueErrorContext completedRequest(KeyValueRequest<?> request, ResponseStatus status, @Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        return new KeyValueErrorContext(request, status, flexibleExtras);
    }

    public static KeyValueErrorContext incompleteRequest(KeyValueRequest<?> request) {
        return new KeyValueErrorContext(request, null, null);
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.request != null) {
            this.request.context().injectExportableParams(input);
        }
        if (this.flexibleExtras != null) {
            this.flexibleExtras.injectExportableParams(input);
        }
    }
}

