/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.channel.ChannelId;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.io.CollectionMap;
import com.couchbase.client.core.io.netty.kv.ServerFeature;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class KeyValueChannelContext {
    private final Optional<String> bucket;
    private final CompressionConfig compression;
    private final boolean collections;
    private final boolean mutationTokensEnabled;
    private final boolean syncReplication;
    private final boolean vattrEnabled;
    private final boolean altRequest;
    private final boolean createAsDeleted;
    private final boolean preserveTtl;
    private final CollectionMap collectionMap;
    private final ChannelId channelId;
    private final boolean getClusterConfigWithKnownVersion;

    @Stability.Internal
    public KeyValueChannelContext(@Nullable CompressionConfig compression, Optional<String> bucket, CollectionMap collectionMap, @Nullable ChannelId channelId, Set<ServerFeature> features) {
        this.compression = compression;
        this.bucket = Objects.requireNonNull(bucket);
        this.collectionMap = Objects.requireNonNull(collectionMap);
        this.channelId = channelId;
        this.collections = features.contains((Object)ServerFeature.COLLECTIONS);
        this.mutationTokensEnabled = features.contains((Object)ServerFeature.MUTATION_SEQNO);
        this.syncReplication = features.contains((Object)ServerFeature.SYNC_REPLICATION);
        this.altRequest = features.contains((Object)ServerFeature.ALT_REQUEST);
        this.vattrEnabled = features.contains((Object)ServerFeature.VATTR);
        this.createAsDeleted = features.contains((Object)ServerFeature.CREATE_AS_DELETED);
        this.preserveTtl = features.contains((Object)ServerFeature.PRESERVE_TTL);
        this.getClusterConfigWithKnownVersion = features.contains((Object)ServerFeature.GET_CLUSTER_CONFIG_WITH_KNOWN_VERSION);
        if (this.syncReplication && !this.altRequest) {
            throw new IllegalArgumentException("If Synchronous Replication is enabled, the server also must negotiate Alternate Requests. This is a bug! - please report.");
        }
    }

    public boolean collectionsEnabled() {
        return this.collections;
    }

    public boolean compressionEnabled() {
        return this.compression != null;
    }

    @Nullable
    public CompressionConfig compressionConfig() {
        return this.compression;
    }

    public boolean mutationTokensEnabled() {
        return this.mutationTokensEnabled;
    }

    public boolean syncReplicationEnabled() {
        return this.syncReplication;
    }

    public boolean vattrEnabled() {
        return this.vattrEnabled;
    }

    public boolean alternateRequestEnabled() {
        return this.altRequest;
    }

    public CollectionMap collectionMap() {
        return this.collectionMap;
    }

    @Nullable
    public ChannelId channelId() {
        return this.channelId;
    }

    public boolean createAsDeleted() {
        return this.createAsDeleted;
    }

    public boolean preserveTtl() {
        return this.preserveTtl;
    }

    public boolean getClusterConfigWithKnownVersion() {
        return this.getClusterConfigWithKnownVersion;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }
}

