/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.deps.io.grpc.stub.StreamObserver;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class CoreProtostellarAccessorsStreaming {
    private CoreProtostellarAccessorsStreaming() {
    }

    public static <TGrpcRequest, TGrpcResponse> List<TGrpcResponse> blocking(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, BiConsumer<ProtostellarEndpoint, StreamObserver<TGrpcResponse>> executeFutureGrpcCall, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        return CoreProtostellarAccessorsStreaming.async(core, request, executeFutureGrpcCall, convertException).toBlocking();
    }

    public static <TGrpcRequest, TGrpcResponse> CoreAsyncResponse<List<TGrpcResponse>> async(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, BiConsumer<ProtostellarEndpoint, StreamObserver<TGrpcResponse>> executeFutureGrpcCall, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        CompletableFuture<List<TGrpcResponse>> ret = new CompletableFuture<List<TGrpcResponse>>();
        CoreAsyncResponse<List<TGrpcResponse>> response = new CoreAsyncResponse<List<TGrpcResponse>>(ret, () -> {});
        CoreProtostellarAccessorsStreaming.asyncInternal(ret, core, request, executeFutureGrpcCall, convertException);
        return response;
    }

    private static <TGrpcRequest, TGrpcResponse> void asyncInternal(final CompletableFuture<List<TGrpcResponse>> ret, final CoreProtostellar core, final ProtostellarRequest<TGrpcRequest> request, final BiConsumer<ProtostellarEndpoint, StreamObserver<TGrpcResponse>> executeFutureGrpcCall, final Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        if (CoreProtostellarUtil.handleShutdownAsync(core, ret, request)) {
            return;
        }
        ProtostellarEndpoint endpoint = core.endpoint();
        final ArrayList responses = new ArrayList();
        StreamObserver response = new StreamObserver<TGrpcResponse>(){

            @Override
            public void onNext(TGrpcResponse response) {
                responses.add(response);
            }

            @Override
            public void onError(Throwable throwable) {
                ProtostellarRequestBehaviour behaviour = (ProtostellarRequestBehaviour)convertException.apply(throwable);
                if (behaviour.retryDuration() != null) {
                    boolean unableToSchedule;
                    boolean bl = unableToSchedule = core.context().environment().timer().schedule(() -> CoreProtostellarAccessorsStreaming.asyncInternal(ret, core, request, executeFutureGrpcCall, convertException), behaviour.retryDuration(), true) == null;
                    if (unableToSchedule) {
                        RuntimeException err = request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY).exception();
                        if (!request.completed()) {
                            request.raisedResponseToUser(err);
                            ret.completeExceptionally(err);
                        }
                    }
                } else if (!request.completed()) {
                    request.raisedResponseToUser(behaviour.exception());
                    ret.completeExceptionally(behaviour.exception());
                }
            }

            @Override
            public void onCompleted() {
                ret.complete(responses);
            }
        };
        executeFutureGrpcCall.accept(endpoint, response);
    }

    public static <TGrpcRequest, TGrpcResponse> Flux<TGrpcResponse> reactive(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, BiConsumer<ProtostellarEndpoint, StreamObserver<TGrpcResponse>> executeFutureGrpcCall, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        return Flux.defer(() -> {
            Sinks.Many ret = Sinks.many().unicast().onBackpressureBuffer();
            CoreProtostellarAccessorsStreaming.reactiveInternal(ret, core, request, executeFutureGrpcCall, convertException);
            return ret.asFlux();
        });
    }

    private static <TGrpcRequest, TGrpcResponse> void reactiveInternal(final Sinks.Many<TGrpcResponse> ret, final CoreProtostellar core, final ProtostellarRequest<TGrpcRequest> request, final BiConsumer<ProtostellarEndpoint, StreamObserver<TGrpcResponse>> executeFutureGrpcCall, final Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        if (CoreProtostellarUtil.handleShutdownReactive(ret, core, request)) {
            return;
        }
        ProtostellarEndpoint endpoint = core.endpoint();
        StreamObserver response = new StreamObserver<TGrpcResponse>(){

            @Override
            public void onNext(TGrpcResponse response) {
                ret.tryEmitNext(response).orThrow();
            }

            @Override
            public void onError(Throwable throwable) {
                ProtostellarRequestBehaviour behaviour = (ProtostellarRequestBehaviour)convertException.apply(throwable);
                if (behaviour.retryDuration() != null) {
                    boolean unableToSchedule;
                    boolean bl = unableToSchedule = core.context().environment().timer().schedule(() -> CoreProtostellarAccessorsStreaming.reactiveInternal(ret, core, request, executeFutureGrpcCall, convertException), behaviour.retryDuration(), true) == null;
                    if (unableToSchedule) {
                        RuntimeException err = request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY).exception();
                        if (!request.completed()) {
                            request.raisedResponseToUser(err);
                            ret.tryEmitError((Throwable)err).orThrow();
                        }
                    }
                } else if (!request.completed()) {
                    request.raisedResponseToUser(behaviour.exception());
                    ret.tryEmitError((Throwable)behaviour.exception()).orThrow();
                }
            }

            @Override
            public void onCompleted() {
                ret.tryEmitComplete();
            }
        };
        executeFutureGrpcCall.accept(endpoint, response);
    }
}

