/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.java.http.NameValuePair;
import com.couchbase.client.java.http.NameValuePairs;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpBody {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    final String contentType;
    final byte[] content;

    private HttpBody(String contentType, byte[] content) {
        this.contentType = Objects.requireNonNull(contentType);
        this.content = Objects.requireNonNull(content);
    }

    public static HttpBody json(byte[] json) {
        return new HttpBody(JSON_CONTENT_TYPE, json);
    }

    public static HttpBody json(String json) {
        return HttpBody.json(json.getBytes(StandardCharsets.UTF_8));
    }

    public static HttpBody form(Map<String, ?> data) {
        return HttpBody.form(NameValuePairs.of(data));
    }

    public static HttpBody form(List<NameValuePair> data) {
        return HttpBody.form(NameValuePairs.of(data));
    }

    public static HttpBody form(NameValuePair ... data) {
        return HttpBody.form(NameValuePairs.of(data));
    }

    public static HttpBody form(NameValuePairs data) {
        return new HttpBody(FORM_CONTENT_TYPE, data.urlEncoded.getBytes(StandardCharsets.UTF_8));
    }
}

