/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.eventing.EventingFunctionBucketAccess;
import com.couchbase.client.java.manager.eventing.EventingFunctionKeyspace;

public class EventingFunctionBucketBinding {
    private final String alias;
    private final EventingFunctionKeyspace keyspace;
    private final EventingFunctionBucketAccess access;

    public static EventingFunctionBucketBinding createReadOnly(String alias, EventingFunctionKeyspace keyspace) {
        return new EventingFunctionBucketBinding(alias, keyspace, EventingFunctionBucketAccess.READ_ONLY);
    }

    public static EventingFunctionBucketBinding createReadWrite(String alias, EventingFunctionKeyspace keyspace) {
        return new EventingFunctionBucketBinding(alias, keyspace, EventingFunctionBucketAccess.READ_WRITE);
    }

    private EventingFunctionBucketBinding(String alias, EventingFunctionKeyspace keyspace, EventingFunctionBucketAccess access) {
        this.alias = Validators.notNullOrEmpty((String)alias, (String)"Alias");
        this.keyspace = (EventingFunctionKeyspace)Validators.notNull((Object)keyspace, (String)"Keyspace");
        this.access = (EventingFunctionBucketAccess)((Object)Validators.notNull((Object)((Object)access), (String)"Access"));
    }

    public String alias() {
        return this.alias;
    }

    public EventingFunctionKeyspace keyspace() {
        return this.keyspace;
    }

    public EventingFunctionBucketAccess access() {
        return this.access;
    }

    public String toString() {
        return "EventingFunctionBucketBinding{alias='" + RedactableArgument.redactMeta((Object)this.alias) + '\'' + ", keyspace=" + RedactableArgument.redactUser((Object)this.keyspace) + ", access=" + (Object)((Object)this.access) + '}';
    }
}

