/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public final class CoreKeyspace
implements Serializable {
    private final String bucket;
    private final String scope;
    private final String collection;
    private final boolean isDefaultCollection;
    private final CollectionIdentifier collectionIdentifier;

    public CoreKeyspace(String bucket, String scope, String collection) {
        this.bucket = Objects.requireNonNull(bucket);
        this.scope = Objects.requireNonNull(scope);
        this.collection = Objects.requireNonNull(collection);
        this.isDefaultCollection = scope.equals("_default") && collection.equals("_default");
        this.collectionIdentifier = new CollectionIdentifier(bucket, Optional.of(scope), Optional.of(collection));
    }

    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    public String collection() {
        return this.collection;
    }

    public boolean isDefaultCollection() {
        return this.isDefaultCollection;
    }

    public static CoreKeyspace from(CollectionIdentifier id) {
        return new CoreKeyspace(id.bucket(), id.scope().orElse("_default"), id.collection().orElse("_default"));
    }

    public CollectionIdentifier toCollectionIdentifier() {
        return this.collectionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreKeyspace keyspace = (CoreKeyspace)o;
        return this.bucket.equals(keyspace.bucket) && this.scope.equals(keyspace.scope) && this.collection.equals(keyspace.collection);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.scope, this.collection);
    }

    public String toString() {
        return this.bucket + ":" + this.scope + "." + this.collection;
    }
}

