/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.ClusterCapabilitiesUtil;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class SearchCapabilityCheck {
    private SearchCapabilityCheck() {
    }

    public static CompletableFuture<Void> scopedSearchIndexCapabilityCheck(Core core, Duration timeout) {
        return ClusterCapabilitiesUtil.waitForClusterCapabilities(core, timeout).doOnNext(clusterCapabilities -> {
            if (!((Set)clusterCapabilities.get((Object)ServiceType.SEARCH)).contains((Object)ClusterCapabilities.SCOPED_SEARCH_INDEX)) {
                throw new FeatureNotAvailableException("This method cannot be used with this cluster, as it does not support scoped search indexes.  Please use a cluster fully upgraded to Couchbase Server 7.6 or above.");
            }
        }).then().toFuture();
    }

    public static CompletableFuture<Void> vectorSearchCapabilityCheck(Core core, Duration timeout) {
        return ClusterCapabilitiesUtil.waitForClusterCapabilities(core, timeout).doOnNext(clusterCapabilities -> {
            if (!((Set)clusterCapabilities.get((Object)ServiceType.SEARCH)).contains((Object)ClusterCapabilities.VECTOR_SEARCH)) {
                throw new FeatureNotAvailableException("This method cannot be used with this cluster, as it does not support vector search.  Please use a cluster fully upgraded to Couchbase Server 7.6 or above.");
            }
        }).then().toFuture();
    }
}

