/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryOptionsTransactions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.classic.query.ClassicCoreQueryResult;
import com.couchbase.client.core.classic.query.ClassicCoreReactiveQueryResult;
import com.couchbase.client.core.classic.query.EnhancedPreparedStatementStrategy;
import com.couchbase.client.core.classic.query.LegacyPreparedStatementStrategy;
import com.couchbase.client.core.classic.query.PreparedStatementStrategy;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.events.request.PreparedStatementRetriedEvent;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionExpiredException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClassicCoreQueryOps
implements CoreQueryOps {
    private final Core core;
    private static final int PREPARED_STATEMENT_CACHE_SIZE = 5000;
    private volatile PreparedStatementStrategy strategy;

    public ClassicCoreQueryOps(Core core) {
        this.core = core;
        this.strategy = new LegacyPreparedStatementStrategy(core, 5000);
        core.configurationProvider().configs().filter(config -> {
            Set<ClusterCapabilities> caps = config.clusterCapabilities().get((Object)ServiceType.QUERY);
            return caps != null && caps.contains((Object)ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS);
        }).next().subscribe(config -> {
            this.strategy = new EnhancedPreparedStatementStrategy(core, 5000);
        });
    }

    private Mono<QueryResponse> query(QueryRequest request, boolean adhoc) {
        if (adhoc) {
            return this.strategy.executeAdhoc(request);
        }
        return this.strategy.execute(request).onErrorResume(PreparedStatementFailureException.class, (Function)new PreparedRetryFunction(request));
    }

    @Override
    public CoreAsyncResponse<CoreQueryResult> queryAsync(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        if (options.asTransaction()) {
            CompletableFuture out = ClassicCoreQueryOps.singleQueryTransactionBuffered(this.core, statement, options, queryContext, errorConverter).toFuture();
            return new CoreAsyncResponse<CoreQueryResult>(out, () -> {});
        }
        QueryRequest request = this.queryRequest(statement, options, queryContext, target);
        Mono<QueryResponse> result = this.query(request, options.adhoc());
        CompletableFuture out = result.onErrorMap(err -> {
            if (errorConverter != null) {
                return (Throwable)errorConverter.apply((Throwable)err);
            }
            return err;
        }).flatMap(response -> response.rows().collectList().onErrorMap(err -> {
            if (errorConverter != null) {
                return (Throwable)errorConverter.apply((Throwable)err);
            }
            return err;
        }).flatMap(rows -> response.trailer().map(trailer -> new ClassicCoreQueryResult(response.header(), (List<QueryChunkRow>)rows, (QueryChunkTrailer)trailer, request.context().lastDispatchedToNode())))).toFuture();
        return new CoreAsyncResponse<CoreQueryResult>(out, () -> {});
    }

    @Override
    public Mono<CoreReactiveQueryResult> queryReactive(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        if (options.asTransaction()) {
            return this.singleQueryTransactionReactive(statement, options, queryContext, errorConverter);
        }
        QueryRequest request = this.queryRequest(statement, options, queryContext, target);
        return this.query(request, options.adhoc()).map(v -> new ClassicCoreReactiveQueryResult((QueryResponse)v, request.context().lastDispatchedToNode())).onErrorMap(err -> {
            if (errorConverter != null) {
                return (Throwable)errorConverter.apply((Throwable)err);
            }
            return err;
        });
    }

    private QueryRequest queryRequest(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target) {
        Validators.notNullOrEmpty(statement, "Statement", () -> new ReducedQueryErrorContext(statement));
        Validators.notNull(options, "options");
        Duration timeout = options.commonOptions().timeout().orElse(this.core.context().environment().timeoutConfig().queryTimeout());
        RetryStrategy retryStrategy = options.commonOptions().retryStrategy().orElse(this.core.context().environment().retryStrategy());
        ObjectNode query = ClassicCoreQueryOps.convertOptions(options);
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs(timeout));
        if (queryContext != null) {
            query.put("query_context", queryContext.format());
        }
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        RequestSpan span = this.core.context().environment().requestTracer().requestSpan("query", options.commonOptions().parentSpan().orElse(null));
        QueryRequest request = new QueryRequest(timeout, this.core.context(), retryStrategy, this.core.context().authenticator(), statement, queryBytes, options.readonly(), options.clientContextId(), span, queryContext == null ? null : queryContext.bucket(), queryContext == null ? null : queryContext.scope(), target);
        request.context().clientContext(options.commonOptions().clientContext());
        return request;
    }

    private static Mono<CoreQueryResult> singleQueryTransactionBuffered(Core core, String statement, CoreQueryOptions opts, @Nullable CoreQueryContext queryContext, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        if (opts.commonOptions().retryStrategy().isPresent()) {
            throw new IllegalArgumentException("Cannot specify retryStrategy() if using asTransaction() on QueryOptions");
        }
        CoreTransactionsReactive tri = ClassicCoreQueryOps.configureTransactions(core, opts);
        SpanWrapper span = SpanWrapperUtil.createOp(null, core.context().environment().requestTracer(), null, null, "query", opts.commonOptions().parentSpan().map(SpanWrapper::new).orElse(null)).attribute("db.statement", statement).attribute("db.couchbase.transaction.single_query", true);
        CoreQueryOptionsTransactions shadowed = new CoreQueryOptionsTransactions(opts);
        shadowed.set(CoreQueryOptionsTransactions.QueryOptionsParameter.AS_TRANSACTION_OPTIONS, CoreQueryOptionsTransactions.ParameterPassthrough.ALWAYS_SHADOWED);
        return tri.queryBlocking(statement, queryContext, shadowed, Optional.of(span.span())).onErrorResume(ex -> {
            if (ex instanceof CoreTransactionExpiredException) {
                return Mono.error((Throwable)new UnambiguousTimeoutException(ex.getMessage(), null));
            }
            if (errorConverter != null) {
                ex = (Throwable)errorConverter.apply((Throwable)ex);
            }
            return Mono.error((Throwable)ex);
        }).doOnError(err -> span.finish((Throwable)err)).doOnTerminate(() -> span.finish());
    }

    private Mono<CoreReactiveQueryResult> singleQueryTransactionReactive(String statement, CoreQueryOptions opts, @Nullable CoreQueryContext queryContext, Function<Throwable, RuntimeException> errorConverter) {
        if (opts.commonOptions().retryStrategy().isPresent()) {
            throw new IllegalArgumentException("Cannot specify retryStrategy() if using asTransaction() on QueryOptions");
        }
        CoreTransactionsReactive tri = ClassicCoreQueryOps.configureTransactions(this.core, opts);
        SpanWrapper span = SpanWrapperUtil.createOp(null, this.core.context().environment().requestTracer(), null, null, "query", opts.commonOptions().parentSpan().map(SpanWrapper::new).orElse(null)).attribute("db.statement", statement).attribute("db.couchbase.transaction.single_query", true);
        CoreQueryOptionsTransactions shadowed = new CoreQueryOptionsTransactions(opts);
        shadowed.set(CoreQueryOptionsTransactions.QueryOptionsParameter.AS_TRANSACTION_OPTIONS, CoreQueryOptionsTransactions.ParameterPassthrough.ALWAYS_SHADOWED);
        return tri.query(statement, queryContext, shadowed, Optional.of(span.span()), errorConverter).doOnError(err -> span.finish((Throwable)err)).doOnTerminate(() -> span.finish());
    }

    private static CoreTransactionsReactive configureTransactions(Core core, CoreQueryOptions opts) {
        CoreSingleQueryTransactionOptions queryOpts = opts.asTransactionOptions();
        CoreTransactionsConfig transactionsConfig = core.context().environment().transactionsConfig();
        return new CoreTransactionsReactive(core, CoreTransactionsConfig.createForSingleQueryTransactions(queryOpts == null ? transactionsConfig.durabilityLevel() : queryOpts.durabilityLevel().orElse(transactionsConfig.durabilityLevel()), opts.commonOptions().timeout().orElse(transactionsConfig.transactionExpirationTime()), queryOpts == null ? null : queryOpts.attemptContextFactory().orElse(transactionsConfig.attemptContextFactory()), queryOpts == null ? transactionsConfig.metadataCollection() : queryOpts.metadataCollection()));
    }

    @Stability.Internal
    public static ObjectNode convertOptions(CoreQueryOptions opts) {
        JsonNode raw;
        boolean positionalPresent;
        ObjectNode json = Mapper.createObjectNode();
        json.put("client_context_id", opts.clientContextId() == null ? UUID.randomUUID().toString() : opts.clientContextId());
        boolean bl = positionalPresent = opts.positionalParameters() != null && !opts.positionalParameters().isEmpty();
        if (opts.namedParameters() != null && !opts.namedParameters().isEmpty()) {
            if (positionalPresent) {
                throw InvalidArgumentException.fromMessage("Both positional and named parameters cannot be present at the same time!");
            }
            opts.namedParameters().fields().forEachRemaining(param -> {
                String key = (String)param.getKey();
                json.set(key.charAt(0) == '$' ? key : '$' + key, (JsonNode)param.getValue());
            });
        }
        if (positionalPresent) {
            json.put("args", opts.positionalParameters());
        }
        if (opts.scanConsistency() != null) {
            json.put("scan_consistency", opts.scanConsistency().toString());
        }
        if (opts.consistentWith() != null) {
            ObjectNode mutationState = Mapper.createObjectNode();
            for (MutationToken token : opts.consistentWith().tokens()) {
                ObjectNode bucket = (ObjectNode)mutationState.get(token.bucketName());
                if (bucket == null) {
                    bucket = Mapper.createObjectNode();
                    mutationState.put(token.bucketName(), bucket);
                }
                ArrayNode v = Mapper.createArrayNode();
                v.add(token.sequenceNumber());
                v.add(String.valueOf(token.partitionUUID()));
                bucket.put(String.valueOf(token.partitionID()), v);
            }
            json.put("scan_vectors", mutationState);
            json.put("scan_consistency", "at_plus");
        }
        if (opts.profile() != null) {
            json.put("profile", opts.profile().toString());
        }
        if (opts.scanWait() != null && (opts.scanConsistency() == null || CoreQueryScanConsistency.NOT_BOUNDED != opts.scanConsistency())) {
            json.put("scan_wait", Golang.encodeDurationToMs(opts.scanWait()));
        }
        if (opts.maxParallelism() != null) {
            json.put("max_parallelism", opts.maxParallelism().toString());
        }
        if (opts.pipelineCap() != null) {
            json.put("pipeline_cap", opts.pipelineCap().toString());
        }
        if (opts.pipelineBatch() != null) {
            json.put("pipeline_batch", opts.pipelineBatch().toString());
        }
        if (opts.scanCap() != null) {
            json.put("scan_cap", opts.scanCap().toString());
        }
        if (!opts.metrics()) {
            json.put("metrics", false);
        }
        if (opts.readonly()) {
            json.put("readonly", true);
        }
        if (opts.flexIndex()) {
            json.put("use_fts", true);
        }
        if (opts.preserveExpiry() != null) {
            json.put("preserve_expiry", opts.preserveExpiry());
        }
        if (opts.useReplica() != null) {
            json.put("use_replica", opts.useReplica() != false ? "on" : "off");
        }
        if ((raw = opts.raw()) != null) {
            Iterator<String> it = raw.fieldNames();
            while (it.hasNext()) {
                String fieldName = it.next();
                json.set(fieldName, raw.get(fieldName));
            }
        }
        return json;
    }

    private class PreparedRetryFunction
    implements Function<PreparedStatementFailureException, Mono<? extends QueryResponse>> {
        private final QueryRequest request;

        public PreparedRetryFunction(QueryRequest request) {
            this.request = Objects.requireNonNull(request);
        }

        @Override
        public Mono<? extends QueryResponse> apply(PreparedStatementFailureException t) {
            if (!t.retryable()) {
                return Mono.error((Throwable)t);
            }
            ClassicCoreQueryOps.this.strategy.evict(this.request);
            RetryReason retryReason = RetryReason.QUERY_PREPARED_STATEMENT_FAILURE;
            CoreEnvironment env = this.request.context().environment();
            return Mono.fromFuture(this.request.retryStrategy().shouldRetry(this.request, retryReason)).flatMap(retryAction -> {
                Optional<Duration> duration = retryAction.duration();
                if (!duration.isPresent()) {
                    return Mono.error((Throwable)retryAction.exceptionTranslator().apply(t));
                }
                Duration cappedDuration = RetryOrchestrator.capDuration(duration.get(), this.request);
                this.request.context().incrementRetryAttempts(cappedDuration, retryReason);
                env.eventBus().publish(new PreparedStatementRetriedEvent(cappedDuration, this.request.context(), retryReason, t));
                return Mono.delay((Duration)cappedDuration, (Scheduler)env.scheduler()).flatMap(l -> ClassicCoreQueryOps.this.query(this.request, false));
            });
        }
    }
}

