/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.msg.RequestTarget;
import java.util.Objects;

@Stability.Internal
public class CoreHttpClient {
    private final Core core;
    private final RequestTarget target;

    public CoreHttpClient(Core core, RequestTarget target) {
        this.core = Objects.requireNonNull(core);
        this.target = Objects.requireNonNull(target);
    }

    public CoreHttpRequest.Builder get(CoreHttpPath path, CoreCommonOptions options) {
        return this.newRequest(HttpMethod.GET, path, options);
    }

    public CoreHttpRequest.Builder put(CoreHttpPath path, CoreCommonOptions options) {
        return this.newRequest(HttpMethod.PUT, path, options);
    }

    public CoreHttpRequest.Builder patch(CoreHttpPath path, CoreCommonOptions options) {
        return this.newRequest(HttpMethod.PATCH, path, options);
    }

    public CoreHttpRequest.Builder post(CoreHttpPath path, CoreCommonOptions options) {
        return this.newRequest(HttpMethod.POST, path, options);
    }

    public CoreHttpRequest.Builder delete(CoreHttpPath path, CoreCommonOptions options) {
        return this.newRequest(HttpMethod.DELETE, path, options);
    }

    public CoreHttpRequest.Builder newRequest(HttpMethod method, CoreHttpPath path, CoreCommonOptions options) {
        return new CoreHttpRequest.Builder(options, this.core.context(), this.target, method, path);
    }
}

