/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.DefaultLoggerFormatter;
import com.couchbase.client.core.cnc.LoggerFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.LoggerFactory;

public class LoggerConfig {
    private final boolean diagnosticContextEnabled;

    private LoggerConfig(Builder builder) {
        this.diagnosticContextEnabled = builder.diagnosticContextEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LoggerConfig create() {
        return LoggerConfig.builder().build();
    }

    @Deprecated
    public static Builder fallbackToConsole(boolean fallbackToConsole) {
        return LoggerConfig.builder().fallbackToConsole(fallbackToConsole);
    }

    @Deprecated
    public static Builder disableSlf4J(boolean disableSlf4J) {
        return LoggerConfig.builder().disableSlf4J(disableSlf4J);
    }

    @Deprecated
    public static Builder loggerName(String loggerName) {
        return LoggerConfig.builder().loggerName(loggerName);
    }

    @Deprecated
    public static Builder enableDiagnosticContext(boolean diagnosticContextEnabled) {
        return LoggerConfig.builder().enableDiagnosticContext(diagnosticContextEnabled);
    }

    @Deprecated
    public static Builder consoleLogLevel(Level consoleLogLevel) {
        return LoggerConfig.builder().consoleLogLevel(consoleLogLevel);
    }

    @Deprecated
    public Builder consoleLoggerFormatter(LoggerFormatter loggerFormatter) {
        return LoggerConfig.builder().consoleLoggerFormatter(loggerFormatter);
    }

    @Deprecated
    public boolean fallbackToConsole() {
        return false;
    }

    @Deprecated
    public boolean disableSlf4J() {
        return false;
    }

    @Deprecated
    public String loggerName() {
        return "";
    }

    public boolean diagnosticContextEnabled() {
        return this.diagnosticContextEnabled;
    }

    @Deprecated
    public Level consoleLogLevel() {
        return Level.INFO;
    }

    @Deprecated
    public LoggerFormatter consoleLoggerFormatter() {
        return DefaultLoggerFormatter.INSTANCE;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("diagnosticContextEnabled", this.diagnosticContextEnabled);
        return export;
    }

    static {
        String loggerFactoryClassName = LoggerFactory.getILoggerFactory().getClass().getName();
        boolean missingSlf4jBinding = loggerFactoryClassName.equals("org.slf4j.helpers.NOPLoggerFactory");
        if (missingSlf4jBinding) {
            String slf4jVersion = "2.0.9";
            System.err.printf("WARN: The Couchbase SDK uses SLF4J for logging, but there does not appear to be an SLF4J binding on the class path.%nTo see log messages from the Couchbase SDK, please add an SLF4J binding as a dependency of your project.%nIf you're using Maven, a simple way to enable basic logging is to add these dependencies to your POM:%n    <dependency>%n        <groupId>org.slf4j</groupId>%n        <artifactId>slf4j-api</artifactId>%n        <version>" + slf4jVersion + "</version>%n    </dependency>%n    <dependency>%n        <groupId>org.slf4j</groupId>%n        <artifactId>slf4j-simple</artifactId>%n        <version>" + slf4jVersion + "</version>%n    </dependency>%nOr if you're using Gradle, add these to your dependencies section:%n    implementation(\"org.slf4j:slf4j-api:" + slf4jVersion + "\")%n    implementation(\"org.slf4j:slf4j-simple:" + slf4jVersion + "\")%nIf you see this warning even though there's an SLF4J binding on the class path,%nit may be due to an `slf4j-api` version mismatch; try adding an explicit dependency%non the version of `slf4j-api` required by your selected binding.%nTo learn more about SLF4J bindings, see https://www.slf4j.org/manual.html#swapping%n%n", new Object[0]);
        }
    }

    public static class Builder {
        private boolean diagnosticContextEnabled = false;

        private Builder deprecatedInFavorOfSlf4J(String clientSettingName) {
            System.err.println("WARN: The Couchbase SDK `" + clientSettingName + "` client setting is deprecated, and has no effect. The Couchbase SDK now uses SLF4J for all logging. Instead of customizing log output via SDK client settings, please include an appropriate SLF4J binding as a dependency of your project, and configure your chosen logging framework to generate log messages in the desired format. To learn more about SLF4J bindings, see https://www.slf4j.org/manual.html#swapping");
            return this;
        }

        @Deprecated
        public Builder fallbackToConsole(boolean fallbackToConsole) {
            return this.deprecatedInFavorOfSlf4J("logger.fallbackToConsole");
        }

        @Deprecated
        public Builder disableSlf4J(boolean disableSlf4J) {
            return this.deprecatedInFavorOfSlf4J("logger.disableSlf4J");
        }

        @Deprecated
        public Builder loggerName(String loggerName) {
            return this.deprecatedInFavorOfSlf4J("logger.loggerName");
        }

        public Builder enableDiagnosticContext(boolean diagnosticContextEnabled) {
            this.diagnosticContextEnabled = diagnosticContextEnabled;
            return this;
        }

        @Deprecated
        public Builder consoleLogLevel(Level consoleLogLevel) {
            return this.deprecatedInFavorOfSlf4J("logger.consoleLogLevel");
        }

        @Deprecated
        public Builder consoleLoggerFormatter(LoggerFormatter loggerFormatter) {
            return this.deprecatedInFavorOfSlf4J("logger.consoleLoggerFormatter");
        }

        public LoggerConfig build() {
            return new LoggerConfig(this);
        }
    }

    @Stability.Internal
    public static class Defaults {
        public static final boolean DEFAULT_DIAGNOSTIC_CONTEXT_ENABLED = false;
    }
}

