/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.MultiObserveViaCasResponse;
import com.couchbase.client.core.msg.kv.ObserveViaCasResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class MultiObserveViaCasRequest
extends BaseKeyValueRequest<MultiObserveViaCasResponse>
implements TargetedRequest {
    private final NodeIdentifier target;
    private final Map<byte[], Short> keys;
    private final Predicate<ObserveViaCasResponse.ObserveStatus> responsePredicate;

    public MultiObserveViaCasRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, CollectionIdentifier collectionIdentifier, NodeIdentifier target, Map<byte[], Short> keys, Predicate<ObserveViaCasResponse.ObserveStatus> responsePredicate) {
        super(timeout, ctx, retryStrategy, null, collectionIdentifier);
        this.target = target;
        this.keys = keys;
        this.responsePredicate = responsePredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf content = null;
        try {
            content = alloc.buffer(this.keys.size() * 4);
            for (Map.Entry<byte[], Short> key : this.keys.entrySet()) {
                ByteBuf keyWithCollection = this.encodedExternalKeyWithCollection(alloc, ctx, key.getKey());
                try {
                    content.writeShort(key.getValue().shortValue());
                    content.writeShort(keyWithCollection.readableBytes());
                    content.writeBytes(keyWithCollection);
                }
                finally {
                    ReferenceCountUtil.release(keyWithCollection);
                }
            }
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.OBSERVE_CAS, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), content);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public MultiObserveViaCasResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        Optional<ByteBuf> maybeContent;
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        HashMap<byte[], ObserveViaCasResponse.ObserveStatus> observed = new HashMap<byte[], ObserveViaCasResponse.ObserveStatus>();
        if (status.success() && (maybeContent = MemcacheProtocol.body(response)).isPresent()) {
            ByteBuf content = maybeContent.get();
            while (content.isReadable()) {
                content.skipBytes(2);
                short keyLength = content.readShort();
                if (ctx.collectionsEnabled()) {
                    int skipped = UnsignedLEB128.skip(content);
                    keyLength = (short)(keyLength - skipped);
                }
                byte[] keyEncoded = new byte[keyLength];
                content.readBytes(keyEncoded, 0, (int)keyLength);
                byte obs = content.readByte();
                content.skipBytes(8);
                ObserveViaCasResponse.ObserveStatus decoded = ObserveViaCasResponse.ObserveStatus.valueOf(obs);
                if (!this.responsePredicate.test(decoded)) continue;
                observed.put(keyEncoded, decoded);
            }
        }
        return new MultiObserveViaCasResponse(this, status, observed);
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "multi_observe_via_cas";
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> parentCtx = super.serviceContext();
        parentCtx.put("target", this.target.address());
        parentCtx.put("numKeys", this.keys.size());
        return parentCtx;
    }
}

