/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.search.CoreHighlightStyle;
import com.couchbase.client.core.api.search.CoreSearchKeyset;
import com.couchbase.client.core.api.search.CoreSearchMetaData;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.CoreSearchOptions;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.CoreSearchScanConsistency;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreDateRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreNumericRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreReactiveSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchMetrics;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.core.api.search.result.CoreSearchStatus;
import com.couchbase.client.core.api.search.result.CoreTermSearchFacetResult;
import com.couchbase.client.core.api.search.util.SearchCapabilityCheck;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.TextNode;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.context.ReducedSearchErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.core.msg.search.ServerSearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClassicCoreSearchOps
implements CoreSearchOps {
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private final Core core;
    @Nullable
    private final CoreBucketAndScope scope;

    public ClassicCoreSearchOps(Core core, @Nullable CoreBucketAndScope scope) {
        this.core = core;
        this.scope = scope;
    }

    CoreAsyncResponse<Void> preflightCheckScopedIndexes(Duration timeout) {
        if (this.scope != null) {
            return new CoreAsyncResponse<Void>(SearchCapabilityCheck.scopedSearchIndexCapabilityCheck(this.core, timeout), () -> {});
        }
        return new CoreAsyncResponse<Object>(CompletableFuture.completedFuture(null), () -> {});
    }

    CoreAsyncResponse<Void> preflightCheckVectorIndexes(boolean requiresVectorIndexSupport, Duration timeout) {
        if (requiresVectorIndexSupport) {
            return new CoreAsyncResponse<Void>(SearchCapabilityCheck.vectorSearchCapabilityCheck(this.core, timeout), () -> {});
        }
        return new CoreAsyncResponse<Object>(CompletableFuture.completedFuture(null), () -> {});
    }

    @Override
    public CoreAsyncResponse<CoreSearchResult> searchQueryAsync(String indexName, CoreSearchQuery query, CoreSearchOptions options) {
        options.validate();
        Duration timeout = options.commonOptions().timeout().orElse(this.core.environment().timeoutConfig().searchTimeout());
        return this.searchAsyncShared(this.searchRequest(indexName, query, options), false, timeout);
    }

    @Override
    public Mono<CoreReactiveSearchResult> searchQueryReactive(String indexName, CoreSearchQuery query, CoreSearchOptions options) {
        options.validate();
        Duration timeout = options.commonOptions().timeout().orElse(this.core.environment().timeoutConfig().searchTimeout());
        return this.searchReactiveShared(this.searchRequest(indexName, query, options), false, timeout);
    }

    private static Map<String, CoreSearchFacetResult> parseFacets(SearchChunkTrailer trailer) {
        byte[] rawFacets = trailer.facets();
        if (rawFacets == null || rawFacets.length == 0 || Arrays.equals(rawFacets, NULL)) {
            return Collections.emptyMap();
        }
        ObjectNode objectNode = (ObjectNode)Mapper.decodeIntoTree(rawFacets);
        HashMap<String, CoreSearchFacetResult> facets = new HashMap<String, CoreSearchFacetResult>();
        ClassicCoreSearchOps.forEachField(objectNode, (facetName, facetEntry) -> {
            ((ObjectNode)facetEntry).set("$name", new TextNode((String)facetName));
            if (facetEntry.has("numeric_ranges")) {
                facets.put((String)facetName, Mapper.convertValue(facetEntry, CoreNumericRangeSearchFacetResult.class));
            } else if (facetEntry.has("date_ranges")) {
                facets.put((String)facetName, Mapper.convertValue(facetEntry, CoreDateRangeSearchFacetResult.class));
            } else {
                facets.put((String)facetName, Mapper.convertValue(facetEntry, CoreTermSearchFacetResult.class));
            }
        });
        return facets;
    }

    private static void forEachField(ObjectNode node, BiConsumer<String, JsonNode> consumer) {
        Objects.requireNonNull(consumer);
        node.fields().forEachRemaining(entry -> consumer.accept((String)entry.getKey(), (JsonNode)entry.getValue()));
    }

    private static CoreSearchMetaData parseMeta(SearchResponse response, SearchChunkTrailer trailer) {
        CoreSearchStatus status = Mapper.decodeInto(response.header().getStatus(), CoreSearchStatus.class);
        CoreSearchMetrics metrics = new CoreSearchMetrics(Duration.ofNanos(trailer.took()), trailer.totalRows(), trailer.maxScore(), status.successCount(), status.errorCount());
        return new CoreSearchMetaData(status.errors() == null ? Collections.emptyMap() : status.errors(), metrics);
    }

    private CoreEnvironment environment() {
        return this.core.context().environment();
    }

    private ServerSearchRequest searchRequest(String indexName, CoreSearchQuery query, CoreSearchOptions opts) {
        Validators.notNullOrEmpty(indexName, "IndexName", () -> new ReducedSearchErrorContext(indexName, query));
        Duration timeout = opts.commonOptions().timeout().orElse(this.environment().timeoutConfig().searchTimeout());
        ObjectNode params = query.export();
        ObjectNode toSend = Mapper.createObjectNode();
        toSend.set("query", params);
        ClassicCoreSearchOps.injectOptions(indexName, toSend, timeout, opts, false);
        byte[] bytes = toSend.toString().getBytes(StandardCharsets.UTF_8);
        RetryStrategy retryStrategy = opts.commonOptions().retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("search", opts.commonOptions().parentSpan().orElse(null));
        ServerSearchRequest request = new ServerSearchRequest(timeout, this.core.context(), retryStrategy, this.core.context().authenticator(), indexName, bytes, span, this.scope);
        request.context().clientContext(opts.commonOptions().clientContext());
        return request;
    }

    private static void inject(ObjectNode queryJson, String field, @Nullable CoreSearchKeyset keyset) {
        if (keyset != null) {
            ArrayNode array = Mapper.createArrayNode();
            keyset.keys().forEach(array::add);
            queryJson.set(field, array);
        }
    }

    @Stability.Internal
    public static void injectOptions(String indexName, ObjectNode queryJson, Duration timeout, CoreSearchOptions opts, boolean disableShowRequest) {
        JsonNode raw;
        ObjectNode consistencyJson;
        if (opts.limit() != null && opts.limit() >= 0) {
            queryJson.put("size", opts.limit());
        }
        if (opts.skip() != null && opts.skip() >= 0) {
            queryJson.put("from", opts.skip());
        }
        ClassicCoreSearchOps.inject(queryJson, "search_before", opts.searchBefore());
        ClassicCoreSearchOps.inject(queryJson, "search_after", opts.searchAfter());
        if (opts.explain() != null) {
            queryJson.put("explain", opts.explain());
        }
        if (opts.highlightStyle() != null) {
            ObjectNode highlight = Mapper.createObjectNode();
            if (opts.highlightStyle() != CoreHighlightStyle.SERVER_DEFAULT) {
                highlight.put("style", opts.highlightStyle().name().toLowerCase());
            }
            if (!opts.highlightFields().isEmpty()) {
                Iterator<Map.Entry<String, CoreSearchFacet>> highlights = Mapper.createArrayNode();
                for (String s2 : opts.highlightFields()) {
                    ((ArrayNode)((Object)highlights)).add(s2);
                }
                highlight.set("fields", (JsonNode)((Object)highlights));
            }
            queryJson.set("highlight", highlight);
        }
        if (!opts.fields().isEmpty()) {
            ArrayNode fields = Mapper.createArrayNode();
            for (String field : opts.fields()) {
                fields.add(field);
            }
            queryJson.set("fields", fields);
        }
        if (!opts.sort().isEmpty()) {
            ArrayNode sort = Mapper.createArrayNode();
            opts.sort().forEach(s -> sort.add(s.toJsonNode()));
            queryJson.set("sort", sort);
        }
        if (opts.disableScoring().booleanValue()) {
            queryJson.put("score", "none");
        }
        if (!opts.facets().isEmpty()) {
            ObjectNode f = Mapper.createObjectNode();
            for (Map.Entry<String, CoreSearchFacet> entry : opts.facets().entrySet()) {
                ObjectNode facetJson = Mapper.createObjectNode();
                entry.getValue().injectParams(facetJson);
                f.set(entry.getKey(), facetJson);
            }
            queryJson.set("facets", f);
        }
        ObjectNode control = Mapper.createObjectNode();
        control.put("timeout", timeout.toMillis());
        if (opts.consistency() != null && opts.consistency() != CoreSearchScanConsistency.NOT_BOUNDED) {
            consistencyJson = Mapper.createObjectNode();
            consistencyJson.put("level", opts.consistency().toString());
            control.set("consistency", consistencyJson);
        }
        if (opts.consistentWith() != null) {
            consistencyJson = Mapper.createObjectNode();
            consistencyJson.put("level", "at_plus");
            ObjectNode vectors = Mapper.createObjectNode();
            opts.consistentWith().tokens().forEach(token -> {
                String tokenKey = token.partitionID() + "/" + token.partitionUUID();
                vectors.put(tokenKey, token.sequenceNumber());
            });
            ObjectNode consistentWithJson = Mapper.createObjectNode();
            consistentWithJson.set(indexName, vectors);
            consistencyJson.set("vectors", consistentWithJson);
            control.set("consistency", consistencyJson);
        }
        if (!control.isEmpty()) {
            queryJson.set("ctl", control);
        }
        if (!opts.collections().isEmpty()) {
            ArrayNode collections = Mapper.createArrayNode();
            for (String collection : opts.collections()) {
                collections.add(collection);
            }
            queryJson.set("collections", collections);
        }
        if (opts.includeLocations() != null) {
            queryJson.put("includeLocations", opts.includeLocations());
        }
        if ((raw = opts.raw()) != null) {
            Iterator<String> it = raw.fieldNames();
            while (it.hasNext()) {
                String fieldName = it.next();
                queryJson.set(fieldName, raw.get(fieldName));
            }
        }
        if (disableShowRequest) {
            queryJson.put("showrequest", false);
        }
    }

    @Override
    public CoreAsyncResponse<CoreSearchResult> searchAsync(String indexName, CoreSearchRequest searchRequest, CoreSearchOptions options) {
        Duration timeout = options.commonOptions().timeout().orElse(this.core.environment().timeoutConfig().searchTimeout());
        return this.searchAsyncShared(this.searchRequestV2(indexName, searchRequest, options), searchRequest.vectorSearch != null, timeout);
    }

    @Override
    public Mono<CoreReactiveSearchResult> searchReactive(String indexName, CoreSearchRequest searchRequest, CoreSearchOptions options) {
        Duration timeout = options.commonOptions().timeout().orElse(this.core.environment().timeoutConfig().searchTimeout());
        return this.searchReactiveShared(this.searchRequestV2(indexName, searchRequest, options), searchRequest.vectorSearch != null, timeout);
    }

    private CoreAsyncResponse<CoreSearchResult> searchAsyncShared(ServerSearchRequest request, boolean requiresVectorIndexSupport, Duration timeout) {
        return this.preflightCheckScopedIndexes(timeout).flatMap(ignore -> this.preflightCheckVectorIndexes(requiresVectorIndexSupport, timeout)).flatMap(ignore -> {
            this.core.send(request);
            return new CoreAsyncResponse(Mono.fromFuture(request.response()).flatMap(response -> response.rows().map(CoreSearchRow::fromResponse).collectList().flatMap(rows -> response.trailer().map(trailer -> new CoreSearchResult((List<CoreSearchRow>)rows, ClassicCoreSearchOps.parseFacets(trailer), ClassicCoreSearchOps.parseMeta(response, trailer))))).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete((Throwable)err)).toFuture(), () -> {});
        });
    }

    public Mono<CoreReactiveSearchResult> searchReactiveShared(ServerSearchRequest request, boolean requiresVectorIndexSupport, Duration timeout) {
        return this.preflightCheckScopedIndexes(timeout).toMono().then(Mono.defer(() -> this.preflightCheckVectorIndexes(requiresVectorIndexSupport, timeout).toMono())).then(Mono.defer(() -> {
            this.core.send(request);
            return Mono.fromFuture(request.response()).map(response -> {
                Flux rows = response.rows().map(CoreSearchRow::fromResponse);
                Mono meta = response.trailer().map(trailer -> ClassicCoreSearchOps.parseMeta(response, trailer));
                Mono facets = response.trailer().map(ClassicCoreSearchOps::parseFacets);
                return new CoreReactiveSearchResult((Flux<CoreSearchRow>)rows, (Mono<Map<String, CoreSearchFacetResult>>)facets, (Mono<CoreSearchMetaData>)meta);
            }).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete((Throwable)err));
        }));
    }

    private ServerSearchRequest searchRequestV2(String indexName, CoreSearchRequest searchRequest, CoreSearchOptions opts) {
        Validators.notNull(indexName, "indexName");
        Duration timeout = opts.commonOptions().timeout().orElse(this.environment().timeoutConfig().searchTimeout());
        ObjectNode topLevel = searchRequest.toJson();
        ClassicCoreSearchOps.injectOptions(indexName, topLevel, timeout, opts, true);
        byte[] bytes = topLevel.toString().getBytes(StandardCharsets.UTF_8);
        RetryStrategy retryStrategy = opts.commonOptions().retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("search", opts.commonOptions().parentSpan().orElse(null));
        ServerSearchRequest request = new ServerSearchRequest(timeout, this.core.context(), retryStrategy, this.core.context().authenticator(), indexName, bytes, span, this.scope);
        request.context().clientContext(opts.commonOptions().clientContext());
        return request;
    }
}

