/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocation;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Stability.Internal
public class CoreSearchRowLocations {
    private final Map<String, Map<String, List<CoreSearchRowLocation>>> locations = new HashMap<String, Map<String, List<CoreSearchRowLocation>>>();
    private int size;

    private CoreSearchRowLocations add(CoreSearchRowLocation l) {
        Map byTerm = this.locations.computeIfAbsent(l.field(), k -> new HashMap());
        List list = byTerm.computeIfAbsent(l.term(), k -> new ArrayList());
        list.add(l);
        ++this.size;
        return this;
    }

    public List<CoreSearchRowLocation> get(String field) {
        Map<String, List<CoreSearchRowLocation>> byTerm = this.locations.get(field);
        if (byTerm == null) {
            return Collections.emptyList();
        }
        LinkedList<CoreSearchRowLocation> result = new LinkedList<CoreSearchRowLocation>();
        for (List<CoreSearchRowLocation> termList : byTerm.values()) {
            result.addAll(termList);
        }
        return result;
    }

    public List<CoreSearchRowLocation> get(String field, String term) {
        Map<String, List<CoreSearchRowLocation>> byTerm = this.locations.get(field);
        if (byTerm == null) {
            return Collections.emptyList();
        }
        List<CoreSearchRowLocation> result = byTerm.get(term);
        if (result == null) {
            return Collections.emptyList();
        }
        return new ArrayList<CoreSearchRowLocation>(result);
    }

    public List<CoreSearchRowLocation> getAll() {
        LinkedList<CoreSearchRowLocation> all = new LinkedList<CoreSearchRowLocation>();
        for (Map.Entry<String, Map<String, List<CoreSearchRowLocation>>> terms : this.locations.entrySet()) {
            for (List<CoreSearchRowLocation> rowLocations : terms.getValue().values()) {
                all.addAll(rowLocations);
            }
        }
        return all;
    }

    public List<String> fields() {
        return new ArrayList<String>(this.locations.keySet());
    }

    public List<String> termsFor(String field) {
        Map<String, List<CoreSearchRowLocation>> termMap = this.locations.get(field);
        if (termMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(termMap.keySet());
    }

    public Set<String> terms() {
        HashSet<String> termSet = new HashSet<String>();
        for (Map<String, List<CoreSearchRowLocation>> termMap : this.locations.values()) {
            termSet.addAll(termMap.keySet());
        }
        return termSet;
    }

    public static CoreSearchRowLocations from(List<CoreSearchRowLocation> locations) {
        CoreSearchRowLocations result = new CoreSearchRowLocations();
        locations.forEach(result::add);
        return result;
    }

    public static CoreSearchRowLocations from(ObjectNode locationsJson) {
        CoreSearchRowLocations hitLocations = new CoreSearchRowLocations();
        if (locationsJson == null) {
            return hitLocations;
        }
        locationsJson.fieldNames().forEachRemaining(field -> {
            ObjectNode termsJson = (ObjectNode)locationsJson.get((String)field);
            termsJson.fieldNames().forEachRemaining(term -> {
                ArrayNode locsJson = (ArrayNode)termsJson.get((String)term);
                for (int i = 0; i < locsJson.size(); ++i) {
                    ObjectNode loc = (ObjectNode)locsJson.get(i);
                    long pos = loc.get("pos").longValue();
                    long start = loc.get("start").longValue();
                    long end = loc.get("end").asLong();
                    JsonNode positions = loc.get("array_positions");
                    long[] arrayPositions = null;
                    if (positions != null && positions.isArray()) {
                        ArrayNode arrayPositionsJson = (ArrayNode)positions;
                        arrayPositions = new long[arrayPositionsJson.size()];
                        for (int j = 0; j < arrayPositionsJson.size(); ++j) {
                            arrayPositions[j] = arrayPositionsJson.get(j).longValue();
                        }
                    }
                    hitLocations.add(new CoreSearchRowLocation((String)field, (String)term, pos, start, end, arrayPositions));
                }
            });
        });
        return hitLocations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SearchRowLocations{").append("size=").append(this.size).append(", locations=[");
        for (Map<String, List<CoreSearchRowLocation>> map : this.locations.values()) {
            for (List<CoreSearchRowLocation> rowLocations : map.values()) {
                for (CoreSearchRowLocation rowLocation : rowLocations) {
                    sb.append(rowLocation).append(",");
                }
            }
        }
        if (!this.locations.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }
}

