/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.encryption;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbStrings;
import java.util.Map;

@Stability.Volatile
public interface CryptoManager {
    public static final String DEFAULT_ENCRYPTER_ALIAS = "__DEFAULT__";
    public static final String DEFAULT_ENCRYPTED_FIELD_NAME_PREFIX = "encrypted$";

    public Map<String, Object> encrypt(byte[] var1, String var2);

    public byte[] decrypt(Map<String, Object> var1);

    default public String mangle(String fieldName) {
        return DEFAULT_ENCRYPTED_FIELD_NAME_PREFIX + fieldName;
    }

    default public String demangle(String fieldName) {
        return CbStrings.removeStart(fieldName, DEFAULT_ENCRYPTED_FIELD_NAME_PREFIX);
    }

    default public boolean isMangled(String fieldName) {
        return fieldName.startsWith(DEFAULT_ENCRYPTED_FIELD_NAME_PREFIX);
    }
}

