/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompressionConfig {
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_MIN_SIZE = 32;
    public static final double DEFAULT_MIN_RATIO = 0.83;
    private final boolean enabled;
    private final int minSize;
    private final double minRatio;

    @Deprecated
    public static CompressionConfig create() {
        return CompressionConfig.builder().build();
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder enable(boolean enabled) {
        return CompressionConfig.builder().enable(enabled);
    }

    @Deprecated
    public static Builder minSize(int minSize) {
        return CompressionConfig.builder().minSize(minSize);
    }

    @Deprecated
    public static Builder minRatio(double minRatio) {
        return CompressionConfig.builder().minRatio(minRatio);
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("enabled", this.enabled);
        export.put("minRatio", this.minRatio);
        export.put("minSize", this.minSize);
        return export;
    }

    private CompressionConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.minRatio = builder.minRatio;
        this.minSize = builder.minSize;
    }

    public int minSize() {
        return this.minSize;
    }

    public double minRatio() {
        return this.minRatio;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public static class Builder {
        private boolean enabled = true;
        private int minSize = 32;
        private double minRatio = 0.83;

        public CompressionConfig build() {
            return new CompressionConfig(this);
        }

        public Builder enable(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder minRatio(double minRatio) {
            this.minRatio = minRatio;
            return this;
        }
    }
}

