/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class ScopeNotFoundException
extends CouchbaseException {
    private final String scopeName;

    @Stability.Internal
    public ScopeNotFoundException(String scopeName, @Nullable ErrorContext context) {
        super("Scope" + ScopeNotFoundException.formatName(scopeName) + " not found.", context);
        this.scopeName = Objects.requireNonNull(scopeName);
    }

    private static String formatName(String name) {
        return CbStrings.isNullOrEmpty(name) ? "" : " [" + RedactableArgument.redactMeta(name) + "]";
    }

    public static ScopeNotFoundException forScope(String scopeName) {
        return new ScopeNotFoundException(scopeName, null);
    }

    public String scopeName() {
        return this.scopeName;
    }
}

