/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.KetamaRingNode;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.HostAndPort;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class HostAndServicePorts
implements KetamaRingNode {
    public static final HostAndServicePorts INACCESSIBLE = new HostAndServicePorts("<inaccessible>", Collections.emptyMap(), new NodeIdentifier("<inaccessible>", 0, "<inaccessible>"), null, null);
    private final String host;
    private final Map<ServiceType, Integer> ports;
    private final NodeIdentifier id;
    @Nullable
    private final HostAndPort ketamaAuthority;
    @Nullable
    private final String serverGroup;

    public HostAndServicePorts(String host, Map<ServiceType, Integer> ports, NodeIdentifier id, @Nullable HostAndPort ketamaAuthority, @Nullable String serverGroup) {
        this.host = Objects.requireNonNull(host);
        this.ports = Collections.unmodifiableMap(CbCollections.newEnumMap(ServiceType.class, ports));
        this.id = Objects.requireNonNull(id);
        this.ketamaAuthority = ketamaAuthority;
        this.serverGroup = serverGroup;
    }

    public boolean inaccessible() {
        return this == INACCESSIBLE;
    }

    public NodeIdentifier id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    @Override
    @Nullable
    public HostAndPort ketamaAuthority() {
        return this.ketamaAuthority;
    }

    public OptionalInt port(ServiceType serviceType) {
        Integer port = this.ports.get((Object)serviceType);
        return port == null ? OptionalInt.empty() : OptionalInt.of(port);
    }

    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    @Nullable
    public String serverGroup() {
        return this.serverGroup;
    }

    public boolean has(ServiceType serviceType) {
        return this.ports.containsKey((Object)serviceType);
    }

    @Stability.Internal
    public HostAndServicePorts without(ServiceType service, ServiceType ... moreServices) {
        if (!this.has(service) && Arrays.stream(moreServices).noneMatch(this::has)) {
            return this;
        }
        EnumMap<ServiceType, Integer> temp = CbCollections.newEnumMap(ServiceType.class, this.ports());
        temp.remove((Object)service);
        for (ServiceType t : moreServices) {
            temp.remove((Object)t);
        }
        return new HostAndServicePorts(this.host, temp, this.id, this.ketamaAuthority, this.serverGroup);
    }

    @Stability.Internal
    public HostAndServicePorts withKetamaAuthority(@Nullable HostAndPort ketamaAuthority) {
        if (Objects.equals(this.ketamaAuthority, ketamaAuthority)) {
            return this;
        }
        return new HostAndServicePorts(this.host, this.ports, this.id, ketamaAuthority, this.serverGroup);
    }

    boolean matches(SeedNode seedNode) {
        return this.host.equals(seedNode.address()) && (this.portEquals(ServiceType.KV, seedNode.kvPort().orElse(0)) || this.portEquals(ServiceType.MANAGER, seedNode.clusterManagerPort().orElse(0)));
    }

    private boolean portEquals(ServiceType serviceType, int port) {
        int actualPort = this.port(serviceType).orElse(0);
        return actualPort != 0 && actualPort == port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndServicePorts that = (HostAndServicePorts)o;
        return this.host.equals(that.host) && this.ports.equals(that.ports) && Objects.equals(this.ketamaAuthority, that.ketamaAuthority);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ports);
    }

    public String toString() {
        return "HostAndServicePorts{host='" + RedactableArgument.redactSystem(this.host) + '\'' + ", ports=" + RedactableArgument.redactSystem(this.ports) + ", id=" + RedactableArgument.redactSystem(this.id) + ", ketamaAuthority=" + RedactableArgument.redactSystem(this.ketamaAuthority) + '}';
    }
}

