/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.topology.AbstractBucketTopology;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.KetamaRing;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Stability.Internal
public class MemcachedBucketTopology
extends AbstractBucketTopology {
    private final KetamaRing<HostAndServicePorts> ketamaRing;
    private final MemcachedHashingStrategy hashingStrategy;

    public MemcachedBucketTopology(String uuid, String name, Set<BucketCapability> capabilities, List<HostAndServicePorts> nodes, KetamaRing<HostAndServicePorts> ketamaRing, MemcachedHashingStrategy hashingStrategy) {
        super(uuid, name, capabilities, nodes);
        this.ketamaRing = Objects.requireNonNull(ketamaRing);
        this.hashingStrategy = Objects.requireNonNull(hashingStrategy);
    }

    public HostAndServicePorts nodeForKey(byte[] id) {
        return this.ketamaRing.get(id);
    }

    KetamaRing<HostAndServicePorts> ketamaRing() {
        return this.ketamaRing;
    }

    @Stability.Internal
    public MemcachedHashingStrategy hashingStrategy() {
        return this.hashingStrategy;
    }

    public String toString() {
        return "MemcachedBucketTopology{name='" + RedactableArgument.redactMeta(this.name()) + '\'' + ", uuid='" + this.uuid() + '\'' + ", capabilities=" + this.capabilities() + ", hashingStrategy=" + this.hashingStrategy.getClass().getSimpleName() + '}';
    }
}

