/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.ClusterTopologyParser;
import com.couchbase.client.core.topology.JacksonHelper;
import com.couchbase.client.core.topology.NetworkSelector;
import com.couchbase.client.core.topology.PortSelector;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class TopologyParser {
    private static final Logger log = LoggerFactory.getLogger(TopologyParser.class);
    private final NetworkSelector networkSelector;
    private final PortSelector portSelector;
    private final MemcachedHashingStrategy memcachedHashingStrategy;

    public TopologyParser(NetworkSelector networkSelector, PortSelector portSelector, MemcachedHashingStrategy memcachedHashingStrategy) {
        this.networkSelector = Objects.requireNonNull(networkSelector);
        this.portSelector = Objects.requireNonNull(portSelector);
        this.memcachedHashingStrategy = Objects.requireNonNull(memcachedHashingStrategy);
    }

    public ClusterTopology parse(String json, String originHost) {
        return this.parse(JacksonHelper.readObject(json), originHost);
    }

    public ClusterTopology parse(ObjectNode json, String originHost) {
        log.debug("Parsing topology JSON from origin '{}' : {}", (Object)RedactableArgument.redactSystem(originHost), (Object)RedactableArgument.redactSystem(json));
        ClusterTopology result = ClusterTopologyParser.parse(json, originHost, this.portSelector, this.networkSelector, this.memcachedHashingStrategy);
        log.debug("Parsed topology: {}", (Object)RedactableArgument.redactSystem(result));
        return result;
    }
}

