/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    public static <L, R> Either<L, R> of(@Nullable L left, @Nullable R right) {
        return new Either<L, R>(left, right);
    }

    public static <L, R> Either<L, R> ofLeft(L left) {
        Objects.requireNonNull(left, "`Either` cannot hold null values");
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> ofRight(R right) {
        Objects.requireNonNull(right, "`Either` cannot hold null values");
        return new Either<Object, R>(null, right);
    }

    private Either(@Nullable L left, @Nullable R right) {
        if (left == null && right == null) {
            throw new IllegalArgumentException("Exactly one of left/right must be non-null, but both were null.");
        }
        if (left != null && right != null) {
            throw new IllegalArgumentException("Exactly one of left/right must be non-null, but both were non-null.");
        }
        this.left = Optional.ofNullable(left);
        this.right = Optional.ofNullable(right);
    }

    public Optional<L> left() {
        return this.left;
    }

    public Optional<R> right() {
        return this.right;
    }

    public void ifPresent(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        this.left().ifPresent(leftConsumer);
        this.right().ifPresent(rightConsumer);
    }

    public String toString() {
        return "Either{left=" + this.left.orElse(null) + ", right=" + this.right.orElse(null) + '}';
    }
}

