/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.InetAddresses;
import java.net.Inet6Address;
import java.net.InetAddress;

@Stability.Internal
public class NetworkAddress {
    public static final String REVERSE_DNS_PROPERTY = "com.couchbase.allowReverseDns";
    public static final String FORCE_IPV4_PROPERTY = "com.couchbase.forceIPv4";
    public static final boolean ALLOW_REVERSE_DNS = Boolean.parseBoolean(System.getProperty("com.couchbase.allowReverseDns", "true"));
    public static final boolean FORCE_IPV4 = Boolean.parseBoolean(System.getProperty("com.couchbase.forceIPv4", "false"));
    private final InetAddress inner;
    private final boolean createdFromHostname;
    private final boolean allowReverseDns;

    NetworkAddress(String input, boolean reverseDns) {
        try {
            InetAddress foundAddr = null;
            for (InetAddress addr : InetAddress.getAllByName(input)) {
                if (addr instanceof Inet6Address && FORCE_IPV4) continue;
                foundAddr = addr;
                break;
            }
            if (foundAddr == null) {
                if (FORCE_IPV4) {
                    throw new IllegalArgumentException("No IPv4 address found for \"" + input + "\"");
                }
                throw new IllegalArgumentException("No IPv4 or IPv6 address found for \"" + input + "\"");
            }
            this.inner = foundAddr;
            this.createdFromHostname = !InetAddresses.isInetAddress(input);
            this.allowReverseDns = reverseDns;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create NetworkAddress.", ex);
        }
    }

    private NetworkAddress(String input) {
        this(input, ALLOW_REVERSE_DNS);
    }

    @Stability.Internal
    public static NetworkAddress create(String input) {
        return new NetworkAddress(input);
    }

    @Stability.Internal
    public String hostname() {
        if (this.allowReverseDns || this.createdFromHostname) {
            return this.inner.getHostName();
        }
        throw new IllegalStateException("NetworkAddress not created from hostname and reverse dns lookup disabled!");
    }

    public String toString() {
        return "NetworkAddress{" + this.inner + ", fromHostname=" + this.createdFromHostname + ", reverseDns=" + this.allowReverseDns + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAddress that = (NetworkAddress)o;
        return this.inner.equals(that.inner);
    }

    public int hashCode() {
        return this.inner.hashCode();
    }
}

