/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.http.AsyncCouchbaseHttpClient;
import com.couchbase.client.java.http.HttpDeleteOptions;
import com.couchbase.client.java.http.HttpGetOptions;
import com.couchbase.client.java.http.HttpPath;
import com.couchbase.client.java.http.HttpPostOptions;
import com.couchbase.client.java.http.HttpPutOptions;
import com.couchbase.client.java.http.HttpResponse;
import com.couchbase.client.java.http.HttpTarget;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveCouchbaseHttpClient {
    private final ReactorOps reactor;
    private final AsyncCouchbaseHttpClient async;

    @Stability.Internal
    public ReactiveCouchbaseHttpClient(ReactorOps reactor, AsyncCouchbaseHttpClient async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public Mono<HttpResponse> get(HttpTarget target, HttpPath path) {
        return this.reactor.publishOnUserScheduler(() -> this.async.get(target, path));
    }

    public Mono<HttpResponse> get(HttpTarget target, HttpPath path, HttpGetOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.get(target, path, options));
    }

    public Mono<HttpResponse> post(HttpTarget target, HttpPath path) {
        return this.reactor.publishOnUserScheduler(() -> this.async.post(target, path));
    }

    public Mono<HttpResponse> post(HttpTarget target, HttpPath path, HttpPostOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.post(target, path, options));
    }

    public Mono<HttpResponse> put(HttpTarget target, HttpPath path) {
        return this.reactor.publishOnUserScheduler(() -> this.async.put(target, path));
    }

    public Mono<HttpResponse> put(HttpTarget target, HttpPath path, HttpPutOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.put(target, path, options));
    }

    public Mono<HttpResponse> delete(HttpTarget target, HttpPath path) {
        return this.reactor.publishOnUserScheduler(() -> this.async.delete(target, path));
    }

    public Mono<HttpResponse> delete(HttpTarget target, HttpPath path, HttpDeleteOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.delete(target, path, options));
    }
}

