/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/client.proto

// Protobuf Java Version: 3.25.3
package com.couchbase.client.core.deps.com.google.api;

/**
 *
 *
 * <pre>
 * This message configures the settings for publishing [Google Cloud Client
 * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
 * generated from the service config.
 * </pre>
 *
 * Protobuf type {@code google.api.Publishing}
 */
public final class Publishing extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Publishing)
    PublishingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Publishing.newBuilder() to construct.
  private Publishing(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Publishing() {
    methodSettings_ = java.util.Collections.emptyList();
    newIssueUri_ = "";
    documentationUri_ = "";
    apiShortName_ = "";
    githubLabel_ = "";
    codeownerGithubTeams_ = com.google.protobuf.LazyStringArrayList.emptyList();
    docTagPrefix_ = "";
    organization_ = 0;
    librarySettings_ = java.util.Collections.emptyList();
    protoReferenceDocumentationUri_ = "";
    restReferenceDocumentationUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Publishing();
  }

  public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.ClientProto.internal_static_google_api_Publishing_descriptor;
  }

  @java.lang.Override
  protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ClientProto.internal_static_google_api_Publishing_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Publishing.class, com.google.api.Publishing.Builder.class);
  }

  public static final int METHOD_SETTINGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.MethodSettings> methodSettings_;
  /**
   *
   *
   * <pre>
   * A list of API method settings, e.g. the behavior for methods that use the
   * long-running operation pattern.
   * </pre>
   *
   * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.MethodSettings> getMethodSettingsList() {
    return methodSettings_;
  }
  /**
   *
   *
   * <pre>
   * A list of API method settings, e.g. the behavior for methods that use the
   * long-running operation pattern.
   * </pre>
   *
   * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.MethodSettingsOrBuilder>
      getMethodSettingsOrBuilderList() {
    return methodSettings_;
  }
  /**
   *
   *
   * <pre>
   * A list of API method settings, e.g. the behavior for methods that use the
   * long-running operation pattern.
   * </pre>
   *
   * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
   */
  @java.lang.Override
  public int getMethodSettingsCount() {
    return methodSettings_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of API method settings, e.g. the behavior for methods that use the
   * long-running operation pattern.
   * </pre>
   *
   * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MethodSettings getMethodSettings(int index) {
    return methodSettings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of API method settings, e.g. the behavior for methods that use the
   * long-running operation pattern.
   * </pre>
   *
   * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MethodSettingsOrBuilder getMethodSettingsOrBuilder(int index) {
    return methodSettings_.get(index);
  }

  public static final int NEW_ISSUE_URI_FIELD_NUMBER = 101;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newIssueUri_ = "";
  /**
   *
   *
   * <pre>
   * Link to a *public* URI where users can report issues.  Example:
   * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
   * </pre>
   *
   * <code>string new_issue_uri = 101;</code>
   *
   * @return The newIssueUri.
   */
  @java.lang.Override
  public java.lang.String getNewIssueUri() {
    java.lang.Object ref = newIssueUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newIssueUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Link to a *public* URI where users can report issues.  Example:
   * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
   * </pre>
   *
   * <code>string new_issue_uri = 101;</code>
   *
   * @return The bytes for newIssueUri.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNewIssueUriBytes() {
    java.lang.Object ref = newIssueUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newIssueUri_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_URI_FIELD_NUMBER = 102;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentationUri_ = "";
  /**
   *
   *
   * <pre>
   * Link to product home page.  Example:
   * https://cloud.google.com/asset-inventory/docs/overview
   * </pre>
   *
   * <code>string documentation_uri = 102;</code>
   *
   * @return The documentationUri.
   */
  @java.lang.Override
  public java.lang.String getDocumentationUri() {
    java.lang.Object ref = documentationUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Link to product home page.  Example:
   * https://cloud.google.com/asset-inventory/docs/overview
   * </pre>
   *
   * <code>string documentation_uri = 102;</code>
   *
   * @return The bytes for documentationUri.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDocumentationUriBytes() {
    java.lang.Object ref = documentationUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentationUri_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int API_SHORT_NAME_FIELD_NUMBER = 103;

  @SuppressWarnings("serial")
  private volatile java.lang.Object apiShortName_ = "";
  /**
   *
   *
   * <pre>
   * Used as a tracking tag when collecting data about the APIs developer
   * relations artifacts like docs, packages delivered to package managers,
   * etc.  Example: "speech".
   * </pre>
   *
   * <code>string api_short_name = 103;</code>
   *
   * @return The apiShortName.
   */
  @java.lang.Override
  public java.lang.String getApiShortName() {
    java.lang.Object ref = apiShortName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiShortName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used as a tracking tag when collecting data about the APIs developer
   * relations artifacts like docs, packages delivered to package managers,
   * etc.  Example: "speech".
   * </pre>
   *
   * <code>string api_short_name = 103;</code>
   *
   * @return The bytes for apiShortName.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getApiShortNameBytes() {
    java.lang.Object ref = apiShortName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiShortName_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GITHUB_LABEL_FIELD_NUMBER = 104;

  @SuppressWarnings("serial")
  private volatile java.lang.Object githubLabel_ = "";
  /**
   *
   *
   * <pre>
   * GitHub label to apply to issues and pull requests opened for this API.
   * </pre>
   *
   * <code>string github_label = 104;</code>
   *
   * @return The githubLabel.
   */
  @java.lang.Override
  public java.lang.String getGithubLabel() {
    java.lang.Object ref = githubLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      githubLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * GitHub label to apply to issues and pull requests opened for this API.
   * </pre>
   *
   * <code>string github_label = 104;</code>
   *
   * @return The bytes for githubLabel.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getGithubLabelBytes() {
    java.lang.Object ref = githubLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      githubLabel_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODEOWNER_GITHUB_TEAMS_FIELD_NUMBER = 105;

  @SuppressWarnings("serial")
  private com.couchbase.client.core.deps.com.google.protobuf.LazyStringArrayList codeownerGithubTeams_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * GitHub teams to be added to CODEOWNERS in the directory in GitHub
   * containing source code for the client libraries for this API.
   * </pre>
   *
   * <code>repeated string codeowner_github_teams = 105;</code>
   *
   * @return A list containing the codeownerGithubTeams.
   */
  public com.couchbase.client.core.deps.com.google.protobuf.ProtocolStringList getCodeownerGithubTeamsList() {
    return codeownerGithubTeams_;
  }
  /**
   *
   *
   * <pre>
   * GitHub teams to be added to CODEOWNERS in the directory in GitHub
   * containing source code for the client libraries for this API.
   * </pre>
   *
   * <code>repeated string codeowner_github_teams = 105;</code>
   *
   * @return The count of codeownerGithubTeams.
   */
  public int getCodeownerGithubTeamsCount() {
    return codeownerGithubTeams_.size();
  }
  /**
   *
   *
   * <pre>
   * GitHub teams to be added to CODEOWNERS in the directory in GitHub
   * containing source code for the client libraries for this API.
   * </pre>
   *
   * <code>repeated string codeowner_github_teams = 105;</code>
   *
   * @param index The index of the element to return.
   * @return The codeownerGithubTeams at the given index.
   */
  public java.lang.String getCodeownerGithubTeams(int index) {
    return codeownerGithubTeams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * GitHub teams to be added to CODEOWNERS in the directory in GitHub
   * containing source code for the client libraries for this API.
   * </pre>
   *
   * <code>repeated string codeowner_github_teams = 105;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the codeownerGithubTeams at the given index.
   */
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getCodeownerGithubTeamsBytes(int index) {
    return codeownerGithubTeams_.getByteString(index);
  }

  public static final int DOC_TAG_PREFIX_FIELD_NUMBER = 106;

  @SuppressWarnings("serial")
  private volatile java.lang.Object docTagPrefix_ = "";
  /**
   *
   *
   * <pre>
   * A prefix used in sample code when demarking regions to be included in
   * documentation.
   * </pre>
   *
   * <code>string doc_tag_prefix = 106;</code>
   *
   * @return The docTagPrefix.
   */
  @java.lang.Override
  public java.lang.String getDocTagPrefix() {
    java.lang.Object ref = docTagPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      docTagPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A prefix used in sample code when demarking regions to be included in
   * documentation.
   * </pre>
   *
   * <code>string doc_tag_prefix = 106;</code>
   *
   * @return The bytes for docTagPrefix.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDocTagPrefixBytes() {
    java.lang.Object ref = docTagPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      docTagPrefix_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORGANIZATION_FIELD_NUMBER = 107;
  private int organization_ = 0;
  /**
   *
   *
   * <pre>
   * For whom the client library is being published.
   * </pre>
   *
   * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
   *
   * @return The enum numeric value on the wire for organization.
   */
  @java.lang.Override
  public int getOrganizationValue() {
    return organization_;
  }
  /**
   *
   *
   * <pre>
   * For whom the client library is being published.
   * </pre>
   *
   * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
   *
   * @return The organization.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.ClientLibraryOrganization getOrganization() {
    com.google.api.ClientLibraryOrganization result =
        com.google.api.ClientLibraryOrganization.forNumber(organization_);
    return result == null ? com.google.api.ClientLibraryOrganization.UNRECOGNIZED : result;
  }

  public static final int LIBRARY_SETTINGS_FIELD_NUMBER = 109;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings> librarySettings_;
  /**
   *
   *
   * <pre>
   * Client library settings.  If the same version string appears multiple
   * times in this list, then the last one wins.  Settings from earlier
   * settings with the same version string are discarded.
   * </pre>
   *
   * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings> getLibrarySettingsList() {
    return librarySettings_;
  }
  /**
   *
   *
   * <pre>
   * Client library settings.  If the same version string appears multiple
   * times in this list, then the last one wins.  Settings from earlier
   * settings with the same version string are discarded.
   * </pre>
   *
   * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.ClientLibrarySettingsOrBuilder>
      getLibrarySettingsOrBuilderList() {
    return librarySettings_;
  }
  /**
   *
   *
   * <pre>
   * Client library settings.  If the same version string appears multiple
   * times in this list, then the last one wins.  Settings from earlier
   * settings with the same version string are discarded.
   * </pre>
   *
   * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
   */
  @java.lang.Override
  public int getLibrarySettingsCount() {
    return librarySettings_.size();
  }
  /**
   *
   *
   * <pre>
   * Client library settings.  If the same version string appears multiple
   * times in this list, then the last one wins.  Settings from earlier
   * settings with the same version string are discarded.
   * </pre>
   *
   * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings getLibrarySettings(int index) {
    return librarySettings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Client library settings.  If the same version string appears multiple
   * times in this list, then the last one wins.  Settings from earlier
   * settings with the same version string are discarded.
   * </pre>
   *
   * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettingsOrBuilder getLibrarySettingsOrBuilder(int index) {
    return librarySettings_.get(index);
  }

  public static final int PROTO_REFERENCE_DOCUMENTATION_URI_FIELD_NUMBER = 110;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protoReferenceDocumentationUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional link to proto reference documentation.  Example:
   * https://cloud.google.com/pubsub/lite/docs/reference/rpc
   * </pre>
   *
   * <code>string proto_reference_documentation_uri = 110;</code>
   *
   * @return The protoReferenceDocumentationUri.
   */
  @java.lang.Override
  public java.lang.String getProtoReferenceDocumentationUri() {
    java.lang.Object ref = protoReferenceDocumentationUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protoReferenceDocumentationUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional link to proto reference documentation.  Example:
   * https://cloud.google.com/pubsub/lite/docs/reference/rpc
   * </pre>
   *
   * <code>string proto_reference_documentation_uri = 110;</code>
   *
   * @return The bytes for protoReferenceDocumentationUri.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getProtoReferenceDocumentationUriBytes() {
    java.lang.Object ref = protoReferenceDocumentationUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protoReferenceDocumentationUri_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REST_REFERENCE_DOCUMENTATION_URI_FIELD_NUMBER = 111;

  @SuppressWarnings("serial")
  private volatile java.lang.Object restReferenceDocumentationUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional link to REST reference documentation.  Example:
   * https://cloud.google.com/pubsub/lite/docs/reference/rest
   * </pre>
   *
   * <code>string rest_reference_documentation_uri = 111;</code>
   *
   * @return The restReferenceDocumentationUri.
   */
  @java.lang.Override
  public java.lang.String getRestReferenceDocumentationUri() {
    java.lang.Object ref = restReferenceDocumentationUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      restReferenceDocumentationUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional link to REST reference documentation.  Example:
   * https://cloud.google.com/pubsub/lite/docs/reference/rest
   * </pre>
   *
   * <code>string rest_reference_documentation_uri = 111;</code>
   *
   * @return The bytes for restReferenceDocumentationUri.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getRestReferenceDocumentationUriBytes() {
    java.lang.Object ref = restReferenceDocumentationUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      restReferenceDocumentationUri_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < methodSettings_.size(); i++) {
      output.writeMessage(2, methodSettings_.get(i));
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(newIssueUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, newIssueUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 102, documentationUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiShortName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 103, apiShortName_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(githubLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 104, githubLabel_);
    }
    for (int i = 0; i < codeownerGithubTeams_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 105, codeownerGithubTeams_.getRaw(i));
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(docTagPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 106, docTagPrefix_);
    }
    if (organization_
        != com.google.api.ClientLibraryOrganization.CLIENT_LIBRARY_ORGANIZATION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(107, organization_);
    }
    for (int i = 0; i < librarySettings_.size(); i++) {
      output.writeMessage(109, librarySettings_.get(i));
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protoReferenceDocumentationUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 110, protoReferenceDocumentationUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(restReferenceDocumentationUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 111, restReferenceDocumentationUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < methodSettings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, methodSettings_.get(i));
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(newIssueUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, newIssueUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(102, documentationUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiShortName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(103, apiShortName_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(githubLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(104, githubLabel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < codeownerGithubTeams_.size(); i++) {
        dataSize += computeStringSizeNoTag(codeownerGithubTeams_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getCodeownerGithubTeamsList().size();
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(docTagPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(106, docTagPrefix_);
    }
    if (organization_
        != com.google.api.ClientLibraryOrganization.CLIENT_LIBRARY_ORGANIZATION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(107, organization_);
    }
    for (int i = 0; i < librarySettings_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(109, librarySettings_.get(i));
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protoReferenceDocumentationUri_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              110, protoReferenceDocumentationUri_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(restReferenceDocumentationUri_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              111, restReferenceDocumentationUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Publishing)) {
      return super.equals(obj);
    }
    com.google.api.Publishing other = (com.couchbase.client.core.deps.com.google.api.Publishing) obj;

    if (!getMethodSettingsList().equals(other.getMethodSettingsList())) return false;
    if (!getNewIssueUri().equals(other.getNewIssueUri())) return false;
    if (!getDocumentationUri().equals(other.getDocumentationUri())) return false;
    if (!getApiShortName().equals(other.getApiShortName())) return false;
    if (!getGithubLabel().equals(other.getGithubLabel())) return false;
    if (!getCodeownerGithubTeamsList().equals(other.getCodeownerGithubTeamsList())) return false;
    if (!getDocTagPrefix().equals(other.getDocTagPrefix())) return false;
    if (organization_ != other.organization_) return false;
    if (!getLibrarySettingsList().equals(other.getLibrarySettingsList())) return false;
    if (!getProtoReferenceDocumentationUri().equals(other.getProtoReferenceDocumentationUri()))
      return false;
    if (!getRestReferenceDocumentationUri().equals(other.getRestReferenceDocumentationUri()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMethodSettingsCount() > 0) {
      hash = (37 * hash) + METHOD_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getMethodSettingsList().hashCode();
    }
    hash = (37 * hash) + NEW_ISSUE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNewIssueUri().hashCode();
    hash = (37 * hash) + DOCUMENTATION_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentationUri().hashCode();
    hash = (37 * hash) + API_SHORT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getApiShortName().hashCode();
    hash = (37 * hash) + GITHUB_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getGithubLabel().hashCode();
    if (getCodeownerGithubTeamsCount() > 0) {
      hash = (37 * hash) + CODEOWNER_GITHUB_TEAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCodeownerGithubTeamsList().hashCode();
    }
    hash = (37 * hash) + DOC_TAG_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getDocTagPrefix().hashCode();
    hash = (37 * hash) + ORGANIZATION_FIELD_NUMBER;
    hash = (53 * hash) + organization_;
    if (getLibrarySettingsCount() > 0) {
      hash = (37 * hash) + LIBRARY_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLibrarySettingsList().hashCode();
    }
    hash = (37 * hash) + PROTO_REFERENCE_DOCUMENTATION_URI_FIELD_NUMBER;
    hash = (53 * hash) + getProtoReferenceDocumentationUri().hashCode();
    hash = (37 * hash) + REST_REFERENCE_DOCUMENTATION_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRestReferenceDocumentationUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(com.couchbase.client.core.deps.com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(com.couchbase.client.core.deps.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.couchbase.client.core.deps.com.google.api.Publishing prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This message configures the settings for publishing [Google Cloud Client
   * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
   * generated from the service config.
   * </pre>
   *
   * Protobuf type {@code google.api.Publishing}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Publishing)
      com.google.api.PublishingOrBuilder {
    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ClientProto.internal_static_google_api_Publishing_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ClientProto.internal_static_google_api_Publishing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Publishing.class, com.google.api.Publishing.Builder.class);
    }

    // Construct using com.google.api.Publishing.newBuilder()
    private Builder() {}

    private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (methodSettingsBuilder_ == null) {
        methodSettings_ = java.util.Collections.emptyList();
      } else {
        methodSettings_ = null;
        methodSettingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      newIssueUri_ = "";
      documentationUri_ = "";
      apiShortName_ = "";
      githubLabel_ = "";
      codeownerGithubTeams_ = com.google.protobuf.LazyStringArrayList.emptyList();
      docTagPrefix_ = "";
      organization_ = 0;
      if (librarySettingsBuilder_ == null) {
        librarySettings_ = java.util.Collections.emptyList();
      } else {
        librarySettings_ = null;
        librarySettingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      protoReferenceDocumentationUri_ = "";
      restReferenceDocumentationUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.ClientProto.internal_static_google_api_Publishing_descriptor;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Publishing getDefaultInstanceForType() {
      return com.google.api.Publishing.getDefaultInstance();
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Publishing build() {
      com.google.api.Publishing result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Publishing buildPartial() {
      com.google.api.Publishing result = new com.google.api.Publishing(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.couchbase.client.core.deps.com.google.api.Publishing result) {
      if (methodSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          methodSettings_ = java.util.Collections.unmodifiableList(methodSettings_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.methodSettings_ = methodSettings_;
      } else {
        result.methodSettings_ = methodSettingsBuilder_.build();
      }
      if (librarySettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          librarySettings_ = java.util.Collections.unmodifiableList(librarySettings_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.librarySettings_ = librarySettings_;
      } else {
        result.librarySettings_ = librarySettingsBuilder_.build();
      }
    }

    private void buildPartial0(com.couchbase.client.core.deps.com.google.api.Publishing result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.newIssueUri_ = newIssueUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.documentationUri_ = documentationUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.apiShortName_ = apiShortName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.githubLabel_ = githubLabel_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        codeownerGithubTeams_.makeImmutable();
        result.codeownerGithubTeams_ = codeownerGithubTeams_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.docTagPrefix_ = docTagPrefix_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.organization_ = organization_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.protoReferenceDocumentationUri_ = protoReferenceDocumentationUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.restReferenceDocumentationUri_ = restReferenceDocumentationUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Publishing) {
        return mergeFrom((com.couchbase.client.core.deps.com.google.api.Publishing) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.api.Publishing other) {
      if (other == com.google.api.Publishing.getDefaultInstance()) return this;
      if (methodSettingsBuilder_ == null) {
        if (!other.methodSettings_.isEmpty()) {
          if (methodSettings_.isEmpty()) {
            methodSettings_ = other.methodSettings_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMethodSettingsIsMutable();
            methodSettings_.addAll(other.methodSettings_);
          }
          onChanged();
        }
      } else {
        if (!other.methodSettings_.isEmpty()) {
          if (methodSettingsBuilder_.isEmpty()) {
            methodSettingsBuilder_.dispose();
            methodSettingsBuilder_ = null;
            methodSettings_ = other.methodSettings_;
            bitField0_ = (bitField0_ & ~0x00000001);
            methodSettingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMethodSettingsFieldBuilder()
                    : null;
          } else {
            methodSettingsBuilder_.addAllMessages(other.methodSettings_);
          }
        }
      }
      if (!other.getNewIssueUri().isEmpty()) {
        newIssueUri_ = other.newIssueUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDocumentationUri().isEmpty()) {
        documentationUri_ = other.documentationUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getApiShortName().isEmpty()) {
        apiShortName_ = other.apiShortName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getGithubLabel().isEmpty()) {
        githubLabel_ = other.githubLabel_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.codeownerGithubTeams_.isEmpty()) {
        if (codeownerGithubTeams_.isEmpty()) {
          codeownerGithubTeams_ = other.codeownerGithubTeams_;
          bitField0_ |= 0x00000020;
        } else {
          ensureCodeownerGithubTeamsIsMutable();
          codeownerGithubTeams_.addAll(other.codeownerGithubTeams_);
        }
        onChanged();
      }
      if (!other.getDocTagPrefix().isEmpty()) {
        docTagPrefix_ = other.docTagPrefix_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.organization_ != 0) {
        setOrganizationValue(other.getOrganizationValue());
      }
      if (librarySettingsBuilder_ == null) {
        if (!other.librarySettings_.isEmpty()) {
          if (librarySettings_.isEmpty()) {
            librarySettings_ = other.librarySettings_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureLibrarySettingsIsMutable();
            librarySettings_.addAll(other.librarySettings_);
          }
          onChanged();
        }
      } else {
        if (!other.librarySettings_.isEmpty()) {
          if (librarySettingsBuilder_.isEmpty()) {
            librarySettingsBuilder_.dispose();
            librarySettingsBuilder_ = null;
            librarySettings_ = other.librarySettings_;
            bitField0_ = (bitField0_ & ~0x00000100);
            librarySettingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLibrarySettingsFieldBuilder()
                    : null;
          } else {
            librarySettingsBuilder_.addAllMessages(other.librarySettings_);
          }
        }
      }
      if (!other.getProtoReferenceDocumentationUri().isEmpty()) {
        protoReferenceDocumentationUri_ = other.protoReferenceDocumentationUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getRestReferenceDocumentationUri().isEmpty()) {
        restReferenceDocumentationUri_ = other.restReferenceDocumentationUri_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.api.MethodSettings m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.api.MethodSettings.parser(), extensionRegistry);
                if (methodSettingsBuilder_ == null) {
                  ensureMethodSettingsIsMutable();
                  methodSettings_.add(m);
                } else {
                  methodSettingsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 810:
              {
                newIssueUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 810
            case 818:
              {
                documentationUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 818
            case 826:
              {
                apiShortName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 826
            case 834:
              {
                githubLabel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 834
            case 842:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCodeownerGithubTeamsIsMutable();
                codeownerGithubTeams_.add(s);
                break;
              } // case 842
            case 850:
              {
                docTagPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 850
            case 856:
              {
                organization_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 856
            case 874:
              {
                com.google.api.ClientLibrarySettings m =
                    input.readMessage(
                        com.google.api.ClientLibrarySettings.parser(), extensionRegistry);
                if (librarySettingsBuilder_ == null) {
                  ensureLibrarySettingsIsMutable();
                  librarySettings_.add(m);
                } else {
                  librarySettingsBuilder_.addMessage(m);
                }
                break;
              } // case 874
            case 882:
              {
                protoReferenceDocumentationUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 882
            case 890:
              {
                restReferenceDocumentationUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 890
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.couchbase.client.core.deps.com.google.api.MethodSettings> methodSettings_ =
        java.util.Collections.emptyList();

    private void ensureMethodSettingsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        methodSettings_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.MethodSettings>(methodSettings_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MethodSettings,
            com.google.api.MethodSettings.Builder,
            com.google.api.MethodSettingsOrBuilder>
        methodSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MethodSettings> getMethodSettingsList() {
      if (methodSettingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(methodSettings_);
      } else {
        return methodSettingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public int getMethodSettingsCount() {
      if (methodSettingsBuilder_ == null) {
        return methodSettings_.size();
      } else {
        return methodSettingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MethodSettings getMethodSettings(int index) {
      if (methodSettingsBuilder_ == null) {
        return methodSettings_.get(index);
      } else {
        return methodSettingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder setMethodSettings(int index, com.google.api.MethodSettings value) {
      if (methodSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodSettingsIsMutable();
        methodSettings_.set(index, value);
        onChanged();
      } else {
        methodSettingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder setMethodSettings(
        int index, com.google.api.MethodSettings.Builder builderForValue) {
      if (methodSettingsBuilder_ == null) {
        ensureMethodSettingsIsMutable();
        methodSettings_.set(index, builderForValue.build());
        onChanged();
      } else {
        methodSettingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder addMethodSettings(com.couchbase.client.core.deps.com.google.api.MethodSettings value) {
      if (methodSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodSettingsIsMutable();
        methodSettings_.add(value);
        onChanged();
      } else {
        methodSettingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder addMethodSettings(int index, com.google.api.MethodSettings value) {
      if (methodSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodSettingsIsMutable();
        methodSettings_.add(index, value);
        onChanged();
      } else {
        methodSettingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder addMethodSettings(com.couchbase.client.core.deps.com.google.api.MethodSettings.Builder builderForValue) {
      if (methodSettingsBuilder_ == null) {
        ensureMethodSettingsIsMutable();
        methodSettings_.add(builderForValue.build());
        onChanged();
      } else {
        methodSettingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder addMethodSettings(
        int index, com.google.api.MethodSettings.Builder builderForValue) {
      if (methodSettingsBuilder_ == null) {
        ensureMethodSettingsIsMutable();
        methodSettings_.add(index, builderForValue.build());
        onChanged();
      } else {
        methodSettingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder addAllMethodSettings(
        java.lang.Iterable<? extends com.google.api.MethodSettings> values) {
      if (methodSettingsBuilder_ == null) {
        ensureMethodSettingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, methodSettings_);
        onChanged();
      } else {
        methodSettingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder clearMethodSettings() {
      if (methodSettingsBuilder_ == null) {
        methodSettings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        methodSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public Builder removeMethodSettings(int index) {
      if (methodSettingsBuilder_ == null) {
        ensureMethodSettingsIsMutable();
        methodSettings_.remove(index);
        onChanged();
      } else {
        methodSettingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MethodSettings.Builder getMethodSettingsBuilder(int index) {
      return getMethodSettingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MethodSettingsOrBuilder getMethodSettingsOrBuilder(int index) {
      if (methodSettingsBuilder_ == null) {
        return methodSettings_.get(index);
      } else {
        return methodSettingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public java.util.List<? extends com.google.api.MethodSettingsOrBuilder>
        getMethodSettingsOrBuilderList() {
      if (methodSettingsBuilder_ != null) {
        return methodSettingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(methodSettings_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MethodSettings.Builder addMethodSettingsBuilder() {
      return getMethodSettingsFieldBuilder()
          .addBuilder(com.couchbase.client.core.deps.com.google.api.MethodSettings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MethodSettings.Builder addMethodSettingsBuilder(int index) {
      return getMethodSettingsFieldBuilder()
          .addBuilder(index, com.google.api.MethodSettings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API method settings, e.g. the behavior for methods that use the
     * long-running operation pattern.
     * </pre>
     *
     * <code>repeated .google.api.MethodSettings method_settings = 2;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MethodSettings.Builder> getMethodSettingsBuilderList() {
      return getMethodSettingsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MethodSettings,
            com.google.api.MethodSettings.Builder,
            com.google.api.MethodSettingsOrBuilder>
        getMethodSettingsFieldBuilder() {
      if (methodSettingsBuilder_ == null) {
        methodSettingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MethodSettings,
                com.google.api.MethodSettings.Builder,
                com.google.api.MethodSettingsOrBuilder>(
                methodSettings_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        methodSettings_ = null;
      }
      return methodSettingsBuilder_;
    }

    private java.lang.Object newIssueUri_ = "";
    /**
     *
     *
     * <pre>
     * Link to a *public* URI where users can report issues.  Example:
     * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
     * </pre>
     *
     * <code>string new_issue_uri = 101;</code>
     *
     * @return The newIssueUri.
     */
    public java.lang.String getNewIssueUri() {
      java.lang.Object ref = newIssueUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newIssueUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to a *public* URI where users can report issues.  Example:
     * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
     * </pre>
     *
     * <code>string new_issue_uri = 101;</code>
     *
     * @return The bytes for newIssueUri.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNewIssueUriBytes() {
      java.lang.Object ref = newIssueUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newIssueUri_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to a *public* URI where users can report issues.  Example:
     * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
     * </pre>
     *
     * <code>string new_issue_uri = 101;</code>
     *
     * @param value The newIssueUri to set.
     * @return This builder for chaining.
     */
    public Builder setNewIssueUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newIssueUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to a *public* URI where users can report issues.  Example:
     * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
     * </pre>
     *
     * <code>string new_issue_uri = 101;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewIssueUri() {
      newIssueUri_ = getDefaultInstance().getNewIssueUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to a *public* URI where users can report issues.  Example:
     * https://issuetracker.google.com/issues/new?component=190865&amp;template=1161103
     * </pre>
     *
     * <code>string new_issue_uri = 101;</code>
     *
     * @param value The bytes for newIssueUri to set.
     * @return This builder for chaining.
     */
    public Builder setNewIssueUriBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newIssueUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object documentationUri_ = "";
    /**
     *
     *
     * <pre>
     * Link to product home page.  Example:
     * https://cloud.google.com/asset-inventory/docs/overview
     * </pre>
     *
     * <code>string documentation_uri = 102;</code>
     *
     * @return The documentationUri.
     */
    public java.lang.String getDocumentationUri() {
      java.lang.Object ref = documentationUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to product home page.  Example:
     * https://cloud.google.com/asset-inventory/docs/overview
     * </pre>
     *
     * <code>string documentation_uri = 102;</code>
     *
     * @return The bytes for documentationUri.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDocumentationUriBytes() {
      java.lang.Object ref = documentationUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentationUri_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Link to product home page.  Example:
     * https://cloud.google.com/asset-inventory/docs/overview
     * </pre>
     *
     * <code>string documentation_uri = 102;</code>
     *
     * @param value The documentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentationUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to product home page.  Example:
     * https://cloud.google.com/asset-inventory/docs/overview
     * </pre>
     *
     * <code>string documentation_uri = 102;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentationUri() {
      documentationUri_ = getDefaultInstance().getDocumentationUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Link to product home page.  Example:
     * https://cloud.google.com/asset-inventory/docs/overview
     * </pre>
     *
     * <code>string documentation_uri = 102;</code>
     *
     * @param value The bytes for documentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationUriBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentationUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object apiShortName_ = "";
    /**
     *
     *
     * <pre>
     * Used as a tracking tag when collecting data about the APIs developer
     * relations artifacts like docs, packages delivered to package managers,
     * etc.  Example: "speech".
     * </pre>
     *
     * <code>string api_short_name = 103;</code>
     *
     * @return The apiShortName.
     */
    public java.lang.String getApiShortName() {
      java.lang.Object ref = apiShortName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiShortName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used as a tracking tag when collecting data about the APIs developer
     * relations artifacts like docs, packages delivered to package managers,
     * etc.  Example: "speech".
     * </pre>
     *
     * <code>string api_short_name = 103;</code>
     *
     * @return The bytes for apiShortName.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getApiShortNameBytes() {
      java.lang.Object ref = apiShortName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiShortName_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used as a tracking tag when collecting data about the APIs developer
     * relations artifacts like docs, packages delivered to package managers,
     * etc.  Example: "speech".
     * </pre>
     *
     * <code>string api_short_name = 103;</code>
     *
     * @param value The apiShortName to set.
     * @return This builder for chaining.
     */
    public Builder setApiShortName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      apiShortName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used as a tracking tag when collecting data about the APIs developer
     * relations artifacts like docs, packages delivered to package managers,
     * etc.  Example: "speech".
     * </pre>
     *
     * <code>string api_short_name = 103;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiShortName() {
      apiShortName_ = getDefaultInstance().getApiShortName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used as a tracking tag when collecting data about the APIs developer
     * relations artifacts like docs, packages delivered to package managers,
     * etc.  Example: "speech".
     * </pre>
     *
     * <code>string api_short_name = 103;</code>
     *
     * @param value The bytes for apiShortName to set.
     * @return This builder for chaining.
     */
    public Builder setApiShortNameBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      apiShortName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object githubLabel_ = "";
    /**
     *
     *
     * <pre>
     * GitHub label to apply to issues and pull requests opened for this API.
     * </pre>
     *
     * <code>string github_label = 104;</code>
     *
     * @return The githubLabel.
     */
    public java.lang.String getGithubLabel() {
      java.lang.Object ref = githubLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        githubLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * GitHub label to apply to issues and pull requests opened for this API.
     * </pre>
     *
     * <code>string github_label = 104;</code>
     *
     * @return The bytes for githubLabel.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getGithubLabelBytes() {
      java.lang.Object ref = githubLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        githubLabel_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * GitHub label to apply to issues and pull requests opened for this API.
     * </pre>
     *
     * <code>string github_label = 104;</code>
     *
     * @param value The githubLabel to set.
     * @return This builder for chaining.
     */
    public Builder setGithubLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      githubLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub label to apply to issues and pull requests opened for this API.
     * </pre>
     *
     * <code>string github_label = 104;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGithubLabel() {
      githubLabel_ = getDefaultInstance().getGithubLabel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub label to apply to issues and pull requests opened for this API.
     * </pre>
     *
     * <code>string github_label = 104;</code>
     *
     * @param value The bytes for githubLabel to set.
     * @return This builder for chaining.
     */
    public Builder setGithubLabelBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      githubLabel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.LazyStringArrayList codeownerGithubTeams_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCodeownerGithubTeamsIsMutable() {
      if (!codeownerGithubTeams_.isModifiable()) {
        codeownerGithubTeams_ = new com.google.protobuf.LazyStringArrayList(codeownerGithubTeams_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @return A list containing the codeownerGithubTeams.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ProtocolStringList getCodeownerGithubTeamsList() {
      codeownerGithubTeams_.makeImmutable();
      return codeownerGithubTeams_;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @return The count of codeownerGithubTeams.
     */
    public int getCodeownerGithubTeamsCount() {
      return codeownerGithubTeams_.size();
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param index The index of the element to return.
     * @return The codeownerGithubTeams at the given index.
     */
    public java.lang.String getCodeownerGithubTeams(int index) {
      return codeownerGithubTeams_.get(index);
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the codeownerGithubTeams at the given index.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getCodeownerGithubTeamsBytes(int index) {
      return codeownerGithubTeams_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param index The index to set the value at.
     * @param value The codeownerGithubTeams to set.
     * @return This builder for chaining.
     */
    public Builder setCodeownerGithubTeams(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCodeownerGithubTeamsIsMutable();
      codeownerGithubTeams_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param value The codeownerGithubTeams to add.
     * @return This builder for chaining.
     */
    public Builder addCodeownerGithubTeams(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCodeownerGithubTeamsIsMutable();
      codeownerGithubTeams_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param values The codeownerGithubTeams to add.
     * @return This builder for chaining.
     */
    public Builder addAllCodeownerGithubTeams(java.lang.Iterable<java.lang.String> values) {
      ensureCodeownerGithubTeamsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, codeownerGithubTeams_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCodeownerGithubTeams() {
      codeownerGithubTeams_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHub teams to be added to CODEOWNERS in the directory in GitHub
     * containing source code for the client libraries for this API.
     * </pre>
     *
     * <code>repeated string codeowner_github_teams = 105;</code>
     *
     * @param value The bytes of the codeownerGithubTeams to add.
     * @return This builder for chaining.
     */
    public Builder addCodeownerGithubTeamsBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCodeownerGithubTeamsIsMutable();
      codeownerGithubTeams_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object docTagPrefix_ = "";
    /**
     *
     *
     * <pre>
     * A prefix used in sample code when demarking regions to be included in
     * documentation.
     * </pre>
     *
     * <code>string doc_tag_prefix = 106;</code>
     *
     * @return The docTagPrefix.
     */
    public java.lang.String getDocTagPrefix() {
      java.lang.Object ref = docTagPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        docTagPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A prefix used in sample code when demarking regions to be included in
     * documentation.
     * </pre>
     *
     * <code>string doc_tag_prefix = 106;</code>
     *
     * @return The bytes for docTagPrefix.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getDocTagPrefixBytes() {
      java.lang.Object ref = docTagPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        docTagPrefix_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A prefix used in sample code when demarking regions to be included in
     * documentation.
     * </pre>
     *
     * <code>string doc_tag_prefix = 106;</code>
     *
     * @param value The docTagPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setDocTagPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      docTagPrefix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A prefix used in sample code when demarking regions to be included in
     * documentation.
     * </pre>
     *
     * <code>string doc_tag_prefix = 106;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocTagPrefix() {
      docTagPrefix_ = getDefaultInstance().getDocTagPrefix();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A prefix used in sample code when demarking regions to be included in
     * documentation.
     * </pre>
     *
     * <code>string doc_tag_prefix = 106;</code>
     *
     * @param value The bytes for docTagPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setDocTagPrefixBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      docTagPrefix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int organization_ = 0;
    /**
     *
     *
     * <pre>
     * For whom the client library is being published.
     * </pre>
     *
     * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
     *
     * @return The enum numeric value on the wire for organization.
     */
    @java.lang.Override
    public int getOrganizationValue() {
      return organization_;
    }
    /**
     *
     *
     * <pre>
     * For whom the client library is being published.
     * </pre>
     *
     * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
     *
     * @param value The enum numeric value on the wire for organization to set.
     * @return This builder for chaining.
     */
    public Builder setOrganizationValue(int value) {
      organization_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For whom the client library is being published.
     * </pre>
     *
     * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
     *
     * @return The organization.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.ClientLibraryOrganization getOrganization() {
      com.google.api.ClientLibraryOrganization result =
          com.google.api.ClientLibraryOrganization.forNumber(organization_);
      return result == null ? com.google.api.ClientLibraryOrganization.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * For whom the client library is being published.
     * </pre>
     *
     * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
     *
     * @param value The organization to set.
     * @return This builder for chaining.
     */
    public Builder setOrganization(com.couchbase.client.core.deps.com.google.api.ClientLibraryOrganization value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      organization_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For whom the client library is being published.
     * </pre>
     *
     * <code>.google.api.ClientLibraryOrganization organization = 107;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrganization() {
      bitField0_ = (bitField0_ & ~0x00000080);
      organization_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings> librarySettings_ =
        java.util.Collections.emptyList();

    private void ensureLibrarySettingsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        librarySettings_ =
            new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings>(librarySettings_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.ClientLibrarySettings,
            com.google.api.ClientLibrarySettings.Builder,
            com.google.api.ClientLibrarySettingsOrBuilder>
        librarySettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings> getLibrarySettingsList() {
      if (librarySettingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(librarySettings_);
      } else {
        return librarySettingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public int getLibrarySettingsCount() {
      if (librarySettingsBuilder_ == null) {
        return librarySettings_.size();
      } else {
        return librarySettingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings getLibrarySettings(int index) {
      if (librarySettingsBuilder_ == null) {
        return librarySettings_.get(index);
      } else {
        return librarySettingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder setLibrarySettings(int index, com.google.api.ClientLibrarySettings value) {
      if (librarySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrarySettingsIsMutable();
        librarySettings_.set(index, value);
        onChanged();
      } else {
        librarySettingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder setLibrarySettings(
        int index, com.google.api.ClientLibrarySettings.Builder builderForValue) {
      if (librarySettingsBuilder_ == null) {
        ensureLibrarySettingsIsMutable();
        librarySettings_.set(index, builderForValue.build());
        onChanged();
      } else {
        librarySettingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder addLibrarySettings(com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings value) {
      if (librarySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrarySettingsIsMutable();
        librarySettings_.add(value);
        onChanged();
      } else {
        librarySettingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder addLibrarySettings(int index, com.google.api.ClientLibrarySettings value) {
      if (librarySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLibrarySettingsIsMutable();
        librarySettings_.add(index, value);
        onChanged();
      } else {
        librarySettingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder addLibrarySettings(
        com.google.api.ClientLibrarySettings.Builder builderForValue) {
      if (librarySettingsBuilder_ == null) {
        ensureLibrarySettingsIsMutable();
        librarySettings_.add(builderForValue.build());
        onChanged();
      } else {
        librarySettingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder addLibrarySettings(
        int index, com.google.api.ClientLibrarySettings.Builder builderForValue) {
      if (librarySettingsBuilder_ == null) {
        ensureLibrarySettingsIsMutable();
        librarySettings_.add(index, builderForValue.build());
        onChanged();
      } else {
        librarySettingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder addAllLibrarySettings(
        java.lang.Iterable<? extends com.google.api.ClientLibrarySettings> values) {
      if (librarySettingsBuilder_ == null) {
        ensureLibrarySettingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, librarySettings_);
        onChanged();
      } else {
        librarySettingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder clearLibrarySettings() {
      if (librarySettingsBuilder_ == null) {
        librarySettings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        librarySettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public Builder removeLibrarySettings(int index) {
      if (librarySettingsBuilder_ == null) {
        ensureLibrarySettingsIsMutable();
        librarySettings_.remove(index);
        onChanged();
      } else {
        librarySettingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings.Builder getLibrarySettingsBuilder(int index) {
      return getLibrarySettingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettingsOrBuilder getLibrarySettingsOrBuilder(int index) {
      if (librarySettingsBuilder_ == null) {
        return librarySettings_.get(index);
      } else {
        return librarySettingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public java.util.List<? extends com.google.api.ClientLibrarySettingsOrBuilder>
        getLibrarySettingsOrBuilderList() {
      if (librarySettingsBuilder_ != null) {
        return librarySettingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(librarySettings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings.Builder addLibrarySettingsBuilder() {
      return getLibrarySettingsFieldBuilder()
          .addBuilder(com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings.Builder addLibrarySettingsBuilder(int index) {
      return getLibrarySettingsFieldBuilder()
          .addBuilder(index, com.google.api.ClientLibrarySettings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Client library settings.  If the same version string appears multiple
     * times in this list, then the last one wins.  Settings from earlier
     * settings with the same version string are discarded.
     * </pre>
     *
     * <code>repeated .google.api.ClientLibrarySettings library_settings = 109;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.ClientLibrarySettings.Builder>
        getLibrarySettingsBuilderList() {
      return getLibrarySettingsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.ClientLibrarySettings,
            com.google.api.ClientLibrarySettings.Builder,
            com.google.api.ClientLibrarySettingsOrBuilder>
        getLibrarySettingsFieldBuilder() {
      if (librarySettingsBuilder_ == null) {
        librarySettingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.ClientLibrarySettings,
                com.google.api.ClientLibrarySettings.Builder,
                com.google.api.ClientLibrarySettingsOrBuilder>(
                librarySettings_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        librarySettings_ = null;
      }
      return librarySettingsBuilder_;
    }

    private java.lang.Object protoReferenceDocumentationUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional link to proto reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rpc
     * </pre>
     *
     * <code>string proto_reference_documentation_uri = 110;</code>
     *
     * @return The protoReferenceDocumentationUri.
     */
    public java.lang.String getProtoReferenceDocumentationUri() {
      java.lang.Object ref = protoReferenceDocumentationUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protoReferenceDocumentationUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional link to proto reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rpc
     * </pre>
     *
     * <code>string proto_reference_documentation_uri = 110;</code>
     *
     * @return The bytes for protoReferenceDocumentationUri.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getProtoReferenceDocumentationUriBytes() {
      java.lang.Object ref = protoReferenceDocumentationUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protoReferenceDocumentationUri_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional link to proto reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rpc
     * </pre>
     *
     * <code>string proto_reference_documentation_uri = 110;</code>
     *
     * @param value The protoReferenceDocumentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setProtoReferenceDocumentationUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protoReferenceDocumentationUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional link to proto reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rpc
     * </pre>
     *
     * <code>string proto_reference_documentation_uri = 110;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtoReferenceDocumentationUri() {
      protoReferenceDocumentationUri_ = getDefaultInstance().getProtoReferenceDocumentationUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional link to proto reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rpc
     * </pre>
     *
     * <code>string proto_reference_documentation_uri = 110;</code>
     *
     * @param value The bytes for protoReferenceDocumentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setProtoReferenceDocumentationUriBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protoReferenceDocumentationUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object restReferenceDocumentationUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional link to REST reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rest
     * </pre>
     *
     * <code>string rest_reference_documentation_uri = 111;</code>
     *
     * @return The restReferenceDocumentationUri.
     */
    public java.lang.String getRestReferenceDocumentationUri() {
      java.lang.Object ref = restReferenceDocumentationUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        restReferenceDocumentationUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional link to REST reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rest
     * </pre>
     *
     * <code>string rest_reference_documentation_uri = 111;</code>
     *
     * @return The bytes for restReferenceDocumentationUri.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getRestReferenceDocumentationUriBytes() {
      java.lang.Object ref = restReferenceDocumentationUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        restReferenceDocumentationUri_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional link to REST reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rest
     * </pre>
     *
     * <code>string rest_reference_documentation_uri = 111;</code>
     *
     * @param value The restReferenceDocumentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setRestReferenceDocumentationUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      restReferenceDocumentationUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional link to REST reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rest
     * </pre>
     *
     * <code>string rest_reference_documentation_uri = 111;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestReferenceDocumentationUri() {
      restReferenceDocumentationUri_ = getDefaultInstance().getRestReferenceDocumentationUri();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional link to REST reference documentation.  Example:
     * https://cloud.google.com/pubsub/lite/docs/reference/rest
     * </pre>
     *
     * <code>string rest_reference_documentation_uri = 111;</code>
     *
     * @param value The bytes for restReferenceDocumentationUri to set.
     * @return This builder for chaining.
     */
    public Builder setRestReferenceDocumentationUriBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      restReferenceDocumentationUri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Publishing)
  }

  // @@protoc_insertion_point(class_scope:google.api.Publishing)
  private static final com.couchbase.client.core.deps.com.google.api.Publishing DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Publishing();
  }

  public static com.couchbase.client.core.deps.com.google.api.Publishing getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<Publishing> PARSER =
      new com.google.protobuf.AbstractParser<Publishing>() {
        @java.lang.Override
        public Publishing parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.couchbase.client.core.deps.com.google.protobuf.Parser<Publishing> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Parser<Publishing> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Publishing getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
