/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/service.proto

// Protobuf Java Version: 3.25.3
package com.couchbase.client.core.deps.com.google.api;

/**
 *
 *
 * <pre>
 * `Service` is the root object of Google API service configuration (service
 * config). It describes the basic information about a logical service,
 * such as the service name and the user-facing title, and delegates other
 * aspects to sub-sections. Each sub-section is either a proto message or a
 * repeated proto message that configures a specific aspect, such as auth.
 * For more information, see each proto message definition.
 *
 * Example:
 *
 *     type: google.api.Service
 *     name: calendar.googleapis.com
 *     title: Google Calendar API
 *     apis:
 *     - name: google.calendar.v3.Calendar
 *
 *     visibility:
 *       rules:
 *       - selector: "google.calendar.v3.*"
 *         restriction: PREVIEW
 *     backend:
 *       rules:
 *       - selector: "google.calendar.v3.*"
 *         address: calendar.example.com
 *
 *     authentication:
 *       providers:
 *       - id: google_calendar_auth
 *         jwks_uri: https://www.googleapis.com/oauth2/v1/certs
 *         issuer: https://securetoken.google.com
 *       rules:
 *       - selector: "*"
 *         requirements:
 *           provider_id: google_calendar_auth
 * </pre>
 *
 * Protobuf type {@code google.api.Service}
 */
public final class Service extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Service)
    ServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Service.newBuilder() to construct.
  private Service(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Service() {
    name_ = "";
    title_ = "";
    producerProjectId_ = "";
    id_ = "";
    apis_ = java.util.Collections.emptyList();
    types_ = java.util.Collections.emptyList();
    enums_ = java.util.Collections.emptyList();
    endpoints_ = java.util.Collections.emptyList();
    logs_ = java.util.Collections.emptyList();
    metrics_ = java.util.Collections.emptyList();
    monitoredResources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Service();
  }

  public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.ServiceProto.internal_static_google_api_Service_descriptor;
  }

  @java.lang.Override
  protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ServiceProto.internal_static_google_api_Service_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Service.class, com.google.api.Service.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The service name, which is a DNS-like logical identifier for the
   * service, such as `calendar.googleapis.com`. The service name
   * typically goes through DNS verification to make sure the owner
   * of the service also owns the DNS name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service name, which is a DNS-like logical identifier for the
   * service, such as `calendar.googleapis.com`. The service name
   * typically goes through DNS verification to make sure the owner
   * of the service also owns the DNS name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   *
   *
   * <pre>
   * The product title for this service, it is the name displayed in Google
   * Cloud Console.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The product title for this service, it is the name displayed in Google
   * Cloud Console.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCER_PROJECT_ID_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object producerProjectId_ = "";
  /**
   *
   *
   * <pre>
   * The Google project that owns this service.
   * </pre>
   *
   * <code>string producer_project_id = 22;</code>
   *
   * @return The producerProjectId.
   */
  @java.lang.Override
  public java.lang.String getProducerProjectId() {
    java.lang.Object ref = producerProjectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      producerProjectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google project that owns this service.
   * </pre>
   *
   * <code>string producer_project_id = 22;</code>
   *
   * @return The bytes for producerProjectId.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getProducerProjectIdBytes() {
    java.lang.Object ref = producerProjectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      producerProjectId_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * A unique ID for a specific instance of this message, typically assigned
   * by the client for tracking purpose. Must be no longer than 63 characters
   * and only lower case letters, digits, '.', '_' and '-' are allowed. If
   * empty, the server may choose to generate one instead.
   * </pre>
   *
   * <code>string id = 33;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique ID for a specific instance of this message, typically assigned
   * by the client for tracking purpose. Must be no longer than 63 characters
   * and only lower case letters, digits, '.', '_' and '-' are allowed. If
   * empty, the server may choose to generate one instead.
   * </pre>
   *
   * <code>string id = 33;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APIS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Api> apis_;
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Only the `name` field
   * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
   * the configuration author, as the remaining fields will be derived from the
   * IDL during the normalization process. It is an error to specify an API
   * interface here which cannot be resolved against the associated IDL files.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Api> getApisList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Only the `name` field
   * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
   * the configuration author, as the remaining fields will be derived from the
   * IDL during the normalization process. It is an error to specify an API
   * interface here which cannot be resolved against the associated IDL files.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ApiOrBuilder> getApisOrBuilderList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Only the `name` field
   * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
   * the configuration author, as the remaining fields will be derived from the
   * IDL during the normalization process. It is an error to specify an API
   * interface here which cannot be resolved against the associated IDL files.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public int getApisCount() {
    return apis_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Only the `name` field
   * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
   * the configuration author, as the remaining fields will be derived from the
   * IDL during the normalization process. It is an error to specify an API
   * interface here which cannot be resolved against the associated IDL files.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Api getApis(int index) {
    return apis_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Only the `name` field
   * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
   * the configuration author, as the remaining fields will be derived from the
   * IDL during the normalization process. It is an error to specify an API
   * interface here which cannot be resolved against the associated IDL files.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.ApiOrBuilder getApisOrBuilder(int index) {
    return apis_.get(index);
  }

  public static final int TYPES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Type> types_;
  /**
   *
   *
   * <pre>
   * A list of all proto message types included in this API service.
   * Types referenced directly or indirectly by the `apis` are automatically
   * included.  Messages which are not referenced but shall be included, such as
   * types used by the `google.protobuf.Any` type, should be listed here by
   * name by the configuration author. Example:
   *
   *     types:
   *     - name: google.protobuf.Int32
   * </pre>
   *
   * <code>repeated .google.protobuf.Type types = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Type> getTypesList() {
    return types_;
  }
  /**
   *
   *
   * <pre>
   * A list of all proto message types included in this API service.
   * Types referenced directly or indirectly by the `apis` are automatically
   * included.  Messages which are not referenced but shall be included, such as
   * types used by the `google.protobuf.Any` type, should be listed here by
   * name by the configuration author. Example:
   *
   *     types:
   *     - name: google.protobuf.Int32
   * </pre>
   *
   * <code>repeated .google.protobuf.Type types = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.TypeOrBuilder> getTypesOrBuilderList() {
    return types_;
  }
  /**
   *
   *
   * <pre>
   * A list of all proto message types included in this API service.
   * Types referenced directly or indirectly by the `apis` are automatically
   * included.  Messages which are not referenced but shall be included, such as
   * types used by the `google.protobuf.Any` type, should be listed here by
   * name by the configuration author. Example:
   *
   *     types:
   *     - name: google.protobuf.Int32
   * </pre>
   *
   * <code>repeated .google.protobuf.Type types = 4;</code>
   */
  @java.lang.Override
  public int getTypesCount() {
    return types_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of all proto message types included in this API service.
   * Types referenced directly or indirectly by the `apis` are automatically
   * included.  Messages which are not referenced but shall be included, such as
   * types used by the `google.protobuf.Any` type, should be listed here by
   * name by the configuration author. Example:
   *
   *     types:
   *     - name: google.protobuf.Int32
   * </pre>
   *
   * <code>repeated .google.protobuf.Type types = 4;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Type getTypes(int index) {
    return types_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of all proto message types included in this API service.
   * Types referenced directly or indirectly by the `apis` are automatically
   * included.  Messages which are not referenced but shall be included, such as
   * types used by the `google.protobuf.Any` type, should be listed here by
   * name by the configuration author. Example:
   *
   *     types:
   *     - name: google.protobuf.Int32
   * </pre>
   *
   * <code>repeated .google.protobuf.Type types = 4;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.TypeOrBuilder getTypesOrBuilder(int index) {
    return types_.get(index);
  }

  public static final int ENUMS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Enum> enums_;
  /**
   *
   *
   * <pre>
   * A list of all enum types included in this API service.  Enums referenced
   * directly or indirectly by the `apis` are automatically included.  Enums
   * which are not referenced but shall be included should be listed here by
   * name by the configuration author. Example:
   *
   *     enums:
   *     - name: google.someapi.v1.SomeEnum
   * </pre>
   *
   * <code>repeated .google.protobuf.Enum enums = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Enum> getEnumsList() {
    return enums_;
  }
  /**
   *
   *
   * <pre>
   * A list of all enum types included in this API service.  Enums referenced
   * directly or indirectly by the `apis` are automatically included.  Enums
   * which are not referenced but shall be included should be listed here by
   * name by the configuration author. Example:
   *
   *     enums:
   *     - name: google.someapi.v1.SomeEnum
   * </pre>
   *
   * <code>repeated .google.protobuf.Enum enums = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.EnumOrBuilder> getEnumsOrBuilderList() {
    return enums_;
  }
  /**
   *
   *
   * <pre>
   * A list of all enum types included in this API service.  Enums referenced
   * directly or indirectly by the `apis` are automatically included.  Enums
   * which are not referenced but shall be included should be listed here by
   * name by the configuration author. Example:
   *
   *     enums:
   *     - name: google.someapi.v1.SomeEnum
   * </pre>
   *
   * <code>repeated .google.protobuf.Enum enums = 5;</code>
   */
  @java.lang.Override
  public int getEnumsCount() {
    return enums_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of all enum types included in this API service.  Enums referenced
   * directly or indirectly by the `apis` are automatically included.  Enums
   * which are not referenced but shall be included should be listed here by
   * name by the configuration author. Example:
   *
   *     enums:
   *     - name: google.someapi.v1.SomeEnum
   * </pre>
   *
   * <code>repeated .google.protobuf.Enum enums = 5;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Enum getEnums(int index) {
    return enums_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of all enum types included in this API service.  Enums referenced
   * directly or indirectly by the `apis` are automatically included.  Enums
   * which are not referenced but shall be included should be listed here by
   * name by the configuration author. Example:
   *
   *     enums:
   *     - name: google.someapi.v1.SomeEnum
   * </pre>
   *
   * <code>repeated .google.protobuf.Enum enums = 5;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.EnumOrBuilder getEnumsOrBuilder(int index) {
    return enums_.get(index);
  }

  public static final int DOCUMENTATION_FIELD_NUMBER = 6;
  private com.couchbase.client.core.deps.com.google.api.Documentation documentation_;
  /**
   *
   *
   * <pre>
   * Additional API documentation.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   *
   * @return Whether the documentation field is set.
   */
  @java.lang.Override
  public boolean hasDocumentation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional API documentation.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   *
   * @return The documentation.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Documentation getDocumentation() {
    return documentation_ == null
        ? com.google.api.Documentation.getDefaultInstance()
        : documentation_;
  }
  /**
   *
   *
   * <pre>
   * Additional API documentation.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.DocumentationOrBuilder getDocumentationOrBuilder() {
    return documentation_ == null
        ? com.google.api.Documentation.getDefaultInstance()
        : documentation_;
  }

  public static final int BACKEND_FIELD_NUMBER = 8;
  private com.couchbase.client.core.deps.com.google.api.Backend backend_;
  /**
   *
   *
   * <pre>
   * API backend configuration.
   * </pre>
   *
   * <code>.google.api.Backend backend = 8;</code>
   *
   * @return Whether the backend field is set.
   */
  @java.lang.Override
  public boolean hasBackend() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * API backend configuration.
   * </pre>
   *
   * <code>.google.api.Backend backend = 8;</code>
   *
   * @return The backend.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Backend getBackend() {
    return backend_ == null ? com.google.api.Backend.getDefaultInstance() : backend_;
  }
  /**
   *
   *
   * <pre>
   * API backend configuration.
   * </pre>
   *
   * <code>.google.api.Backend backend = 8;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.BackendOrBuilder getBackendOrBuilder() {
    return backend_ == null ? com.google.api.Backend.getDefaultInstance() : backend_;
  }

  public static final int HTTP_FIELD_NUMBER = 9;
  private com.couchbase.client.core.deps.com.google.api.Http http_;
  /**
   *
   *
   * <pre>
   * HTTP configuration.
   * </pre>
   *
   * <code>.google.api.Http http = 9;</code>
   *
   * @return Whether the http field is set.
   */
  @java.lang.Override
  public boolean hasHttp() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * HTTP configuration.
   * </pre>
   *
   * <code>.google.api.Http http = 9;</code>
   *
   * @return The http.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Http getHttp() {
    return http_ == null ? com.google.api.Http.getDefaultInstance() : http_;
  }
  /**
   *
   *
   * <pre>
   * HTTP configuration.
   * </pre>
   *
   * <code>.google.api.Http http = 9;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.HttpOrBuilder getHttpOrBuilder() {
    return http_ == null ? com.google.api.Http.getDefaultInstance() : http_;
  }

  public static final int QUOTA_FIELD_NUMBER = 10;
  private com.couchbase.client.core.deps.com.google.api.Quota quota_;
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   *
   * @return Whether the quota field is set.
   */
  @java.lang.Override
  public boolean hasQuota() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   *
   * @return The quota.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Quota getQuota() {
    return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
  }
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.QuotaOrBuilder getQuotaOrBuilder() {
    return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
  }

  public static final int AUTHENTICATION_FIELD_NUMBER = 11;
  private com.couchbase.client.core.deps.com.google.api.Authentication authentication_;
  /**
   *
   *
   * <pre>
   * Auth configuration.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   *
   * @return Whether the authentication field is set.
   */
  @java.lang.Override
  public boolean hasAuthentication() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Auth configuration.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   *
   * @return The authentication.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Authentication getAuthentication() {
    return authentication_ == null
        ? com.google.api.Authentication.getDefaultInstance()
        : authentication_;
  }
  /**
   *
   *
   * <pre>
   * Auth configuration.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.AuthenticationOrBuilder getAuthenticationOrBuilder() {
    return authentication_ == null
        ? com.google.api.Authentication.getDefaultInstance()
        : authentication_;
  }

  public static final int CONTEXT_FIELD_NUMBER = 12;
  private com.couchbase.client.core.deps.com.google.api.Context context_;
  /**
   *
   *
   * <pre>
   * Context configuration.
   * </pre>
   *
   * <code>.google.api.Context context = 12;</code>
   *
   * @return Whether the context field is set.
   */
  @java.lang.Override
  public boolean hasContext() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Context configuration.
   * </pre>
   *
   * <code>.google.api.Context context = 12;</code>
   *
   * @return The context.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Context getContext() {
    return context_ == null ? com.google.api.Context.getDefaultInstance() : context_;
  }
  /**
   *
   *
   * <pre>
   * Context configuration.
   * </pre>
   *
   * <code>.google.api.Context context = 12;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.ContextOrBuilder getContextOrBuilder() {
    return context_ == null ? com.google.api.Context.getDefaultInstance() : context_;
  }

  public static final int USAGE_FIELD_NUMBER = 15;
  private com.couchbase.client.core.deps.com.google.api.Usage usage_;
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   *
   * @return Whether the usage field is set.
   */
  @java.lang.Override
  public boolean hasUsage() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   *
   * @return The usage.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Usage getUsage() {
    return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.UsageOrBuilder getUsageOrBuilder() {
    return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
  }

  public static final int ENDPOINTS_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.Endpoint> endpoints_;
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints.  If this is empty, then an endpoint
   * with the same name as the service is automatically generated to service all
   * defined APIs.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.Endpoint> getEndpointsList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints.  If this is empty, then an endpoint
   * with the same name as the service is automatically generated to service all
   * defined APIs.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.EndpointOrBuilder> getEndpointsOrBuilderList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints.  If this is empty, then an endpoint
   * with the same name as the service is automatically generated to service all
   * defined APIs.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public int getEndpointsCount() {
    return endpoints_.size();
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints.  If this is empty, then an endpoint
   * with the same name as the service is automatically generated to service all
   * defined APIs.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Endpoint getEndpoints(int index) {
    return endpoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints.  If this is empty, then an endpoint
   * with the same name as the service is automatically generated to service all
   * defined APIs.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.EndpointOrBuilder getEndpointsOrBuilder(int index) {
    return endpoints_.get(index);
  }

  public static final int CONTROL_FIELD_NUMBER = 21;
  private com.couchbase.client.core.deps.com.google.api.Control control_;
  /**
   *
   *
   * <pre>
   * Configuration for the service control plane.
   * </pre>
   *
   * <code>.google.api.Control control = 21;</code>
   *
   * @return Whether the control field is set.
   */
  @java.lang.Override
  public boolean hasControl() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the service control plane.
   * </pre>
   *
   * <code>.google.api.Control control = 21;</code>
   *
   * @return The control.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Control getControl() {
    return control_ == null ? com.google.api.Control.getDefaultInstance() : control_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the service control plane.
   * </pre>
   *
   * <code>.google.api.Control control = 21;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.ControlOrBuilder getControlOrBuilder() {
    return control_ == null ? com.google.api.Control.getDefaultInstance() : control_;
  }

  public static final int LOGS_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.LogDescriptor> logs_;
  /**
   *
   *
   * <pre>
   * Defines the logs used by this service.
   * </pre>
   *
   * <code>repeated .google.api.LogDescriptor logs = 23;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.LogDescriptor> getLogsList() {
    return logs_;
  }
  /**
   *
   *
   * <pre>
   * Defines the logs used by this service.
   * </pre>
   *
   * <code>repeated .google.api.LogDescriptor logs = 23;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.LogDescriptorOrBuilder> getLogsOrBuilderList() {
    return logs_;
  }
  /**
   *
   *
   * <pre>
   * Defines the logs used by this service.
   * </pre>
   *
   * <code>repeated .google.api.LogDescriptor logs = 23;</code>
   */
  @java.lang.Override
  public int getLogsCount() {
    return logs_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the logs used by this service.
   * </pre>
   *
   * <code>repeated .google.api.LogDescriptor logs = 23;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LogDescriptor getLogs(int index) {
    return logs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the logs used by this service.
   * </pre>
   *
   * <code>repeated .google.api.LogDescriptor logs = 23;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LogDescriptorOrBuilder getLogsOrBuilder(int index) {
    return logs_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.MetricDescriptor> metrics_;
  /**
   *
   *
   * <pre>
   * Defines the metrics used by this service.
   * </pre>
   *
   * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.MetricDescriptor> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Defines the metrics used by this service.
   * </pre>
   *
   * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.MetricDescriptorOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Defines the metrics used by this service.
   * </pre>
   *
   * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the metrics used by this service.
   * </pre>
   *
   * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptor getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the metrics used by this service.
   * </pre>
   *
   * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MetricDescriptorOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int MONITORED_RESOURCES_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private java.util.List<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor> monitoredResources_;
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and
   * [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public java.util.List<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor> getMonitoredResourcesList() {
    return monitoredResources_;
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and
   * [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.MonitoredResourceDescriptorOrBuilder>
      getMonitoredResourcesOrBuilderList() {
    return monitoredResources_;
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and
   * [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public int getMonitoredResourcesCount() {
    return monitoredResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and
   * [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor getMonitoredResources(int index) {
    return monitoredResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and
   * [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptorOrBuilder getMonitoredResourcesOrBuilder(
      int index) {
    return monitoredResources_.get(index);
  }

  public static final int BILLING_FIELD_NUMBER = 26;
  private com.couchbase.client.core.deps.com.google.api.Billing billing_;
  /**
   *
   *
   * <pre>
   * Billing configuration.
   * </pre>
   *
   * <code>.google.api.Billing billing = 26;</code>
   *
   * @return Whether the billing field is set.
   */
  @java.lang.Override
  public boolean hasBilling() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Billing configuration.
   * </pre>
   *
   * <code>.google.api.Billing billing = 26;</code>
   *
   * @return The billing.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Billing getBilling() {
    return billing_ == null ? com.google.api.Billing.getDefaultInstance() : billing_;
  }
  /**
   *
   *
   * <pre>
   * Billing configuration.
   * </pre>
   *
   * <code>.google.api.Billing billing = 26;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.BillingOrBuilder getBillingOrBuilder() {
    return billing_ == null ? com.google.api.Billing.getDefaultInstance() : billing_;
  }

  public static final int LOGGING_FIELD_NUMBER = 27;
  private com.couchbase.client.core.deps.com.google.api.Logging logging_;
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.api.Logging logging = 27;</code>
   *
   * @return Whether the logging field is set.
   */
  @java.lang.Override
  public boolean hasLogging() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.api.Logging logging = 27;</code>
   *
   * @return The logging.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Logging getLogging() {
    return logging_ == null ? com.google.api.Logging.getDefaultInstance() : logging_;
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.api.Logging logging = 27;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.LoggingOrBuilder getLoggingOrBuilder() {
    return logging_ == null ? com.google.api.Logging.getDefaultInstance() : logging_;
  }

  public static final int MONITORING_FIELD_NUMBER = 28;
  private com.couchbase.client.core.deps.com.google.api.Monitoring monitoring_;
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   *
   * @return Whether the monitoring field is set.
   */
  @java.lang.Override
  public boolean hasMonitoring() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   *
   * @return The monitoring.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Monitoring getMonitoring() {
    return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.MonitoringOrBuilder getMonitoringOrBuilder() {
    return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
  }

  public static final int SYSTEM_PARAMETERS_FIELD_NUMBER = 29;
  private com.couchbase.client.core.deps.com.google.api.SystemParameters systemParameters_;
  /**
   *
   *
   * <pre>
   * System parameter configuration.
   * </pre>
   *
   * <code>.google.api.SystemParameters system_parameters = 29;</code>
   *
   * @return Whether the systemParameters field is set.
   */
  @java.lang.Override
  public boolean hasSystemParameters() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * System parameter configuration.
   * </pre>
   *
   * <code>.google.api.SystemParameters system_parameters = 29;</code>
   *
   * @return The systemParameters.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.SystemParameters getSystemParameters() {
    return systemParameters_ == null
        ? com.google.api.SystemParameters.getDefaultInstance()
        : systemParameters_;
  }
  /**
   *
   *
   * <pre>
   * System parameter configuration.
   * </pre>
   *
   * <code>.google.api.SystemParameters system_parameters = 29;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.SystemParametersOrBuilder getSystemParametersOrBuilder() {
    return systemParameters_ == null
        ? com.google.api.SystemParameters.getDefaultInstance()
        : systemParameters_;
  }

  public static final int SOURCE_INFO_FIELD_NUMBER = 37;
  private com.couchbase.client.core.deps.com.google.api.SourceInfo sourceInfo_;
  /**
   *
   *
   * <pre>
   * Output only. The source information for this configuration if available.
   * </pre>
   *
   * <code>.google.api.SourceInfo source_info = 37;</code>
   *
   * @return Whether the sourceInfo field is set.
   */
  @java.lang.Override
  public boolean hasSourceInfo() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The source information for this configuration if available.
   * </pre>
   *
   * <code>.google.api.SourceInfo source_info = 37;</code>
   *
   * @return The sourceInfo.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.SourceInfo getSourceInfo() {
    return sourceInfo_ == null ? com.google.api.SourceInfo.getDefaultInstance() : sourceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source information for this configuration if available.
   * </pre>
   *
   * <code>.google.api.SourceInfo source_info = 37;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.SourceInfoOrBuilder getSourceInfoOrBuilder() {
    return sourceInfo_ == null ? com.google.api.SourceInfo.getDefaultInstance() : sourceInfo_;
  }

  public static final int PUBLISHING_FIELD_NUMBER = 45;
  private com.couchbase.client.core.deps.com.google.api.Publishing publishing_;
  /**
   *
   *
   * <pre>
   * Settings for [Google Cloud Client
   * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
   * generated from APIs defined as protocol buffers.
   * </pre>
   *
   * <code>.google.api.Publishing publishing = 45;</code>
   *
   * @return Whether the publishing field is set.
   */
  @java.lang.Override
  public boolean hasPublishing() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings for [Google Cloud Client
   * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
   * generated from APIs defined as protocol buffers.
   * </pre>
   *
   * <code>.google.api.Publishing publishing = 45;</code>
   *
   * @return The publishing.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Publishing getPublishing() {
    return publishing_ == null ? com.google.api.Publishing.getDefaultInstance() : publishing_;
  }
  /**
   *
   *
   * <pre>
   * Settings for [Google Cloud Client
   * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
   * generated from APIs defined as protocol buffers.
   * </pre>
   *
   * <code>.google.api.Publishing publishing = 45;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.PublishingOrBuilder getPublishingOrBuilder() {
    return publishing_ == null ? com.google.api.Publishing.getDefaultInstance() : publishing_;
  }

  public static final int CONFIG_VERSION_FIELD_NUMBER = 20;
  private com.couchbase.client.core.deps.com.google.protobuf.UInt32Value configVersion_;
  /**
   *
   *
   * <pre>
   * Obsolete. Do not use.
   *
   * This field has no semantic meaning. The service config compiler always
   * sets this field to `3`.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value config_version = 20;</code>
   *
   * @return Whether the configVersion field is set.
   */
  @java.lang.Override
  public boolean hasConfigVersion() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Obsolete. Do not use.
   *
   * This field has no semantic meaning. The service config compiler always
   * sets this field to `3`.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value config_version = 20;</code>
   *
   * @return The configVersion.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.UInt32Value getConfigVersion() {
    return configVersion_ == null
        ? com.google.protobuf.UInt32Value.getDefaultInstance()
        : configVersion_;
  }
  /**
   *
   *
   * <pre>
   * Obsolete. Do not use.
   *
   * This field has no semantic meaning. The service config compiler always
   * sets this field to `3`.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value config_version = 20;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.UInt32ValueOrBuilder getConfigVersionOrBuilder() {
    return configVersion_ == null
        ? com.google.protobuf.UInt32Value.getDefaultInstance()
        : configVersion_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
    }
    for (int i = 0; i < apis_.size(); i++) {
      output.writeMessage(3, apis_.get(i));
    }
    for (int i = 0; i < types_.size(); i++) {
      output.writeMessage(4, types_.get(i));
    }
    for (int i = 0; i < enums_.size(); i++) {
      output.writeMessage(5, enums_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getDocumentation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getBackend());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getHttp());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getQuota());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getAuthentication());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(12, getContext());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(15, getUsage());
    }
    for (int i = 0; i < endpoints_.size(); i++) {
      output.writeMessage(18, endpoints_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(20, getConfigVersion());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(21, getControl());
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(producerProjectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, producerProjectId_);
    }
    for (int i = 0; i < logs_.size(); i++) {
      output.writeMessage(23, logs_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(24, metrics_.get(i));
    }
    for (int i = 0; i < monitoredResources_.size(); i++) {
      output.writeMessage(25, monitoredResources_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(26, getBilling());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(27, getLogging());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(28, getMonitoring());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(29, getSystemParameters());
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 33, id_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(37, getSourceInfo());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(45, getPublishing());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
    }
    for (int i = 0; i < apis_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, apis_.get(i));
    }
    for (int i = 0; i < types_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, types_.get(i));
    }
    for (int i = 0; i < enums_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, enums_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDocumentation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getBackend());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getHttp());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getQuota());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getAuthentication());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getContext());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getUsage());
    }
    for (int i = 0; i < endpoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, endpoints_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getConfigVersion());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getControl());
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(producerProjectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, producerProjectId_);
    }
    for (int i = 0; i < logs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, logs_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, metrics_.get(i));
    }
    for (int i = 0; i < monitoredResources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(25, monitoredResources_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getBilling());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getLogging());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getMonitoring());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getSystemParameters());
    }
    if (!com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(33, id_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, getSourceInfo());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(45, getPublishing());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Service)) {
      return super.equals(obj);
    }
    com.google.api.Service other = (com.couchbase.client.core.deps.com.google.api.Service) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getProducerProjectId().equals(other.getProducerProjectId())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getApisList().equals(other.getApisList())) return false;
    if (!getTypesList().equals(other.getTypesList())) return false;
    if (!getEnumsList().equals(other.getEnumsList())) return false;
    if (hasDocumentation() != other.hasDocumentation()) return false;
    if (hasDocumentation()) {
      if (!getDocumentation().equals(other.getDocumentation())) return false;
    }
    if (hasBackend() != other.hasBackend()) return false;
    if (hasBackend()) {
      if (!getBackend().equals(other.getBackend())) return false;
    }
    if (hasHttp() != other.hasHttp()) return false;
    if (hasHttp()) {
      if (!getHttp().equals(other.getHttp())) return false;
    }
    if (hasQuota() != other.hasQuota()) return false;
    if (hasQuota()) {
      if (!getQuota().equals(other.getQuota())) return false;
    }
    if (hasAuthentication() != other.hasAuthentication()) return false;
    if (hasAuthentication()) {
      if (!getAuthentication().equals(other.getAuthentication())) return false;
    }
    if (hasContext() != other.hasContext()) return false;
    if (hasContext()) {
      if (!getContext().equals(other.getContext())) return false;
    }
    if (hasUsage() != other.hasUsage()) return false;
    if (hasUsage()) {
      if (!getUsage().equals(other.getUsage())) return false;
    }
    if (!getEndpointsList().equals(other.getEndpointsList())) return false;
    if (hasControl() != other.hasControl()) return false;
    if (hasControl()) {
      if (!getControl().equals(other.getControl())) return false;
    }
    if (!getLogsList().equals(other.getLogsList())) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getMonitoredResourcesList().equals(other.getMonitoredResourcesList())) return false;
    if (hasBilling() != other.hasBilling()) return false;
    if (hasBilling()) {
      if (!getBilling().equals(other.getBilling())) return false;
    }
    if (hasLogging() != other.hasLogging()) return false;
    if (hasLogging()) {
      if (!getLogging().equals(other.getLogging())) return false;
    }
    if (hasMonitoring() != other.hasMonitoring()) return false;
    if (hasMonitoring()) {
      if (!getMonitoring().equals(other.getMonitoring())) return false;
    }
    if (hasSystemParameters() != other.hasSystemParameters()) return false;
    if (hasSystemParameters()) {
      if (!getSystemParameters().equals(other.getSystemParameters())) return false;
    }
    if (hasSourceInfo() != other.hasSourceInfo()) return false;
    if (hasSourceInfo()) {
      if (!getSourceInfo().equals(other.getSourceInfo())) return false;
    }
    if (hasPublishing() != other.hasPublishing()) return false;
    if (hasPublishing()) {
      if (!getPublishing().equals(other.getPublishing())) return false;
    }
    if (hasConfigVersion() != other.hasConfigVersion()) return false;
    if (hasConfigVersion()) {
      if (!getConfigVersion().equals(other.getConfigVersion())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + PRODUCER_PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProducerProjectId().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getApisCount() > 0) {
      hash = (37 * hash) + APIS_FIELD_NUMBER;
      hash = (53 * hash) + getApisList().hashCode();
    }
    if (getTypesCount() > 0) {
      hash = (37 * hash) + TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getTypesList().hashCode();
    }
    if (getEnumsCount() > 0) {
      hash = (37 * hash) + ENUMS_FIELD_NUMBER;
      hash = (53 * hash) + getEnumsList().hashCode();
    }
    if (hasDocumentation()) {
      hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentation().hashCode();
    }
    if (hasBackend()) {
      hash = (37 * hash) + BACKEND_FIELD_NUMBER;
      hash = (53 * hash) + getBackend().hashCode();
    }
    if (hasHttp()) {
      hash = (37 * hash) + HTTP_FIELD_NUMBER;
      hash = (53 * hash) + getHttp().hashCode();
    }
    if (hasQuota()) {
      hash = (37 * hash) + QUOTA_FIELD_NUMBER;
      hash = (53 * hash) + getQuota().hashCode();
    }
    if (hasAuthentication()) {
      hash = (37 * hash) + AUTHENTICATION_FIELD_NUMBER;
      hash = (53 * hash) + getAuthentication().hashCode();
    }
    if (hasContext()) {
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
    }
    if (hasUsage()) {
      hash = (37 * hash) + USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getUsage().hashCode();
    }
    if (getEndpointsCount() > 0) {
      hash = (37 * hash) + ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointsList().hashCode();
    }
    if (hasControl()) {
      hash = (37 * hash) + CONTROL_FIELD_NUMBER;
      hash = (53 * hash) + getControl().hashCode();
    }
    if (getLogsCount() > 0) {
      hash = (37 * hash) + LOGS_FIELD_NUMBER;
      hash = (53 * hash) + getLogsList().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (getMonitoredResourcesCount() > 0) {
      hash = (37 * hash) + MONITORED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResourcesList().hashCode();
    }
    if (hasBilling()) {
      hash = (37 * hash) + BILLING_FIELD_NUMBER;
      hash = (53 * hash) + getBilling().hashCode();
    }
    if (hasLogging()) {
      hash = (37 * hash) + LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + getLogging().hashCode();
    }
    if (hasMonitoring()) {
      hash = (37 * hash) + MONITORING_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoring().hashCode();
    }
    if (hasSystemParameters()) {
      hash = (37 * hash) + SYSTEM_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getSystemParameters().hashCode();
    }
    if (hasSourceInfo()) {
      hash = (37 * hash) + SOURCE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInfo().hashCode();
    }
    if (hasPublishing()) {
      hash = (37 * hash) + PUBLISHING_FIELD_NUMBER;
      hash = (53 * hash) + getPublishing().hashCode();
    }
    if (hasConfigVersion()) {
      hash = (37 * hash) + CONFIG_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getConfigVersion().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(com.couchbase.client.core.deps.com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(com.couchbase.client.core.deps.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.api.Service parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.couchbase.client.core.deps.com.google.api.Service prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Service` is the root object of Google API service configuration (service
   * config). It describes the basic information about a logical service,
   * such as the service name and the user-facing title, and delegates other
   * aspects to sub-sections. Each sub-section is either a proto message or a
   * repeated proto message that configures a specific aspect, such as auth.
   * For more information, see each proto message definition.
   *
   * Example:
   *
   *     type: google.api.Service
   *     name: calendar.googleapis.com
   *     title: Google Calendar API
   *     apis:
   *     - name: google.calendar.v3.Calendar
   *
   *     visibility:
   *       rules:
   *       - selector: "google.calendar.v3.*"
   *         restriction: PREVIEW
   *     backend:
   *       rules:
   *       - selector: "google.calendar.v3.*"
   *         address: calendar.example.com
   *
   *     authentication:
   *       providers:
   *       - id: google_calendar_auth
   *         jwks_uri: https://www.googleapis.com/oauth2/v1/certs
   *         issuer: https://securetoken.google.com
   *       rules:
   *       - selector: "*"
   *         requirements:
   *           provider_id: google_calendar_auth
   * </pre>
   *
   * Protobuf type {@code google.api.Service}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Service)
      com.google.api.ServiceOrBuilder {
    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ServiceProto.internal_static_google_api_Service_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ServiceProto.internal_static_google_api_Service_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Service.class, com.google.api.Service.Builder.class);
    }

    // Construct using com.google.api.Service.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getApisFieldBuilder();
        getTypesFieldBuilder();
        getEnumsFieldBuilder();
        getDocumentationFieldBuilder();
        getBackendFieldBuilder();
        getHttpFieldBuilder();
        getQuotaFieldBuilder();
        getAuthenticationFieldBuilder();
        getContextFieldBuilder();
        getUsageFieldBuilder();
        getEndpointsFieldBuilder();
        getControlFieldBuilder();
        getLogsFieldBuilder();
        getMetricsFieldBuilder();
        getMonitoredResourcesFieldBuilder();
        getBillingFieldBuilder();
        getLoggingFieldBuilder();
        getMonitoringFieldBuilder();
        getSystemParametersFieldBuilder();
        getSourceInfoFieldBuilder();
        getPublishingFieldBuilder();
        getConfigVersionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      title_ = "";
      producerProjectId_ = "";
      id_ = "";
      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
      } else {
        apis_ = null;
        apisBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (typesBuilder_ == null) {
        types_ = java.util.Collections.emptyList();
      } else {
        types_ = null;
        typesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (enumsBuilder_ == null) {
        enums_ = java.util.Collections.emptyList();
      } else {
        enums_ = null;
        enumsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      documentation_ = null;
      if (documentationBuilder_ != null) {
        documentationBuilder_.dispose();
        documentationBuilder_ = null;
      }
      backend_ = null;
      if (backendBuilder_ != null) {
        backendBuilder_.dispose();
        backendBuilder_ = null;
      }
      http_ = null;
      if (httpBuilder_ != null) {
        httpBuilder_.dispose();
        httpBuilder_ = null;
      }
      quota_ = null;
      if (quotaBuilder_ != null) {
        quotaBuilder_.dispose();
        quotaBuilder_ = null;
      }
      authentication_ = null;
      if (authenticationBuilder_ != null) {
        authenticationBuilder_.dispose();
        authenticationBuilder_ = null;
      }
      context_ = null;
      if (contextBuilder_ != null) {
        contextBuilder_.dispose();
        contextBuilder_ = null;
      }
      usage_ = null;
      if (usageBuilder_ != null) {
        usageBuilder_.dispose();
        usageBuilder_ = null;
      }
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
      } else {
        endpoints_ = null;
        endpointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      control_ = null;
      if (controlBuilder_ != null) {
        controlBuilder_.dispose();
        controlBuilder_ = null;
      }
      if (logsBuilder_ == null) {
        logs_ = java.util.Collections.emptyList();
      } else {
        logs_ = null;
        logsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00020000);
      if (monitoredResourcesBuilder_ == null) {
        monitoredResources_ = java.util.Collections.emptyList();
      } else {
        monitoredResources_ = null;
        monitoredResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00040000);
      billing_ = null;
      if (billingBuilder_ != null) {
        billingBuilder_.dispose();
        billingBuilder_ = null;
      }
      logging_ = null;
      if (loggingBuilder_ != null) {
        loggingBuilder_.dispose();
        loggingBuilder_ = null;
      }
      monitoring_ = null;
      if (monitoringBuilder_ != null) {
        monitoringBuilder_.dispose();
        monitoringBuilder_ = null;
      }
      systemParameters_ = null;
      if (systemParametersBuilder_ != null) {
        systemParametersBuilder_.dispose();
        systemParametersBuilder_ = null;
      }
      sourceInfo_ = null;
      if (sourceInfoBuilder_ != null) {
        sourceInfoBuilder_.dispose();
        sourceInfoBuilder_ = null;
      }
      publishing_ = null;
      if (publishingBuilder_ != null) {
        publishingBuilder_.dispose();
        publishingBuilder_ = null;
      }
      configVersion_ = null;
      if (configVersionBuilder_ != null) {
        configVersionBuilder_.dispose();
        configVersionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.ServiceProto.internal_static_google_api_Service_descriptor;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Service getDefaultInstanceForType() {
      return com.google.api.Service.getDefaultInstance();
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Service build() {
      com.google.api.Service result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.api.Service buildPartial() {
      com.google.api.Service result = new com.google.api.Service(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.couchbase.client.core.deps.com.google.api.Service result) {
      if (apisBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          apis_ = java.util.Collections.unmodifiableList(apis_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.apis_ = apis_;
      } else {
        result.apis_ = apisBuilder_.build();
      }
      if (typesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          types_ = java.util.Collections.unmodifiableList(types_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.types_ = types_;
      } else {
        result.types_ = typesBuilder_.build();
      }
      if (enumsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          enums_ = java.util.Collections.unmodifiableList(enums_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.enums_ = enums_;
      } else {
        result.enums_ = enumsBuilder_.build();
      }
      if (endpointsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          endpoints_ = java.util.Collections.unmodifiableList(endpoints_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.endpoints_ = endpoints_;
      } else {
        result.endpoints_ = endpointsBuilder_.build();
      }
      if (logsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          logs_ = java.util.Collections.unmodifiableList(logs_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.logs_ = logs_;
      } else {
        result.logs_ = logsBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00020000);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (monitoredResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)) {
          monitoredResources_ = java.util.Collections.unmodifiableList(monitoredResources_);
          bitField0_ = (bitField0_ & ~0x00040000);
        }
        result.monitoredResources_ = monitoredResources_;
      } else {
        result.monitoredResources_ = monitoredResourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.couchbase.client.core.deps.com.google.api.Service result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.producerProjectId_ = producerProjectId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.documentation_ =
            documentationBuilder_ == null ? documentation_ : documentationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.backend_ = backendBuilder_ == null ? backend_ : backendBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.http_ = httpBuilder_ == null ? http_ : httpBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.quota_ = quotaBuilder_ == null ? quota_ : quotaBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.authentication_ =
            authenticationBuilder_ == null ? authentication_ : authenticationBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.context_ = contextBuilder_ == null ? context_ : contextBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.usage_ = usageBuilder_ == null ? usage_ : usageBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.control_ = controlBuilder_ == null ? control_ : controlBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.billing_ = billingBuilder_ == null ? billing_ : billingBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.logging_ = loggingBuilder_ == null ? logging_ : loggingBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.monitoring_ = monitoringBuilder_ == null ? monitoring_ : monitoringBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.systemParameters_ =
            systemParametersBuilder_ == null ? systemParameters_ : systemParametersBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.sourceInfo_ = sourceInfoBuilder_ == null ? sourceInfo_ : sourceInfoBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.publishing_ = publishingBuilder_ == null ? publishing_ : publishingBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.configVersion_ =
            configVersionBuilder_ == null ? configVersion_ : configVersionBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Service) {
        return mergeFrom((com.couchbase.client.core.deps.com.google.api.Service) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.api.Service other) {
      if (other == com.google.api.Service.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getProducerProjectId().isEmpty()) {
        producerProjectId_ = other.producerProjectId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (apisBuilder_ == null) {
        if (!other.apis_.isEmpty()) {
          if (apis_.isEmpty()) {
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureApisIsMutable();
            apis_.addAll(other.apis_);
          }
          onChanged();
        }
      } else {
        if (!other.apis_.isEmpty()) {
          if (apisBuilder_.isEmpty()) {
            apisBuilder_.dispose();
            apisBuilder_ = null;
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000010);
            apisBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getApisFieldBuilder()
                    : null;
          } else {
            apisBuilder_.addAllMessages(other.apis_);
          }
        }
      }
      if (typesBuilder_ == null) {
        if (!other.types_.isEmpty()) {
          if (types_.isEmpty()) {
            types_ = other.types_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTypesIsMutable();
            types_.addAll(other.types_);
          }
          onChanged();
        }
      } else {
        if (!other.types_.isEmpty()) {
          if (typesBuilder_.isEmpty()) {
            typesBuilder_.dispose();
            typesBuilder_ = null;
            types_ = other.types_;
            bitField0_ = (bitField0_ & ~0x00000020);
            typesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTypesFieldBuilder()
                    : null;
          } else {
            typesBuilder_.addAllMessages(other.types_);
          }
        }
      }
      if (enumsBuilder_ == null) {
        if (!other.enums_.isEmpty()) {
          if (enums_.isEmpty()) {
            enums_ = other.enums_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureEnumsIsMutable();
            enums_.addAll(other.enums_);
          }
          onChanged();
        }
      } else {
        if (!other.enums_.isEmpty()) {
          if (enumsBuilder_.isEmpty()) {
            enumsBuilder_.dispose();
            enumsBuilder_ = null;
            enums_ = other.enums_;
            bitField0_ = (bitField0_ & ~0x00000040);
            enumsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnumsFieldBuilder()
                    : null;
          } else {
            enumsBuilder_.addAllMessages(other.enums_);
          }
        }
      }
      if (other.hasDocumentation()) {
        mergeDocumentation(other.getDocumentation());
      }
      if (other.hasBackend()) {
        mergeBackend(other.getBackend());
      }
      if (other.hasHttp()) {
        mergeHttp(other.getHttp());
      }
      if (other.hasQuota()) {
        mergeQuota(other.getQuota());
      }
      if (other.hasAuthentication()) {
        mergeAuthentication(other.getAuthentication());
      }
      if (other.hasContext()) {
        mergeContext(other.getContext());
      }
      if (other.hasUsage()) {
        mergeUsage(other.getUsage());
      }
      if (endpointsBuilder_ == null) {
        if (!other.endpoints_.isEmpty()) {
          if (endpoints_.isEmpty()) {
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureEndpointsIsMutable();
            endpoints_.addAll(other.endpoints_);
          }
          onChanged();
        }
      } else {
        if (!other.endpoints_.isEmpty()) {
          if (endpointsBuilder_.isEmpty()) {
            endpointsBuilder_.dispose();
            endpointsBuilder_ = null;
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00004000);
            endpointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndpointsFieldBuilder()
                    : null;
          } else {
            endpointsBuilder_.addAllMessages(other.endpoints_);
          }
        }
      }
      if (other.hasControl()) {
        mergeControl(other.getControl());
      }
      if (logsBuilder_ == null) {
        if (!other.logs_.isEmpty()) {
          if (logs_.isEmpty()) {
            logs_ = other.logs_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureLogsIsMutable();
            logs_.addAll(other.logs_);
          }
          onChanged();
        }
      } else {
        if (!other.logs_.isEmpty()) {
          if (logsBuilder_.isEmpty()) {
            logsBuilder_.dispose();
            logsBuilder_ = null;
            logs_ = other.logs_;
            bitField0_ = (bitField0_ & ~0x00010000);
            logsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLogsFieldBuilder()
                    : null;
          } else {
            logsBuilder_.addAllMessages(other.logs_);
          }
        }
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00020000);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00020000);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (monitoredResourcesBuilder_ == null) {
        if (!other.monitoredResources_.isEmpty()) {
          if (monitoredResources_.isEmpty()) {
            monitoredResources_ = other.monitoredResources_;
            bitField0_ = (bitField0_ & ~0x00040000);
          } else {
            ensureMonitoredResourcesIsMutable();
            monitoredResources_.addAll(other.monitoredResources_);
          }
          onChanged();
        }
      } else {
        if (!other.monitoredResources_.isEmpty()) {
          if (monitoredResourcesBuilder_.isEmpty()) {
            monitoredResourcesBuilder_.dispose();
            monitoredResourcesBuilder_ = null;
            monitoredResources_ = other.monitoredResources_;
            bitField0_ = (bitField0_ & ~0x00040000);
            monitoredResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMonitoredResourcesFieldBuilder()
                    : null;
          } else {
            monitoredResourcesBuilder_.addAllMessages(other.monitoredResources_);
          }
        }
      }
      if (other.hasBilling()) {
        mergeBilling(other.getBilling());
      }
      if (other.hasLogging()) {
        mergeLogging(other.getLogging());
      }
      if (other.hasMonitoring()) {
        mergeMonitoring(other.getMonitoring());
      }
      if (other.hasSystemParameters()) {
        mergeSystemParameters(other.getSystemParameters());
      }
      if (other.hasSourceInfo()) {
        mergeSourceInfo(other.getSourceInfo());
      }
      if (other.hasPublishing()) {
        mergePublishing(other.getPublishing());
      }
      if (other.hasConfigVersion()) {
        mergeConfigVersion(other.getConfigVersion());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Api m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.protobuf.Api.parser(), extensionRegistry);
                if (apisBuilder_ == null) {
                  ensureApisIsMutable();
                  apis_.add(m);
                } else {
                  apisBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.Type m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.protobuf.Type.parser(), extensionRegistry);
                if (typesBuilder_ == null) {
                  ensureTypesIsMutable();
                  types_.add(m);
                } else {
                  typesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.Enum m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.protobuf.Enum.parser(), extensionRegistry);
                if (enumsBuilder_ == null) {
                  ensureEnumsIsMutable();
                  enums_.add(m);
                } else {
                  enumsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getDocumentationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(getBackendFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getHttpFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getQuotaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getAuthenticationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 122:
              {
                input.readMessage(getUsageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            case 146:
              {
                com.google.api.Endpoint m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.api.Endpoint.parser(), extensionRegistry);
                if (endpointsBuilder_ == null) {
                  ensureEndpointsIsMutable();
                  endpoints_.add(m);
                } else {
                  endpointsBuilder_.addMessage(m);
                }
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getConfigVersionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getControlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 170
            case 178:
              {
                producerProjectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 178
            case 186:
              {
                com.google.api.LogDescriptor m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.api.LogDescriptor.parser(), extensionRegistry);
                if (logsBuilder_ == null) {
                  ensureLogsIsMutable();
                  logs_.add(m);
                } else {
                  logsBuilder_.addMessage(m);
                }
                break;
              } // case 186
            case 194:
              {
                com.google.api.MetricDescriptor m =
                    input.readMessage(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.parser(), extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 194
            case 202:
              {
                com.google.api.MonitoredResourceDescriptor m =
                    input.readMessage(
                        com.google.api.MonitoredResourceDescriptor.parser(), extensionRegistry);
                if (monitoredResourcesBuilder_ == null) {
                  ensureMonitoredResourcesIsMutable();
                  monitoredResources_.add(m);
                } else {
                  monitoredResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getBillingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(getLoggingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getMonitoringFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(
                    getSystemParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 234
            case 266:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 266
            case 298:
              {
                input.readMessage(getSourceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 298
            case 362:
              {
                input.readMessage(getPublishingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 362
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The service name, which is a DNS-like logical identifier for the
     * service, such as `calendar.googleapis.com`. The service name
     * typically goes through DNS verification to make sure the owner
     * of the service also owns the DNS name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name, which is a DNS-like logical identifier for the
     * service, such as `calendar.googleapis.com`. The service name
     * typically goes through DNS verification to make sure the owner
     * of the service also owns the DNS name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service name, which is a DNS-like logical identifier for the
     * service, such as `calendar.googleapis.com`. The service name
     * typically goes through DNS verification to make sure the owner
     * of the service also owns the DNS name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name, which is a DNS-like logical identifier for the
     * service, such as `calendar.googleapis.com`. The service name
     * typically goes through DNS verification to make sure the owner
     * of the service also owns the DNS name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service name, which is a DNS-like logical identifier for the
     * service, such as `calendar.googleapis.com`. The service name
     * typically goes through DNS verification to make sure the owner
     * of the service also owns the DNS name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * The product title for this service, it is the name displayed in Google
     * Cloud Console.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product title for this service, it is the name displayed in Google
     * Cloud Console.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product title for this service, it is the name displayed in Google
     * Cloud Console.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product title for this service, it is the name displayed in Google
     * Cloud Console.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product title for this service, it is the name displayed in Google
     * Cloud Console.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object producerProjectId_ = "";
    /**
     *
     *
     * <pre>
     * The Google project that owns this service.
     * </pre>
     *
     * <code>string producer_project_id = 22;</code>
     *
     * @return The producerProjectId.
     */
    public java.lang.String getProducerProjectId() {
      java.lang.Object ref = producerProjectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        producerProjectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google project that owns this service.
     * </pre>
     *
     * <code>string producer_project_id = 22;</code>
     *
     * @return The bytes for producerProjectId.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getProducerProjectIdBytes() {
      java.lang.Object ref = producerProjectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        producerProjectId_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google project that owns this service.
     * </pre>
     *
     * <code>string producer_project_id = 22;</code>
     *
     * @param value The producerProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setProducerProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      producerProjectId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google project that owns this service.
     * </pre>
     *
     * <code>string producer_project_id = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProducerProjectId() {
      producerProjectId_ = getDefaultInstance().getProducerProjectId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google project that owns this service.
     * </pre>
     *
     * <code>string producer_project_id = 22;</code>
     *
     * @param value The bytes for producerProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setProducerProjectIdBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      producerProjectId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * A unique ID for a specific instance of this message, typically assigned
     * by the client for tracking purpose. Must be no longer than 63 characters
     * and only lower case letters, digits, '.', '_' and '-' are allowed. If
     * empty, the server may choose to generate one instead.
     * </pre>
     *
     * <code>string id = 33;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique ID for a specific instance of this message, typically assigned
     * by the client for tracking purpose. Must be no longer than 63 characters
     * and only lower case letters, digits, '.', '_' and '-' are allowed. If
     * empty, the server may choose to generate one instead.
     * </pre>
     *
     * <code>string id = 33;</code>
     *
     * @return The bytes for id.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.couchbase.client.core.deps.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique ID for a specific instance of this message, typically assigned
     * by the client for tracking purpose. Must be no longer than 63 characters
     * and only lower case letters, digits, '.', '_' and '-' are allowed. If
     * empty, the server may choose to generate one instead.
     * </pre>
     *
     * <code>string id = 33;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique ID for a specific instance of this message, typically assigned
     * by the client for tracking purpose. Must be no longer than 63 characters
     * and only lower case letters, digits, '.', '_' and '-' are allowed. If
     * empty, the server may choose to generate one instead.
     * </pre>
     *
     * <code>string id = 33;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique ID for a specific instance of this message, typically assigned
     * by the client for tracking purpose. Must be no longer than 63 characters
     * and only lower case letters, digits, '.', '_' and '-' are allowed. If
     * empty, the server may choose to generate one instead.
     * </pre>
     *
     * <code>string id = 33;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.couchbase.client.core.deps.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Api> apis_ = java.util.Collections.emptyList();

    private void ensureApisIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        apis_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.protobuf.Api>(apis_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Api,
            com.google.protobuf.Api.Builder,
            com.google.protobuf.ApiOrBuilder>
        apisBuilder_;

    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Api> getApisList() {
      if (apisBuilder_ == null) {
        return java.util.Collections.unmodifiableList(apis_);
      } else {
        return apisBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public int getApisCount() {
      if (apisBuilder_ == null) {
        return apis_.size();
      } else {
        return apisBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Api getApis(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder setApis(int index, com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.set(index, value);
        onChanged();
      } else {
        apisBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder setApis(int index, com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.set(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(com.couchbase.client.core.deps.com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(value);
        onChanged();
      } else {
        apisBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(int index, com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(index, value);
        onChanged();
      } else {
        apisBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(com.couchbase.client.core.deps.com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(int index, com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addAllApis(java.lang.Iterable<? extends com.google.protobuf.Api> values) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, apis_);
        onChanged();
      } else {
        apisBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder clearApis() {
      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        apisBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder removeApis(int index) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.remove(index);
        onChanged();
      } else {
        apisBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Api.Builder getApisBuilder(int index) {
      return getApisFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.ApiOrBuilder getApisOrBuilder(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.ApiOrBuilder> getApisOrBuilderList() {
      if (apisBuilder_ != null) {
        return apisBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(apis_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Api.Builder addApisBuilder() {
      return getApisFieldBuilder().addBuilder(com.couchbase.client.core.deps.com.google.protobuf.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Api.Builder addApisBuilder(int index) {
      return getApisFieldBuilder().addBuilder(index, com.google.protobuf.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Only the `name` field
     * of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by
     * the configuration author, as the remaining fields will be derived from the
     * IDL during the normalization process. It is an error to specify an API
     * interface here which cannot be resolved against the associated IDL files.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Api.Builder> getApisBuilderList() {
      return getApisFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Api,
            com.google.protobuf.Api.Builder,
            com.google.protobuf.ApiOrBuilder>
        getApisFieldBuilder() {
      if (apisBuilder_ == null) {
        apisBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Api,
                com.google.protobuf.Api.Builder,
                com.google.protobuf.ApiOrBuilder>(
                apis_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        apis_ = null;
      }
      return apisBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Type> types_ = java.util.Collections.emptyList();

    private void ensureTypesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        types_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.protobuf.Type>(types_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Type,
            com.google.protobuf.Type.Builder,
            com.google.protobuf.TypeOrBuilder>
        typesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Type> getTypesList() {
      if (typesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(types_);
      } else {
        return typesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public int getTypesCount() {
      if (typesBuilder_ == null) {
        return types_.size();
      } else {
        return typesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Type getTypes(int index) {
      if (typesBuilder_ == null) {
        return types_.get(index);
      } else {
        return typesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder setTypes(int index, com.google.protobuf.Type value) {
      if (typesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTypesIsMutable();
        types_.set(index, value);
        onChanged();
      } else {
        typesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder setTypes(int index, com.google.protobuf.Type.Builder builderForValue) {
      if (typesBuilder_ == null) {
        ensureTypesIsMutable();
        types_.set(index, builderForValue.build());
        onChanged();
      } else {
        typesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder addTypes(com.couchbase.client.core.deps.com.google.protobuf.Type value) {
      if (typesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTypesIsMutable();
        types_.add(value);
        onChanged();
      } else {
        typesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder addTypes(int index, com.google.protobuf.Type value) {
      if (typesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTypesIsMutable();
        types_.add(index, value);
        onChanged();
      } else {
        typesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder addTypes(com.couchbase.client.core.deps.com.google.protobuf.Type.Builder builderForValue) {
      if (typesBuilder_ == null) {
        ensureTypesIsMutable();
        types_.add(builderForValue.build());
        onChanged();
      } else {
        typesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder addTypes(int index, com.google.protobuf.Type.Builder builderForValue) {
      if (typesBuilder_ == null) {
        ensureTypesIsMutable();
        types_.add(index, builderForValue.build());
        onChanged();
      } else {
        typesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder addAllTypes(java.lang.Iterable<? extends com.google.protobuf.Type> values) {
      if (typesBuilder_ == null) {
        ensureTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, types_);
        onChanged();
      } else {
        typesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder clearTypes() {
      if (typesBuilder_ == null) {
        types_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        typesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public Builder removeTypes(int index) {
      if (typesBuilder_ == null) {
        ensureTypesIsMutable();
        types_.remove(index);
        onChanged();
      } else {
        typesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Type.Builder getTypesBuilder(int index) {
      return getTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.TypeOrBuilder getTypesOrBuilder(int index) {
      if (typesBuilder_ == null) {
        return types_.get(index);
      } else {
        return typesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public java.util.List<? extends com.google.protobuf.TypeOrBuilder> getTypesOrBuilderList() {
      if (typesBuilder_ != null) {
        return typesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(types_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Type.Builder addTypesBuilder() {
      return getTypesFieldBuilder().addBuilder(com.couchbase.client.core.deps.com.google.protobuf.Type.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Type.Builder addTypesBuilder(int index) {
      return getTypesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Type.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of all proto message types included in this API service.
     * Types referenced directly or indirectly by the `apis` are automatically
     * included.  Messages which are not referenced but shall be included, such as
     * types used by the `google.protobuf.Any` type, should be listed here by
     * name by the configuration author. Example:
     *
     *     types:
     *     - name: google.protobuf.Int32
     * </pre>
     *
     * <code>repeated .google.protobuf.Type types = 4;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Type.Builder> getTypesBuilderList() {
      return getTypesFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Type,
            com.google.protobuf.Type.Builder,
            com.google.protobuf.TypeOrBuilder>
        getTypesFieldBuilder() {
      if (typesBuilder_ == null) {
        typesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Type,
                com.google.protobuf.Type.Builder,
                com.google.protobuf.TypeOrBuilder>(
                types_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        types_ = null;
      }
      return typesBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Enum> enums_ = java.util.Collections.emptyList();

    private void ensureEnumsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        enums_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.protobuf.Enum>(enums_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Enum,
            com.google.protobuf.Enum.Builder,
            com.google.protobuf.EnumOrBuilder>
        enumsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Enum> getEnumsList() {
      if (enumsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(enums_);
      } else {
        return enumsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public int getEnumsCount() {
      if (enumsBuilder_ == null) {
        return enums_.size();
      } else {
        return enumsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Enum getEnums(int index) {
      if (enumsBuilder_ == null) {
        return enums_.get(index);
      } else {
        return enumsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder setEnums(int index, com.google.protobuf.Enum value) {
      if (enumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnumsIsMutable();
        enums_.set(index, value);
        onChanged();
      } else {
        enumsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder setEnums(int index, com.google.protobuf.Enum.Builder builderForValue) {
      if (enumsBuilder_ == null) {
        ensureEnumsIsMutable();
        enums_.set(index, builderForValue.build());
        onChanged();
      } else {
        enumsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder addEnums(com.couchbase.client.core.deps.com.google.protobuf.Enum value) {
      if (enumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnumsIsMutable();
        enums_.add(value);
        onChanged();
      } else {
        enumsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder addEnums(int index, com.google.protobuf.Enum value) {
      if (enumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnumsIsMutable();
        enums_.add(index, value);
        onChanged();
      } else {
        enumsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder addEnums(com.couchbase.client.core.deps.com.google.protobuf.Enum.Builder builderForValue) {
      if (enumsBuilder_ == null) {
        ensureEnumsIsMutable();
        enums_.add(builderForValue.build());
        onChanged();
      } else {
        enumsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder addEnums(int index, com.google.protobuf.Enum.Builder builderForValue) {
      if (enumsBuilder_ == null) {
        ensureEnumsIsMutable();
        enums_.add(index, builderForValue.build());
        onChanged();
      } else {
        enumsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder addAllEnums(java.lang.Iterable<? extends com.google.protobuf.Enum> values) {
      if (enumsBuilder_ == null) {
        ensureEnumsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enums_);
        onChanged();
      } else {
        enumsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder clearEnums() {
      if (enumsBuilder_ == null) {
        enums_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        enumsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public Builder removeEnums(int index) {
      if (enumsBuilder_ == null) {
        ensureEnumsIsMutable();
        enums_.remove(index);
        onChanged();
      } else {
        enumsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Enum.Builder getEnumsBuilder(int index) {
      return getEnumsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.EnumOrBuilder getEnumsOrBuilder(int index) {
      if (enumsBuilder_ == null) {
        return enums_.get(index);
      } else {
        return enumsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public java.util.List<? extends com.google.protobuf.EnumOrBuilder> getEnumsOrBuilderList() {
      if (enumsBuilder_ != null) {
        return enumsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(enums_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Enum.Builder addEnumsBuilder() {
      return getEnumsFieldBuilder().addBuilder(com.couchbase.client.core.deps.com.google.protobuf.Enum.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Enum.Builder addEnumsBuilder(int index) {
      return getEnumsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Enum.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of all enum types included in this API service.  Enums referenced
     * directly or indirectly by the `apis` are automatically included.  Enums
     * which are not referenced but shall be included should be listed here by
     * name by the configuration author. Example:
     *
     *     enums:
     *     - name: google.someapi.v1.SomeEnum
     * </pre>
     *
     * <code>repeated .google.protobuf.Enum enums = 5;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.protobuf.Enum.Builder> getEnumsBuilderList() {
      return getEnumsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Enum,
            com.google.protobuf.Enum.Builder,
            com.google.protobuf.EnumOrBuilder>
        getEnumsFieldBuilder() {
      if (enumsBuilder_ == null) {
        enumsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Enum,
                com.google.protobuf.Enum.Builder,
                com.google.protobuf.EnumOrBuilder>(
                enums_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        enums_ = null;
      }
      return enumsBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Documentation documentation_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Documentation,
            com.google.api.Documentation.Builder,
            com.google.api.DocumentationOrBuilder>
        documentationBuilder_;
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     *
     * @return Whether the documentation field is set.
     */
    public boolean hasDocumentation() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     *
     * @return The documentation.
     */
    public com.couchbase.client.core.deps.com.google.api.Documentation getDocumentation() {
      if (documentationBuilder_ == null) {
        return documentation_ == null
            ? com.google.api.Documentation.getDefaultInstance()
            : documentation_;
      } else {
        return documentationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder setDocumentation(com.couchbase.client.core.deps.com.google.api.Documentation value) {
      if (documentationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentation_ = value;
      } else {
        documentationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder setDocumentation(com.couchbase.client.core.deps.com.google.api.Documentation.Builder builderForValue) {
      if (documentationBuilder_ == null) {
        documentation_ = builderForValue.build();
      } else {
        documentationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder mergeDocumentation(com.couchbase.client.core.deps.com.google.api.Documentation value) {
      if (documentationBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && documentation_ != null
            && documentation_ != com.google.api.Documentation.getDefaultInstance()) {
          getDocumentationBuilder().mergeFrom(value);
        } else {
          documentation_ = value;
        }
      } else {
        documentationBuilder_.mergeFrom(value);
      }
      if (documentation_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder clearDocumentation() {
      bitField0_ = (bitField0_ & ~0x00000080);
      documentation_ = null;
      if (documentationBuilder_ != null) {
        documentationBuilder_.dispose();
        documentationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Documentation.Builder getDocumentationBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDocumentationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.DocumentationOrBuilder getDocumentationOrBuilder() {
      if (documentationBuilder_ != null) {
        return documentationBuilder_.getMessageOrBuilder();
      } else {
        return documentation_ == null
            ? com.google.api.Documentation.getDefaultInstance()
            : documentation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Documentation,
            com.google.api.Documentation.Builder,
            com.google.api.DocumentationOrBuilder>
        getDocumentationFieldBuilder() {
      if (documentationBuilder_ == null) {
        documentationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Documentation,
                com.google.api.Documentation.Builder,
                com.google.api.DocumentationOrBuilder>(
                getDocumentation(), getParentForChildren(), isClean());
        documentation_ = null;
      }
      return documentationBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Backend backend_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Backend, com.google.api.Backend.Builder, com.google.api.BackendOrBuilder>
        backendBuilder_;
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     *
     * @return Whether the backend field is set.
     */
    public boolean hasBackend() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     *
     * @return The backend.
     */
    public com.couchbase.client.core.deps.com.google.api.Backend getBackend() {
      if (backendBuilder_ == null) {
        return backend_ == null ? com.google.api.Backend.getDefaultInstance() : backend_;
      } else {
        return backendBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public Builder setBackend(com.couchbase.client.core.deps.com.google.api.Backend value) {
      if (backendBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backend_ = value;
      } else {
        backendBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public Builder setBackend(com.couchbase.client.core.deps.com.google.api.Backend.Builder builderForValue) {
      if (backendBuilder_ == null) {
        backend_ = builderForValue.build();
      } else {
        backendBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public Builder mergeBackend(com.couchbase.client.core.deps.com.google.api.Backend value) {
      if (backendBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && backend_ != null
            && backend_ != com.google.api.Backend.getDefaultInstance()) {
          getBackendBuilder().mergeFrom(value);
        } else {
          backend_ = value;
        }
      } else {
        backendBuilder_.mergeFrom(value);
      }
      if (backend_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public Builder clearBackend() {
      bitField0_ = (bitField0_ & ~0x00000100);
      backend_ = null;
      if (backendBuilder_ != null) {
        backendBuilder_.dispose();
        backendBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Backend.Builder getBackendBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getBackendFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.BackendOrBuilder getBackendOrBuilder() {
      if (backendBuilder_ != null) {
        return backendBuilder_.getMessageOrBuilder();
      } else {
        return backend_ == null ? com.google.api.Backend.getDefaultInstance() : backend_;
      }
    }
    /**
     *
     *
     * <pre>
     * API backend configuration.
     * </pre>
     *
     * <code>.google.api.Backend backend = 8;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Backend, com.google.api.Backend.Builder, com.google.api.BackendOrBuilder>
        getBackendFieldBuilder() {
      if (backendBuilder_ == null) {
        backendBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Backend,
                com.google.api.Backend.Builder,
                com.google.api.BackendOrBuilder>(getBackend(), getParentForChildren(), isClean());
        backend_ = null;
      }
      return backendBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Http http_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Http, com.google.api.Http.Builder, com.google.api.HttpOrBuilder>
        httpBuilder_;
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     *
     * @return Whether the http field is set.
     */
    public boolean hasHttp() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     *
     * @return The http.
     */
    public com.couchbase.client.core.deps.com.google.api.Http getHttp() {
      if (httpBuilder_ == null) {
        return http_ == null ? com.google.api.Http.getDefaultInstance() : http_;
      } else {
        return httpBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public Builder setHttp(com.couchbase.client.core.deps.com.google.api.Http value) {
      if (httpBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        http_ = value;
      } else {
        httpBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public Builder setHttp(com.couchbase.client.core.deps.com.google.api.Http.Builder builderForValue) {
      if (httpBuilder_ == null) {
        http_ = builderForValue.build();
      } else {
        httpBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public Builder mergeHttp(com.couchbase.client.core.deps.com.google.api.Http value) {
      if (httpBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && http_ != null
            && http_ != com.google.api.Http.getDefaultInstance()) {
          getHttpBuilder().mergeFrom(value);
        } else {
          http_ = value;
        }
      } else {
        httpBuilder_.mergeFrom(value);
      }
      if (http_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public Builder clearHttp() {
      bitField0_ = (bitField0_ & ~0x00000200);
      http_ = null;
      if (httpBuilder_ != null) {
        httpBuilder_.dispose();
        httpBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Http.Builder getHttpBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getHttpFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.HttpOrBuilder getHttpOrBuilder() {
      if (httpBuilder_ != null) {
        return httpBuilder_.getMessageOrBuilder();
      } else {
        return http_ == null ? com.google.api.Http.getDefaultInstance() : http_;
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP configuration.
     * </pre>
     *
     * <code>.google.api.Http http = 9;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Http, com.google.api.Http.Builder, com.google.api.HttpOrBuilder>
        getHttpFieldBuilder() {
      if (httpBuilder_ == null) {
        httpBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Http, com.google.api.Http.Builder, com.google.api.HttpOrBuilder>(
                getHttp(), getParentForChildren(), isClean());
        http_ = null;
      }
      return httpBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Quota quota_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>
        quotaBuilder_;
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     *
     * @return Whether the quota field is set.
     */
    public boolean hasQuota() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     *
     * @return The quota.
     */
    public com.couchbase.client.core.deps.com.google.api.Quota getQuota() {
      if (quotaBuilder_ == null) {
        return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
      } else {
        return quotaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder setQuota(com.couchbase.client.core.deps.com.google.api.Quota value) {
      if (quotaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quota_ = value;
      } else {
        quotaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder setQuota(com.couchbase.client.core.deps.com.google.api.Quota.Builder builderForValue) {
      if (quotaBuilder_ == null) {
        quota_ = builderForValue.build();
      } else {
        quotaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder mergeQuota(com.couchbase.client.core.deps.com.google.api.Quota value) {
      if (quotaBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && quota_ != null
            && quota_ != com.google.api.Quota.getDefaultInstance()) {
          getQuotaBuilder().mergeFrom(value);
        } else {
          quota_ = value;
        }
      } else {
        quotaBuilder_.mergeFrom(value);
      }
      if (quota_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder clearQuota() {
      bitField0_ = (bitField0_ & ~0x00000400);
      quota_ = null;
      if (quotaBuilder_ != null) {
        quotaBuilder_.dispose();
        quotaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Quota.Builder getQuotaBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getQuotaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.QuotaOrBuilder getQuotaOrBuilder() {
      if (quotaBuilder_ != null) {
        return quotaBuilder_.getMessageOrBuilder();
      } else {
        return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
      }
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>
        getQuotaFieldBuilder() {
      if (quotaBuilder_ == null) {
        quotaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>(
                getQuota(), getParentForChildren(), isClean());
        quota_ = null;
      }
      return quotaBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Authentication authentication_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Authentication,
            com.google.api.Authentication.Builder,
            com.google.api.AuthenticationOrBuilder>
        authenticationBuilder_;
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     *
     * @return Whether the authentication field is set.
     */
    public boolean hasAuthentication() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     *
     * @return The authentication.
     */
    public com.couchbase.client.core.deps.com.google.api.Authentication getAuthentication() {
      if (authenticationBuilder_ == null) {
        return authentication_ == null
            ? com.google.api.Authentication.getDefaultInstance()
            : authentication_;
      } else {
        return authenticationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder setAuthentication(com.couchbase.client.core.deps.com.google.api.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authentication_ = value;
      } else {
        authenticationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder setAuthentication(com.couchbase.client.core.deps.com.google.api.Authentication.Builder builderForValue) {
      if (authenticationBuilder_ == null) {
        authentication_ = builderForValue.build();
      } else {
        authenticationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder mergeAuthentication(com.couchbase.client.core.deps.com.google.api.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && authentication_ != null
            && authentication_ != com.google.api.Authentication.getDefaultInstance()) {
          getAuthenticationBuilder().mergeFrom(value);
        } else {
          authentication_ = value;
        }
      } else {
        authenticationBuilder_.mergeFrom(value);
      }
      if (authentication_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder clearAuthentication() {
      bitField0_ = (bitField0_ & ~0x00000800);
      authentication_ = null;
      if (authenticationBuilder_ != null) {
        authenticationBuilder_.dispose();
        authenticationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Authentication.Builder getAuthenticationBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getAuthenticationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.AuthenticationOrBuilder getAuthenticationOrBuilder() {
      if (authenticationBuilder_ != null) {
        return authenticationBuilder_.getMessageOrBuilder();
      } else {
        return authentication_ == null
            ? com.google.api.Authentication.getDefaultInstance()
            : authentication_;
      }
    }
    /**
     *
     *
     * <pre>
     * Auth configuration.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Authentication,
            com.google.api.Authentication.Builder,
            com.google.api.AuthenticationOrBuilder>
        getAuthenticationFieldBuilder() {
      if (authenticationBuilder_ == null) {
        authenticationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Authentication,
                com.google.api.Authentication.Builder,
                com.google.api.AuthenticationOrBuilder>(
                getAuthentication(), getParentForChildren(), isClean());
        authentication_ = null;
      }
      return authenticationBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Context context_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Context, com.google.api.Context.Builder, com.google.api.ContextOrBuilder>
        contextBuilder_;
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     *
     * @return Whether the context field is set.
     */
    public boolean hasContext() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     *
     * @return The context.
     */
    public com.couchbase.client.core.deps.com.google.api.Context getContext() {
      if (contextBuilder_ == null) {
        return context_ == null ? com.google.api.Context.getDefaultInstance() : context_;
      } else {
        return contextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public Builder setContext(com.couchbase.client.core.deps.com.google.api.Context value) {
      if (contextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
      } else {
        contextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public Builder setContext(com.couchbase.client.core.deps.com.google.api.Context.Builder builderForValue) {
      if (contextBuilder_ == null) {
        context_ = builderForValue.build();
      } else {
        contextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public Builder mergeContext(com.couchbase.client.core.deps.com.google.api.Context value) {
      if (contextBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && context_ != null
            && context_ != com.google.api.Context.getDefaultInstance()) {
          getContextBuilder().mergeFrom(value);
        } else {
          context_ = value;
        }
      } else {
        contextBuilder_.mergeFrom(value);
      }
      if (context_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public Builder clearContext() {
      bitField0_ = (bitField0_ & ~0x00001000);
      context_ = null;
      if (contextBuilder_ != null) {
        contextBuilder_.dispose();
        contextBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Context.Builder getContextBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ContextOrBuilder getContextOrBuilder() {
      if (contextBuilder_ != null) {
        return contextBuilder_.getMessageOrBuilder();
      } else {
        return context_ == null ? com.google.api.Context.getDefaultInstance() : context_;
      }
    }
    /**
     *
     *
     * <pre>
     * Context configuration.
     * </pre>
     *
     * <code>.google.api.Context context = 12;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Context, com.google.api.Context.Builder, com.google.api.ContextOrBuilder>
        getContextFieldBuilder() {
      if (contextBuilder_ == null) {
        contextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Context,
                com.google.api.Context.Builder,
                com.google.api.ContextOrBuilder>(getContext(), getParentForChildren(), isClean());
        context_ = null;
      }
      return contextBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Usage usage_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>
        usageBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     *
     * @return Whether the usage field is set.
     */
    public boolean hasUsage() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     *
     * @return The usage.
     */
    public com.couchbase.client.core.deps.com.google.api.Usage getUsage() {
      if (usageBuilder_ == null) {
        return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
      } else {
        return usageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder setUsage(com.couchbase.client.core.deps.com.google.api.Usage value) {
      if (usageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usage_ = value;
      } else {
        usageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder setUsage(com.couchbase.client.core.deps.com.google.api.Usage.Builder builderForValue) {
      if (usageBuilder_ == null) {
        usage_ = builderForValue.build();
      } else {
        usageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder mergeUsage(com.couchbase.client.core.deps.com.google.api.Usage value) {
      if (usageBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && usage_ != null
            && usage_ != com.google.api.Usage.getDefaultInstance()) {
          getUsageBuilder().mergeFrom(value);
        } else {
          usage_ = value;
        }
      } else {
        usageBuilder_.mergeFrom(value);
      }
      if (usage_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder clearUsage() {
      bitField0_ = (bitField0_ & ~0x00002000);
      usage_ = null;
      if (usageBuilder_ != null) {
        usageBuilder_.dispose();
        usageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Usage.Builder getUsageBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getUsageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.UsageOrBuilder getUsageOrBuilder() {
      if (usageBuilder_ != null) {
        return usageBuilder_.getMessageOrBuilder();
      } else {
        return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>
        getUsageFieldBuilder() {
      if (usageBuilder_ == null) {
        usageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>(
                getUsage(), getParentForChildren(), isClean());
        usage_ = null;
      }
      return usageBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.Endpoint> endpoints_ = java.util.Collections.emptyList();

    private void ensureEndpointsIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        endpoints_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.Endpoint>(endpoints_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Endpoint,
            com.google.api.Endpoint.Builder,
            com.google.api.EndpointOrBuilder>
        endpointsBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.Endpoint> getEndpointsList() {
      if (endpointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endpoints_);
      } else {
        return endpointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public int getEndpointsCount() {
      if (endpointsBuilder_ == null) {
        return endpoints_.size();
      } else {
        return endpointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Endpoint getEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder setEndpoints(int index, com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.set(index, value);
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder setEndpoints(int index, com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(com.couchbase.client.core.deps.com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(int index, com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(index, value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(com.couchbase.client.core.deps.com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(int index, com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addAllEndpoints(java.lang.Iterable<? extends com.google.api.Endpoint> values) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpoints_);
        onChanged();
      } else {
        endpointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder clearEndpoints() {
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        endpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder removeEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.remove(index);
        onChanged();
      } else {
        endpointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Endpoint.Builder getEndpointsBuilder(int index) {
      return getEndpointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.EndpointOrBuilder getEndpointsOrBuilder(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<? extends com.google.api.EndpointOrBuilder> getEndpointsOrBuilderList() {
      if (endpointsBuilder_ != null) {
        return endpointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endpoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Endpoint.Builder addEndpointsBuilder() {
      return getEndpointsFieldBuilder().addBuilder(com.couchbase.client.core.deps.com.google.api.Endpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Endpoint.Builder addEndpointsBuilder(int index) {
      return getEndpointsFieldBuilder()
          .addBuilder(index, com.google.api.Endpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints.  If this is empty, then an endpoint
     * with the same name as the service is automatically generated to service all
     * defined APIs.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.Endpoint.Builder> getEndpointsBuilderList() {
      return getEndpointsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Endpoint,
            com.google.api.Endpoint.Builder,
            com.google.api.EndpointOrBuilder>
        getEndpointsFieldBuilder() {
      if (endpointsBuilder_ == null) {
        endpointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Endpoint,
                com.google.api.Endpoint.Builder,
                com.google.api.EndpointOrBuilder>(
                endpoints_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        endpoints_ = null;
      }
      return endpointsBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Control control_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Control, com.google.api.Control.Builder, com.google.api.ControlOrBuilder>
        controlBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     *
     * @return Whether the control field is set.
     */
    public boolean hasControl() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     *
     * @return The control.
     */
    public com.couchbase.client.core.deps.com.google.api.Control getControl() {
      if (controlBuilder_ == null) {
        return control_ == null ? com.google.api.Control.getDefaultInstance() : control_;
      } else {
        return controlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public Builder setControl(com.couchbase.client.core.deps.com.google.api.Control value) {
      if (controlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        control_ = value;
      } else {
        controlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public Builder setControl(com.couchbase.client.core.deps.com.google.api.Control.Builder builderForValue) {
      if (controlBuilder_ == null) {
        control_ = builderForValue.build();
      } else {
        controlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public Builder mergeControl(com.couchbase.client.core.deps.com.google.api.Control value) {
      if (controlBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && control_ != null
            && control_ != com.google.api.Control.getDefaultInstance()) {
          getControlBuilder().mergeFrom(value);
        } else {
          control_ = value;
        }
      } else {
        controlBuilder_.mergeFrom(value);
      }
      if (control_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public Builder clearControl() {
      bitField0_ = (bitField0_ & ~0x00008000);
      control_ = null;
      if (controlBuilder_ != null) {
        controlBuilder_.dispose();
        controlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Control.Builder getControlBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getControlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.ControlOrBuilder getControlOrBuilder() {
      if (controlBuilder_ != null) {
        return controlBuilder_.getMessageOrBuilder();
      } else {
        return control_ == null ? com.google.api.Control.getDefaultInstance() : control_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the service control plane.
     * </pre>
     *
     * <code>.google.api.Control control = 21;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Control, com.google.api.Control.Builder, com.google.api.ControlOrBuilder>
        getControlFieldBuilder() {
      if (controlBuilder_ == null) {
        controlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Control,
                com.google.api.Control.Builder,
                com.google.api.ControlOrBuilder>(getControl(), getParentForChildren(), isClean());
        control_ = null;
      }
      return controlBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.LogDescriptor> logs_ = java.util.Collections.emptyList();

    private void ensureLogsIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        logs_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.LogDescriptor>(logs_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LogDescriptor,
            com.google.api.LogDescriptor.Builder,
            com.google.api.LogDescriptorOrBuilder>
        logsBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.LogDescriptor> getLogsList() {
      if (logsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(logs_);
      } else {
        return logsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public int getLogsCount() {
      if (logsBuilder_ == null) {
        return logs_.size();
      } else {
        return logsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LogDescriptor getLogs(int index) {
      if (logsBuilder_ == null) {
        return logs_.get(index);
      } else {
        return logsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder setLogs(int index, com.google.api.LogDescriptor value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.set(index, value);
        onChanged();
      } else {
        logsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder setLogs(int index, com.google.api.LogDescriptor.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.set(index, builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder addLogs(com.couchbase.client.core.deps.com.google.api.LogDescriptor value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.add(value);
        onChanged();
      } else {
        logsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder addLogs(int index, com.google.api.LogDescriptor value) {
      if (logsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.add(index, value);
        onChanged();
      } else {
        logsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder addLogs(com.couchbase.client.core.deps.com.google.api.LogDescriptor.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.add(builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder addLogs(int index, com.google.api.LogDescriptor.Builder builderForValue) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.add(index, builderForValue.build());
        onChanged();
      } else {
        logsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder addAllLogs(java.lang.Iterable<? extends com.google.api.LogDescriptor> values) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, logs_);
        onChanged();
      } else {
        logsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder clearLogs() {
      if (logsBuilder_ == null) {
        logs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        logsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public Builder removeLogs(int index) {
      if (logsBuilder_ == null) {
        ensureLogsIsMutable();
        logs_.remove(index);
        onChanged();
      } else {
        logsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LogDescriptor.Builder getLogsBuilder(int index) {
      return getLogsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LogDescriptorOrBuilder getLogsOrBuilder(int index) {
      if (logsBuilder_ == null) {
        return logs_.get(index);
      } else {
        return logsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public java.util.List<? extends com.google.api.LogDescriptorOrBuilder> getLogsOrBuilderList() {
      if (logsBuilder_ != null) {
        return logsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(logs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LogDescriptor.Builder addLogsBuilder() {
      return getLogsFieldBuilder().addBuilder(com.couchbase.client.core.deps.com.google.api.LogDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LogDescriptor.Builder addLogsBuilder(int index) {
      return getLogsFieldBuilder()
          .addBuilder(index, com.google.api.LogDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the logs used by this service.
     * </pre>
     *
     * <code>repeated .google.api.LogDescriptor logs = 23;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.LogDescriptor.Builder> getLogsBuilderList() {
      return getLogsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.LogDescriptor,
            com.google.api.LogDescriptor.Builder,
            com.google.api.LogDescriptorOrBuilder>
        getLogsFieldBuilder() {
      if (logsBuilder_ == null) {
        logsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.LogDescriptor,
                com.google.api.LogDescriptor.Builder,
                com.google.api.LogDescriptorOrBuilder>(
                logs_, ((bitField0_ & 0x00010000) != 0), getParentForChildren(), isClean());
        logs_ = null;
      }
      return logsBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.MetricDescriptor> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00020000) != 0)) {
        metrics_ = new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.MetricDescriptor>(metrics_);
        bitField0_ |= 0x00020000;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MetricDescriptor> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder setMetrics(int index, com.google.api.MetricDescriptor value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder setMetrics(int index, com.google.api.MetricDescriptor.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder addMetrics(com.couchbase.client.core.deps.com.google.api.MetricDescriptor value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder addMetrics(int index, com.google.api.MetricDescriptor value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder addMetrics(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder addMetrics(int index, com.google.api.MetricDescriptor.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.api.MetricDescriptor> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00020000);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptorOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public java.util.List<? extends com.google.api.MetricDescriptorOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.couchbase.client.core.deps.com.google.api.MetricDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MetricDescriptor.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.api.MetricDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the metrics used by this service.
     * </pre>
     *
     * <code>repeated .google.api.MetricDescriptor metrics = 24;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MetricDescriptor.Builder> getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MetricDescriptor,
                com.google.api.MetricDescriptor.Builder,
                com.google.api.MetricDescriptorOrBuilder>(
                metrics_, ((bitField0_ & 0x00020000) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor> monitoredResources_ =
        java.util.Collections.emptyList();

    private void ensureMonitoredResourcesIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        monitoredResources_ =
            new java.util.ArrayList<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor>(
                monitoredResources_);
        bitField0_ |= 0x00040000;
      }
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MonitoredResourceDescriptor,
            com.google.api.MonitoredResourceDescriptor.Builder,
            com.google.api.MonitoredResourceDescriptorOrBuilder>
        monitoredResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor> getMonitoredResourcesList() {
      if (monitoredResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(monitoredResources_);
      } else {
        return monitoredResourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public int getMonitoredResourcesCount() {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.size();
      } else {
        return monitoredResourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor getMonitoredResources(int index) {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.get(index);
      } else {
        return monitoredResourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder setMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.set(index, value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder setMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(index, value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addAllMonitoredResources(
        java.lang.Iterable<? extends com.google.api.MonitoredResourceDescriptor> values) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoredResources_);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder clearMonitoredResources() {
      if (monitoredResourcesBuilder_ == null) {
        monitoredResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00040000);
        onChanged();
      } else {
        monitoredResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder removeMonitoredResources(int index) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.remove(index);
        onChanged();
      } else {
        monitoredResourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor.Builder getMonitoredResourcesBuilder(
        int index) {
      return getMonitoredResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptorOrBuilder getMonitoredResourcesOrBuilder(
        int index) {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.get(index);
      } else {
        return monitoredResourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<? extends com.google.api.MonitoredResourceDescriptorOrBuilder>
        getMonitoredResourcesOrBuilderList() {
      if (monitoredResourcesBuilder_ != null) {
        return monitoredResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(monitoredResources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor.Builder addMonitoredResourcesBuilder() {
      return getMonitoredResourcesFieldBuilder()
          .addBuilder(com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor.Builder addMonitoredResourcesBuilder(
        int index) {
      return getMonitoredResourcesFieldBuilder()
          .addBuilder(index, com.google.api.MonitoredResourceDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and
     * [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<com.couchbase.client.core.deps.com.google.api.MonitoredResourceDescriptor.Builder>
        getMonitoredResourcesBuilderList() {
      return getMonitoredResourcesFieldBuilder().getBuilderList();
    }

    private com.couchbase.client.core.deps.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MonitoredResourceDescriptor,
            com.google.api.MonitoredResourceDescriptor.Builder,
            com.google.api.MonitoredResourceDescriptorOrBuilder>
        getMonitoredResourcesFieldBuilder() {
      if (monitoredResourcesBuilder_ == null) {
        monitoredResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MonitoredResourceDescriptor,
                com.google.api.MonitoredResourceDescriptor.Builder,
                com.google.api.MonitoredResourceDescriptorOrBuilder>(
                monitoredResources_,
                ((bitField0_ & 0x00040000) != 0),
                getParentForChildren(),
                isClean());
        monitoredResources_ = null;
      }
      return monitoredResourcesBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Billing billing_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Billing, com.google.api.Billing.Builder, com.google.api.BillingOrBuilder>
        billingBuilder_;
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     *
     * @return Whether the billing field is set.
     */
    public boolean hasBilling() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     *
     * @return The billing.
     */
    public com.couchbase.client.core.deps.com.google.api.Billing getBilling() {
      if (billingBuilder_ == null) {
        return billing_ == null ? com.google.api.Billing.getDefaultInstance() : billing_;
      } else {
        return billingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public Builder setBilling(com.couchbase.client.core.deps.com.google.api.Billing value) {
      if (billingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        billing_ = value;
      } else {
        billingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public Builder setBilling(com.couchbase.client.core.deps.com.google.api.Billing.Builder builderForValue) {
      if (billingBuilder_ == null) {
        billing_ = builderForValue.build();
      } else {
        billingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public Builder mergeBilling(com.couchbase.client.core.deps.com.google.api.Billing value) {
      if (billingBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && billing_ != null
            && billing_ != com.google.api.Billing.getDefaultInstance()) {
          getBillingBuilder().mergeFrom(value);
        } else {
          billing_ = value;
        }
      } else {
        billingBuilder_.mergeFrom(value);
      }
      if (billing_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public Builder clearBilling() {
      bitField0_ = (bitField0_ & ~0x00080000);
      billing_ = null;
      if (billingBuilder_ != null) {
        billingBuilder_.dispose();
        billingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Billing.Builder getBillingBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getBillingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.BillingOrBuilder getBillingOrBuilder() {
      if (billingBuilder_ != null) {
        return billingBuilder_.getMessageOrBuilder();
      } else {
        return billing_ == null ? com.google.api.Billing.getDefaultInstance() : billing_;
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configuration.
     * </pre>
     *
     * <code>.google.api.Billing billing = 26;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Billing, com.google.api.Billing.Builder, com.google.api.BillingOrBuilder>
        getBillingFieldBuilder() {
      if (billingBuilder_ == null) {
        billingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Billing,
                com.google.api.Billing.Builder,
                com.google.api.BillingOrBuilder>(getBilling(), getParentForChildren(), isClean());
        billing_ = null;
      }
      return billingBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Logging logging_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Logging, com.google.api.Logging.Builder, com.google.api.LoggingOrBuilder>
        loggingBuilder_;
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     *
     * @return Whether the logging field is set.
     */
    public boolean hasLogging() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     *
     * @return The logging.
     */
    public com.couchbase.client.core.deps.com.google.api.Logging getLogging() {
      if (loggingBuilder_ == null) {
        return logging_ == null ? com.google.api.Logging.getDefaultInstance() : logging_;
      } else {
        return loggingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public Builder setLogging(com.couchbase.client.core.deps.com.google.api.Logging value) {
      if (loggingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logging_ = value;
      } else {
        loggingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public Builder setLogging(com.couchbase.client.core.deps.com.google.api.Logging.Builder builderForValue) {
      if (loggingBuilder_ == null) {
        logging_ = builderForValue.build();
      } else {
        loggingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public Builder mergeLogging(com.couchbase.client.core.deps.com.google.api.Logging value) {
      if (loggingBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && logging_ != null
            && logging_ != com.google.api.Logging.getDefaultInstance()) {
          getLoggingBuilder().mergeFrom(value);
        } else {
          logging_ = value;
        }
      } else {
        loggingBuilder_.mergeFrom(value);
      }
      if (logging_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public Builder clearLogging() {
      bitField0_ = (bitField0_ & ~0x00100000);
      logging_ = null;
      if (loggingBuilder_ != null) {
        loggingBuilder_.dispose();
        loggingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Logging.Builder getLoggingBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getLoggingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.LoggingOrBuilder getLoggingOrBuilder() {
      if (loggingBuilder_ != null) {
        return loggingBuilder_.getMessageOrBuilder();
      } else {
        return logging_ == null ? com.google.api.Logging.getDefaultInstance() : logging_;
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.api.Logging logging = 27;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Logging, com.google.api.Logging.Builder, com.google.api.LoggingOrBuilder>
        getLoggingFieldBuilder() {
      if (loggingBuilder_ == null) {
        loggingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Logging,
                com.google.api.Logging.Builder,
                com.google.api.LoggingOrBuilder>(getLogging(), getParentForChildren(), isClean());
        logging_ = null;
      }
      return loggingBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Monitoring monitoring_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Monitoring,
            com.google.api.Monitoring.Builder,
            com.google.api.MonitoringOrBuilder>
        monitoringBuilder_;
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     *
     * @return Whether the monitoring field is set.
     */
    public boolean hasMonitoring() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     *
     * @return The monitoring.
     */
    public com.couchbase.client.core.deps.com.google.api.Monitoring getMonitoring() {
      if (monitoringBuilder_ == null) {
        return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
      } else {
        return monitoringBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder setMonitoring(com.couchbase.client.core.deps.com.google.api.Monitoring value) {
      if (monitoringBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoring_ = value;
      } else {
        monitoringBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder setMonitoring(com.couchbase.client.core.deps.com.google.api.Monitoring.Builder builderForValue) {
      if (monitoringBuilder_ == null) {
        monitoring_ = builderForValue.build();
      } else {
        monitoringBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder mergeMonitoring(com.couchbase.client.core.deps.com.google.api.Monitoring value) {
      if (monitoringBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && monitoring_ != null
            && monitoring_ != com.google.api.Monitoring.getDefaultInstance()) {
          getMonitoringBuilder().mergeFrom(value);
        } else {
          monitoring_ = value;
        }
      } else {
        monitoringBuilder_.mergeFrom(value);
      }
      if (monitoring_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder clearMonitoring() {
      bitField0_ = (bitField0_ & ~0x00200000);
      monitoring_ = null;
      if (monitoringBuilder_ != null) {
        monitoringBuilder_.dispose();
        monitoringBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Monitoring.Builder getMonitoringBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getMonitoringFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.MonitoringOrBuilder getMonitoringOrBuilder() {
      if (monitoringBuilder_ != null) {
        return monitoringBuilder_.getMessageOrBuilder();
      } else {
        return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Monitoring,
            com.google.api.Monitoring.Builder,
            com.google.api.MonitoringOrBuilder>
        getMonitoringFieldBuilder() {
      if (monitoringBuilder_ == null) {
        monitoringBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Monitoring,
                com.google.api.Monitoring.Builder,
                com.google.api.MonitoringOrBuilder>(
                getMonitoring(), getParentForChildren(), isClean());
        monitoring_ = null;
      }
      return monitoringBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.SystemParameters systemParameters_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.SystemParameters,
            com.google.api.SystemParameters.Builder,
            com.google.api.SystemParametersOrBuilder>
        systemParametersBuilder_;
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     *
     * @return Whether the systemParameters field is set.
     */
    public boolean hasSystemParameters() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     *
     * @return The systemParameters.
     */
    public com.couchbase.client.core.deps.com.google.api.SystemParameters getSystemParameters() {
      if (systemParametersBuilder_ == null) {
        return systemParameters_ == null
            ? com.google.api.SystemParameters.getDefaultInstance()
            : systemParameters_;
      } else {
        return systemParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public Builder setSystemParameters(com.couchbase.client.core.deps.com.google.api.SystemParameters value) {
      if (systemParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemParameters_ = value;
      } else {
        systemParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public Builder setSystemParameters(com.couchbase.client.core.deps.com.google.api.SystemParameters.Builder builderForValue) {
      if (systemParametersBuilder_ == null) {
        systemParameters_ = builderForValue.build();
      } else {
        systemParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public Builder mergeSystemParameters(com.couchbase.client.core.deps.com.google.api.SystemParameters value) {
      if (systemParametersBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && systemParameters_ != null
            && systemParameters_ != com.google.api.SystemParameters.getDefaultInstance()) {
          getSystemParametersBuilder().mergeFrom(value);
        } else {
          systemParameters_ = value;
        }
      } else {
        systemParametersBuilder_.mergeFrom(value);
      }
      if (systemParameters_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public Builder clearSystemParameters() {
      bitField0_ = (bitField0_ & ~0x00400000);
      systemParameters_ = null;
      if (systemParametersBuilder_ != null) {
        systemParametersBuilder_.dispose();
        systemParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.SystemParameters.Builder getSystemParametersBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getSystemParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.SystemParametersOrBuilder getSystemParametersOrBuilder() {
      if (systemParametersBuilder_ != null) {
        return systemParametersBuilder_.getMessageOrBuilder();
      } else {
        return systemParameters_ == null
            ? com.google.api.SystemParameters.getDefaultInstance()
            : systemParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * System parameter configuration.
     * </pre>
     *
     * <code>.google.api.SystemParameters system_parameters = 29;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.SystemParameters,
            com.google.api.SystemParameters.Builder,
            com.google.api.SystemParametersOrBuilder>
        getSystemParametersFieldBuilder() {
      if (systemParametersBuilder_ == null) {
        systemParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.SystemParameters,
                com.google.api.SystemParameters.Builder,
                com.google.api.SystemParametersOrBuilder>(
                getSystemParameters(), getParentForChildren(), isClean());
        systemParameters_ = null;
      }
      return systemParametersBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.SourceInfo sourceInfo_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.SourceInfo,
            com.google.api.SourceInfo.Builder,
            com.google.api.SourceInfoOrBuilder>
        sourceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     *
     * @return Whether the sourceInfo field is set.
     */
    public boolean hasSourceInfo() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     *
     * @return The sourceInfo.
     */
    public com.couchbase.client.core.deps.com.google.api.SourceInfo getSourceInfo() {
      if (sourceInfoBuilder_ == null) {
        return sourceInfo_ == null ? com.google.api.SourceInfo.getDefaultInstance() : sourceInfo_;
      } else {
        return sourceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public Builder setSourceInfo(com.couchbase.client.core.deps.com.google.api.SourceInfo value) {
      if (sourceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInfo_ = value;
      } else {
        sourceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public Builder setSourceInfo(com.couchbase.client.core.deps.com.google.api.SourceInfo.Builder builderForValue) {
      if (sourceInfoBuilder_ == null) {
        sourceInfo_ = builderForValue.build();
      } else {
        sourceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public Builder mergeSourceInfo(com.couchbase.client.core.deps.com.google.api.SourceInfo value) {
      if (sourceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && sourceInfo_ != null
            && sourceInfo_ != com.google.api.SourceInfo.getDefaultInstance()) {
          getSourceInfoBuilder().mergeFrom(value);
        } else {
          sourceInfo_ = value;
        }
      } else {
        sourceInfoBuilder_.mergeFrom(value);
      }
      if (sourceInfo_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public Builder clearSourceInfo() {
      bitField0_ = (bitField0_ & ~0x00800000);
      sourceInfo_ = null;
      if (sourceInfoBuilder_ != null) {
        sourceInfoBuilder_.dispose();
        sourceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.SourceInfo.Builder getSourceInfoBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getSourceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.SourceInfoOrBuilder getSourceInfoOrBuilder() {
      if (sourceInfoBuilder_ != null) {
        return sourceInfoBuilder_.getMessageOrBuilder();
      } else {
        return sourceInfo_ == null ? com.google.api.SourceInfo.getDefaultInstance() : sourceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source information for this configuration if available.
     * </pre>
     *
     * <code>.google.api.SourceInfo source_info = 37;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.SourceInfo,
            com.google.api.SourceInfo.Builder,
            com.google.api.SourceInfoOrBuilder>
        getSourceInfoFieldBuilder() {
      if (sourceInfoBuilder_ == null) {
        sourceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.SourceInfo,
                com.google.api.SourceInfo.Builder,
                com.google.api.SourceInfoOrBuilder>(
                getSourceInfo(), getParentForChildren(), isClean());
        sourceInfo_ = null;
      }
      return sourceInfoBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.api.Publishing publishing_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Publishing,
            com.google.api.Publishing.Builder,
            com.google.api.PublishingOrBuilder>
        publishingBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     *
     * @return Whether the publishing field is set.
     */
    public boolean hasPublishing() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     *
     * @return The publishing.
     */
    public com.couchbase.client.core.deps.com.google.api.Publishing getPublishing() {
      if (publishingBuilder_ == null) {
        return publishing_ == null ? com.google.api.Publishing.getDefaultInstance() : publishing_;
      } else {
        return publishingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public Builder setPublishing(com.couchbase.client.core.deps.com.google.api.Publishing value) {
      if (publishingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publishing_ = value;
      } else {
        publishingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public Builder setPublishing(com.couchbase.client.core.deps.com.google.api.Publishing.Builder builderForValue) {
      if (publishingBuilder_ == null) {
        publishing_ = builderForValue.build();
      } else {
        publishingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public Builder mergePublishing(com.couchbase.client.core.deps.com.google.api.Publishing value) {
      if (publishingBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && publishing_ != null
            && publishing_ != com.google.api.Publishing.getDefaultInstance()) {
          getPublishingBuilder().mergeFrom(value);
        } else {
          publishing_ = value;
        }
      } else {
        publishingBuilder_.mergeFrom(value);
      }
      if (publishing_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public Builder clearPublishing() {
      bitField0_ = (bitField0_ & ~0x01000000);
      publishing_ = null;
      if (publishingBuilder_ != null) {
        publishingBuilder_.dispose();
        publishingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.Publishing.Builder getPublishingBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getPublishingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    public com.couchbase.client.core.deps.com.google.api.PublishingOrBuilder getPublishingOrBuilder() {
      if (publishingBuilder_ != null) {
        return publishingBuilder_.getMessageOrBuilder();
      } else {
        return publishing_ == null ? com.google.api.Publishing.getDefaultInstance() : publishing_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for [Google Cloud Client
     * libraries](https://cloud.google.com/apis/docs/cloud-client-libraries)
     * generated from APIs defined as protocol buffers.
     * </pre>
     *
     * <code>.google.api.Publishing publishing = 45;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Publishing,
            com.google.api.Publishing.Builder,
            com.google.api.PublishingOrBuilder>
        getPublishingFieldBuilder() {
      if (publishingBuilder_ == null) {
        publishingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Publishing,
                com.google.api.Publishing.Builder,
                com.google.api.PublishingOrBuilder>(
                getPublishing(), getParentForChildren(), isClean());
        publishing_ = null;
      }
      return publishingBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.UInt32Value configVersion_;
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value,
            com.google.protobuf.UInt32Value.Builder,
            com.google.protobuf.UInt32ValueOrBuilder>
        configVersionBuilder_;
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     *
     * @return Whether the configVersion field is set.
     */
    public boolean hasConfigVersion() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     *
     * @return The configVersion.
     */
    public com.couchbase.client.core.deps.com.google.protobuf.UInt32Value getConfigVersion() {
      if (configVersionBuilder_ == null) {
        return configVersion_ == null
            ? com.google.protobuf.UInt32Value.getDefaultInstance()
            : configVersion_;
      } else {
        return configVersionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public Builder setConfigVersion(com.couchbase.client.core.deps.com.google.protobuf.UInt32Value value) {
      if (configVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configVersion_ = value;
      } else {
        configVersionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public Builder setConfigVersion(com.couchbase.client.core.deps.com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (configVersionBuilder_ == null) {
        configVersion_ = builderForValue.build();
      } else {
        configVersionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public Builder mergeConfigVersion(com.couchbase.client.core.deps.com.google.protobuf.UInt32Value value) {
      if (configVersionBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && configVersion_ != null
            && configVersion_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
          getConfigVersionBuilder().mergeFrom(value);
        } else {
          configVersion_ = value;
        }
      } else {
        configVersionBuilder_.mergeFrom(value);
      }
      if (configVersion_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public Builder clearConfigVersion() {
      bitField0_ = (bitField0_ & ~0x02000000);
      configVersion_ = null;
      if (configVersionBuilder_ != null) {
        configVersionBuilder_.dispose();
        configVersionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.UInt32Value.Builder getConfigVersionBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getConfigVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.UInt32ValueOrBuilder getConfigVersionOrBuilder() {
      if (configVersionBuilder_ != null) {
        return configVersionBuilder_.getMessageOrBuilder();
      } else {
        return configVersion_ == null
            ? com.google.protobuf.UInt32Value.getDefaultInstance()
            : configVersion_;
      }
    }
    /**
     *
     *
     * <pre>
     * Obsolete. Do not use.
     *
     * This field has no semantic meaning. The service config compiler always
     * sets this field to `3`.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value config_version = 20;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value,
            com.google.protobuf.UInt32Value.Builder,
            com.google.protobuf.UInt32ValueOrBuilder>
        getConfigVersionFieldBuilder() {
      if (configVersionBuilder_ == null) {
        configVersionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.UInt32Value,
                com.google.protobuf.UInt32Value.Builder,
                com.google.protobuf.UInt32ValueOrBuilder>(
                getConfigVersion(), getParentForChildren(), isClean());
        configVersion_ = null;
      }
      return configVersionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Service)
  }

  // @@protoc_insertion_point(class_scope:google.api.Service)
  private static final com.couchbase.client.core.deps.com.google.api.Service DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Service();
  }

  public static com.couchbase.client.core.deps.com.google.api.Service getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<Service> PARSER =
      new com.google.protobuf.AbstractParser<Service>() {
        @java.lang.Override
        public Service parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.couchbase.client.core.deps.com.google.protobuf.Parser<Service> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Parser<Service> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.api.Service getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
