/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.couchbase.client.core.deps.com.google.apps.card.v1;

public interface TextInputOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.apps.card.v1.TextInput)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name by which the text input is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name by which the text input is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The text that appears above the text input field in the user interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if you are asking someone's name, but specifically need their
   * surname, write `surname` instead of `name`.
   *
   * Required if `hintText` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  java.lang.String getLabel();
  /**
   *
   *
   * <pre>
   * The text that appears above the text input field in the user interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if you are asking someone's name, but specifically need their
   * surname, write `surname` instead of `name`.
   *
   * Required if `hintText` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  com.google.protobuf.ByteString getLabelBytes();

  /**
   *
   *
   * <pre>
   * Text that appears below the text input field meant to assist users by
   * prompting them to enter a certain value. This text is always visible.
   *
   * Required if `label` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string hint_text = 3;</code>
   *
   * @return The hintText.
   */
  java.lang.String getHintText();
  /**
   *
   *
   * <pre>
   * Text that appears below the text input field meant to assist users by
   * prompting them to enter a certain value. This text is always visible.
   *
   * Required if `label` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string hint_text = 3;</code>
   *
   * @return The bytes for hintText.
   */
  com.google.protobuf.ByteString getHintTextBytes();

  /**
   *
   *
   * <pre>
   * The value entered by a user, returned as part of a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string value = 4;</code>
   *
   * @return The value.
   */
  java.lang.String getValue();
  /**
   *
   *
   * <pre>
   * The value entered by a user, returned as part of a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string value = 4;</code>
   *
   * @return The bytes for value.
   */
  com.google.protobuf.ByteString getValueBytes();

  /**
   *
   *
   * <pre>
   * How a text input field appears in the user interface.
   * For example, whether the field is single or multi-line.
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  int getTypeValue();
  /**
   *
   *
   * <pre>
   * How a text input field appears in the user interface.
   * For example, whether the field is single or multi-line.
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
   *
   * @return The type.
   */
  com.google.apps.card.v1.TextInput.Type getType();

  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return Whether the onChangeAction field is set.
   */
  boolean hasOnChangeAction();
  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return The onChangeAction.
   */
  com.google.apps.card.v1.Action getOnChangeAction();
  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   */
  com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder();

  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   *
   * @return Whether the initialSuggestions field is set.
   */
  boolean hasInitialSuggestions();
  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   *
   * @return The initialSuggestions.
   */
  com.google.apps.card.v1.Suggestions getInitialSuggestions();
  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   */
  com.google.apps.card.v1.SuggestionsOrBuilder getInitialSuggestionsOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   *
   * @return Whether the autoCompleteAction field is set.
   */
  boolean hasAutoCompleteAction();
  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   *
   * @return The autoCompleteAction.
   */
  com.google.apps.card.v1.Action getAutoCompleteAction();
  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   */
  com.google.apps.card.v1.ActionOrBuilder getAutoCompleteActionOrBuilder();

  /**
   *
   *
   * <pre>
   * Text that appears in the text input field when the field is empty.
   * Use this text to prompt users to enter a value. For example, `Enter a
   * number from 0 to 100`.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>string placeholder_text = 12;</code>
   *
   * @return The placeholderText.
   */
  java.lang.String getPlaceholderText();
  /**
   *
   *
   * <pre>
   * Text that appears in the text input field when the field is empty.
   * Use this text to prompt users to enter a value. For example, `Enter a
   * number from 0 to 100`.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>string placeholder_text = 12;</code>
   *
   * @return The bytes for placeholderText.
   */
  com.google.protobuf.ByteString getPlaceholderTextBytes();
}
