/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.couchbase.client.core.deps.com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * Each card is made up of widgets.
 *
 * A widget is a composite object that can represent one of text, images,
 * buttons, and other object types.
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Widget}
 */
public final class Widget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Widget)
    WidgetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Widget.newBuilder() to construct.
  private Widget(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Widget() {
    horizontalAlignment_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Widget();
  }

  public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Widget_descriptor;
  }

  @java.lang.Override
  protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Widget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Widget.class, com.google.apps.card.v1.Widget.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The shape used to crop the image.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Widget.ImageType}
   */
  public enum ImageType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. Applies a square mask to the image. For example, a 4x3
     * image becomes 3x3.
     * </pre>
     *
     * <code>SQUARE = 0;</code>
     */
    SQUARE(0),
    /**
     *
     *
     * <pre>
     * Applies a circular mask to the image. For example, a 4x3 image becomes a
     * circle with a diameter of 3.
     * </pre>
     *
     * <code>CIRCLE = 1;</code>
     */
    CIRCLE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. Applies a square mask to the image. For example, a 4x3
     * image becomes 3x3.
     * </pre>
     *
     * <code>SQUARE = 0;</code>
     */
    public static final int SQUARE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Applies a circular mask to the image. For example, a 4x3 image becomes a
     * circle with a diameter of 3.
     * </pre>
     *
     * <code>CIRCLE = 1;</code>
     */
    public static final int CIRCLE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImageType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImageType forNumber(int value) {
      switch (value) {
        case 0:
          return SQUARE;
        case 1:
          return CIRCLE;
        default:
          return null;
      }
    }

    public static com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<ImageType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<ImageType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImageType>() {
          public ImageType findValueByNumber(int number) {
            return ImageType.forNumber(number);
          }
        };

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Widget.getDescriptor().getEnumTypes().get(0);
    }

    private static final ImageType[] VALUES = values();

    public static ImageType valueOf(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImageType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Widget.ImageType)
  }

  /**
   *
   *
   * <pre>
   * Specifies whether widgets align to the left, right, or center of a column.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Widget.HorizontalAlignment}
   */
  public enum HorizontalAlignment implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0;</code>
     */
    HORIZONTAL_ALIGNMENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Default value. Aligns widgets to the start position of the column. For
     * left-to-right layouts, aligns to the left. For right-to-left layouts,
     * aligns to the right.
     * </pre>
     *
     * <code>START = 1;</code>
     */
    START(1),
    /**
     *
     *
     * <pre>
     * Aligns widgets to the center of the column.
     * </pre>
     *
     * <code>CENTER = 2;</code>
     */
    CENTER(2),
    /**
     *
     *
     * <pre>
     * Aligns widgets to the end position of the column. For left-to-right
     * layouts, aligns widgets to the right. For right-to-left layouts, aligns
     * widgets to the left.
     * </pre>
     *
     * <code>END = 3;</code>
     */
    END(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0;</code>
     */
    public static final int HORIZONTAL_ALIGNMENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value. Aligns widgets to the start position of the column. For
     * left-to-right layouts, aligns to the left. For right-to-left layouts,
     * aligns to the right.
     * </pre>
     *
     * <code>START = 1;</code>
     */
    public static final int START_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Aligns widgets to the center of the column.
     * </pre>
     *
     * <code>CENTER = 2;</code>
     */
    public static final int CENTER_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Aligns widgets to the end position of the column. For left-to-right
     * layouts, aligns widgets to the right. For right-to-left layouts, aligns
     * widgets to the left.
     * </pre>
     *
     * <code>END = 3;</code>
     */
    public static final int END_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HorizontalAlignment valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HorizontalAlignment forNumber(int value) {
      switch (value) {
        case 0:
          return HORIZONTAL_ALIGNMENT_UNSPECIFIED;
        case 1:
          return START;
        case 2:
          return CENTER;
        case 3:
          return END;
        default:
          return null;
      }
    }

    public static com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<HorizontalAlignment>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.couchbase.client.core.deps.com.google.protobuf.Internal.EnumLiteMap<HorizontalAlignment>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<HorizontalAlignment>() {
              public HorizontalAlignment findValueByNumber(int number) {
                return HorizontalAlignment.forNumber(number);
              }
            };

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Widget.getDescriptor().getEnumTypes().get(1);
    }

    private static final HorizontalAlignment[] VALUES = values();

    public static HorizontalAlignment valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HorizontalAlignment(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Widget.HorizontalAlignment)
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_PARAGRAPH(1),
    IMAGE(2),
    DECORATED_TEXT(3),
    BUTTON_LIST(4),
    TEXT_INPUT(5),
    SELECTION_INPUT(6),
    DATE_TIME_PICKER(7),
    DIVIDER(9),
    GRID(10),
    COLUMNS(11),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT_PARAGRAPH;
        case 2:
          return IMAGE;
        case 3:
          return DECORATED_TEXT;
        case 4:
          return BUTTON_LIST;
        case 5:
          return TEXT_INPUT;
        case 6:
          return SELECTION_INPUT;
        case 7:
          return DATE_TIME_PICKER;
        case 9:
          return DIVIDER;
        case 10:
          return GRID;
        case 11:
          return COLUMNS;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int TEXT_PARAGRAPH_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Displays a text paragraph. Supports simple HTML formatted text. For more
   * information about formatting text, see
   * [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
   * and
   * [Formatting
   * text in Google Workspace
   * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   *
   * For example, the following JSON creates a bolded text:
   * ```
   * "textParagraph": {
   *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
   *
   * @return Whether the textParagraph field is set.
   */
  @java.lang.Override
  public boolean hasTextParagraph() {
    return dataCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Displays a text paragraph. Supports simple HTML formatted text. For more
   * information about formatting text, see
   * [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
   * and
   * [Formatting
   * text in Google Workspace
   * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   *
   * For example, the following JSON creates a bolded text:
   * ```
   * "textParagraph": {
   *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
   *
   * @return The textParagraph.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph getTextParagraph() {
    if (dataCase_ == 1) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_;
    }
    return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a text paragraph. Supports simple HTML formatted text. For more
   * information about formatting text, see
   * [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
   * and
   * [Formatting
   * text in Google Workspace
   * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   *
   * For example, the following JSON creates a bolded text:
   * ```
   * "textParagraph": {
   *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraphOrBuilder getTextParagraphOrBuilder() {
    if (dataCase_ == 1) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_;
    }
    return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
  }

  public static final int IMAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Displays an image.
   *
   * For example, the following JSON creates an image with alternative text:
   * ```
   * "image": {
   *   "imageUrl":
   *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
   *   "altText": "Chat app avatar"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Image image = 2;</code>
   *
   * @return Whether the image field is set.
   */
  @java.lang.Override
  public boolean hasImage() {
    return dataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Displays an image.
   *
   * For example, the following JSON creates an image with alternative text:
   * ```
   * "image": {
   *   "imageUrl":
   *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
   *   "altText": "Chat app avatar"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Image image = 2;</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Image getImage() {
    if (dataCase_ == 2) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_;
    }
    return com.google.apps.card.v1.Image.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays an image.
   *
   * For example, the following JSON creates an image with alternative text:
   * ```
   * "image": {
   *   "imageUrl":
   *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
   *   "altText": "Chat app avatar"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Image image = 2;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.ImageOrBuilder getImageOrBuilder() {
    if (dataCase_ == 2) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_;
    }
    return com.google.apps.card.v1.Image.getDefaultInstance();
  }

  public static final int DECORATED_TEXT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Displays a decorated text item.
   *
   * For example, the following JSON creates a decorated text widget showing
   * email address:
   *
   * ```
   * "decoratedText": {
   *   "icon": {
   *     "knownIcon": "EMAIL"
   *   },
   *   "topLabel": "Email Address",
   *   "text": "sasha&#64;example.com",
   *   "bottomLabel": "This is a new Email address!",
   *   "switchControl": {
   *     "name": "has_send_welcome_email_to_sasha",
   *     "selected": false,
   *     "controlType": "CHECKBOX"
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
   *
   * @return Whether the decoratedText field is set.
   */
  @java.lang.Override
  public boolean hasDecoratedText() {
    return dataCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Displays a decorated text item.
   *
   * For example, the following JSON creates a decorated text widget showing
   * email address:
   *
   * ```
   * "decoratedText": {
   *   "icon": {
   *     "knownIcon": "EMAIL"
   *   },
   *   "topLabel": "Email Address",
   *   "text": "sasha&#64;example.com",
   *   "bottomLabel": "This is a new Email address!",
   *   "switchControl": {
   *     "name": "has_send_welcome_email_to_sasha",
   *     "selected": false,
   *     "controlType": "CHECKBOX"
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
   *
   * @return The decoratedText.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText getDecoratedText() {
    if (dataCase_ == 3) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_;
    }
    return com.google.apps.card.v1.DecoratedText.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a decorated text item.
   *
   * For example, the following JSON creates a decorated text widget showing
   * email address:
   *
   * ```
   * "decoratedText": {
   *   "icon": {
   *     "knownIcon": "EMAIL"
   *   },
   *   "topLabel": "Email Address",
   *   "text": "sasha&#64;example.com",
   *   "bottomLabel": "This is a new Email address!",
   *   "switchControl": {
   *     "name": "has_send_welcome_email_to_sasha",
   *     "selected": false,
   *     "controlType": "CHECKBOX"
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedTextOrBuilder getDecoratedTextOrBuilder() {
    if (dataCase_ == 3) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_;
    }
    return com.google.apps.card.v1.DecoratedText.getDefaultInstance();
  }

  public static final int BUTTON_LIST_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A list of buttons.
   *
   * For example, the following JSON creates two buttons. The first
   * is a blue text button and the second is an image button that opens a
   * link:
   * ```
   * "buttonList": {
   *   "buttons": [
   *     {
   *       "text": "Edit",
   *       "color": {
   *         "red": 0,
   *         "green": 0,
   *         "blue": 1,
   *         "alpha": 1
   *       },
   *       "disabled": true,
   *     },
   *     {
   *       "icon": {
   *         "knownIcon": "INVITE",
   *         "altText": "check calendar"
   *       },
   *       "onClick": {
   *         "openLink": {
   *           "url": "https://example.com/calendar"
   *         }
   *       }
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
   *
   * @return Whether the buttonList field is set.
   */
  @java.lang.Override
  public boolean hasButtonList() {
    return dataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A list of buttons.
   *
   * For example, the following JSON creates two buttons. The first
   * is a blue text button and the second is an image button that opens a
   * link:
   * ```
   * "buttonList": {
   *   "buttons": [
   *     {
   *       "text": "Edit",
   *       "color": {
   *         "red": 0,
   *         "green": 0,
   *         "blue": 1,
   *         "alpha": 1
   *       },
   *       "disabled": true,
   *     },
   *     {
   *       "icon": {
   *         "knownIcon": "INVITE",
   *         "altText": "check calendar"
   *       },
   *       "onClick": {
   *         "openLink": {
   *           "url": "https://example.com/calendar"
   *         }
   *       }
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
   *
   * @return The buttonList.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList getButtonList() {
    if (dataCase_ == 4) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_;
    }
    return com.google.apps.card.v1.ButtonList.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of buttons.
   *
   * For example, the following JSON creates two buttons. The first
   * is a blue text button and the second is an image button that opens a
   * link:
   * ```
   * "buttonList": {
   *   "buttons": [
   *     {
   *       "text": "Edit",
   *       "color": {
   *         "red": 0,
   *         "green": 0,
   *         "blue": 1,
   *         "alpha": 1
   *       },
   *       "disabled": true,
   *     },
   *     {
   *       "icon": {
   *         "knownIcon": "INVITE",
   *         "altText": "check calendar"
   *       },
   *       "onClick": {
   *         "openLink": {
   *           "url": "https://example.com/calendar"
   *         }
   *       }
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonListOrBuilder getButtonListOrBuilder() {
    if (dataCase_ == 4) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_;
    }
    return com.google.apps.card.v1.ButtonList.getDefaultInstance();
  }

  public static final int TEXT_INPUT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Displays a text box that users can type into.
   *
   * For example, the following JSON creates a text input for an email
   * address:
   *
   * ```
   * "textInput": {
   *   "name": "mailing_address",
   *   "label": "Mailing Address"
   * }
   * ```
   *
   * As another example, the following JSON creates a text input for a
   * programming language with static suggestions:
   * ```
   * "textInput": {
   *   "name": "preferred_programing_language",
   *   "label": "Preferred Language",
   *   "initialSuggestions": {
   *     "items": [
   *       {
   *         "text": "C++"
   *       },
   *       {
   *         "text": "Java"
   *       },
   *       {
   *         "text": "JavaScript"
   *       },
   *       {
   *         "text": "Python"
   *       }
   *     ]
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
   *
   * @return Whether the textInput field is set.
   */
  @java.lang.Override
  public boolean hasTextInput() {
    return dataCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Displays a text box that users can type into.
   *
   * For example, the following JSON creates a text input for an email
   * address:
   *
   * ```
   * "textInput": {
   *   "name": "mailing_address",
   *   "label": "Mailing Address"
   * }
   * ```
   *
   * As another example, the following JSON creates a text input for a
   * programming language with static suggestions:
   * ```
   * "textInput": {
   *   "name": "preferred_programing_language",
   *   "label": "Preferred Language",
   *   "initialSuggestions": {
   *     "items": [
   *       {
   *         "text": "C++"
   *       },
   *       {
   *         "text": "Java"
   *       },
   *       {
   *         "text": "JavaScript"
   *       },
   *       {
   *         "text": "Python"
   *       }
   *     ]
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
   *
   * @return The textInput.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput getTextInput() {
    if (dataCase_ == 5) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_;
    }
    return com.google.apps.card.v1.TextInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a text box that users can type into.
   *
   * For example, the following JSON creates a text input for an email
   * address:
   *
   * ```
   * "textInput": {
   *   "name": "mailing_address",
   *   "label": "Mailing Address"
   * }
   * ```
   *
   * As another example, the following JSON creates a text input for a
   * programming language with static suggestions:
   * ```
   * "textInput": {
   *   "name": "preferred_programing_language",
   *   "label": "Preferred Language",
   *   "initialSuggestions": {
   *     "items": [
   *       {
   *         "text": "C++"
   *       },
   *       {
   *         "text": "Java"
   *       },
   *       {
   *         "text": "JavaScript"
   *       },
   *       {
   *         "text": "Python"
   *       }
   *     ]
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.TextInputOrBuilder getTextInputOrBuilder() {
    if (dataCase_ == 5) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_;
    }
    return com.google.apps.card.v1.TextInput.getDefaultInstance();
  }

  public static final int SELECTION_INPUT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Displays a selection control that lets users select items. Selection
   * controls can be checkboxes, radio buttons, switches, or dropdown menus.
   *
   * For example, the following JSON creates a dropdown menu that lets users
   * choose a size:
   *
   * ```
   * "selectionInput": {
   *   "name": "size",
   *   "label": "Size"
   *   "type": "DROPDOWN",
   *   "items": [
   *     {
   *       "text": "S",
   *       "value": "small",
   *       "selected": false
   *     },
   *     {
   *       "text": "M",
   *       "value": "medium",
   *       "selected": true
   *     },
   *     {
   *       "text": "L",
   *       "value": "large",
   *       "selected": false
   *     },
   *     {
   *       "text": "XL",
   *       "value": "extra_large",
   *       "selected": false
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
   *
   * @return Whether the selectionInput field is set.
   */
  @java.lang.Override
  public boolean hasSelectionInput() {
    return dataCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Displays a selection control that lets users select items. Selection
   * controls can be checkboxes, radio buttons, switches, or dropdown menus.
   *
   * For example, the following JSON creates a dropdown menu that lets users
   * choose a size:
   *
   * ```
   * "selectionInput": {
   *   "name": "size",
   *   "label": "Size"
   *   "type": "DROPDOWN",
   *   "items": [
   *     {
   *       "text": "S",
   *       "value": "small",
   *       "selected": false
   *     },
   *     {
   *       "text": "M",
   *       "value": "medium",
   *       "selected": true
   *     },
   *     {
   *       "text": "L",
   *       "value": "large",
   *       "selected": false
   *     },
   *     {
   *       "text": "XL",
   *       "value": "extra_large",
   *       "selected": false
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
   *
   * @return The selectionInput.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput getSelectionInput() {
    if (dataCase_ == 6) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_;
    }
    return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a selection control that lets users select items. Selection
   * controls can be checkboxes, radio buttons, switches, or dropdown menus.
   *
   * For example, the following JSON creates a dropdown menu that lets users
   * choose a size:
   *
   * ```
   * "selectionInput": {
   *   "name": "size",
   *   "label": "Size"
   *   "type": "DROPDOWN",
   *   "items": [
   *     {
   *       "text": "S",
   *       "value": "small",
   *       "selected": false
   *     },
   *     {
   *       "text": "M",
   *       "value": "medium",
   *       "selected": true
   *     },
   *     {
   *       "text": "L",
   *       "value": "large",
   *       "selected": false
   *     },
   *     {
   *       "text": "XL",
   *       "value": "extra_large",
   *       "selected": false
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInputOrBuilder getSelectionInputOrBuilder() {
    if (dataCase_ == 6) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_;
    }
    return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
  }

  public static final int DATE_TIME_PICKER_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Displays a widget that lets users input a date, time, or date and time.
   *
   * For example, the following JSON creates a date time picker to schedule an
   * appointment:
   *
   *
   * ```
   * "dateTimePicker": {
   *   "name": "appointment_time",
   *   "label": "Book your appointment at:",
   *   "type": "DATE_AND_TIME",
   *   "valueMsEpoch": "796435200000"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
   *
   * @return Whether the dateTimePicker field is set.
   */
  @java.lang.Override
  public boolean hasDateTimePicker() {
    return dataCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Displays a widget that lets users input a date, time, or date and time.
   *
   * For example, the following JSON creates a date time picker to schedule an
   * appointment:
   *
   *
   * ```
   * "dateTimePicker": {
   *   "name": "appointment_time",
   *   "label": "Book your appointment at:",
   *   "type": "DATE_AND_TIME",
   *   "valueMsEpoch": "796435200000"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
   *
   * @return The dateTimePicker.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker getDateTimePicker() {
    if (dataCase_ == 7) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_;
    }
    return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a widget that lets users input a date, time, or date and time.
   *
   * For example, the following JSON creates a date time picker to schedule an
   * appointment:
   *
   *
   * ```
   * "dateTimePicker": {
   *   "name": "appointment_time",
   *   "label": "Book your appointment at:",
   *   "type": "DATE_AND_TIME",
   *   "valueMsEpoch": "796435200000"
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePickerOrBuilder getDateTimePickerOrBuilder() {
    if (dataCase_ == 7) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_;
    }
    return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
  }

  public static final int DIVIDER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Displays a horizontal line divider between widgets.
   *
   * For example, the following JSON creates a divider:
   * ```
   * "divider": {
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Divider divider = 9;</code>
   *
   * @return Whether the divider field is set.
   */
  @java.lang.Override
  public boolean hasDivider() {
    return dataCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Displays a horizontal line divider between widgets.
   *
   * For example, the following JSON creates a divider:
   * ```
   * "divider": {
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Divider divider = 9;</code>
   *
   * @return The divider.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Divider getDivider() {
    if (dataCase_ == 9) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_;
    }
    return com.google.apps.card.v1.Divider.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a horizontal line divider between widgets.
   *
   * For example, the following JSON creates a divider:
   * ```
   * "divider": {
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Divider divider = 9;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.DividerOrBuilder getDividerOrBuilder() {
    if (dataCase_ == 9) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_;
    }
    return com.google.apps.card.v1.Divider.getDefaultInstance();
  }

  public static final int GRID_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Displays a grid with a collection of items.
   *
   * A grid supports any number of columns and items. The number of rows is
   * determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
   * items and 2 columns has 6 rows.
   *
   * [Google Workspace Add-ons and
   * Chat apps](https://developers.google.com/workspace/extend):
   *
   * For example, the following JSON creates a 2 column grid with a single
   * item:
   *
   * ```
   * "grid": {
   *   "title": "A fine collection of items",
   *   "columnCount": 2,
   *   "borderStyle": {
   *     "type": "STROKE",
   *     "cornerRadius": 4
   *   },
   *   "items": [
   *     {
   *       "image": {
   *         "imageUri": "https://www.example.com/image.png",
   *         "cropStyle": {
   *           "type": "SQUARE"
   *         },
   *         "borderStyle": {
   *           "type": "STROKE"
   *         }
   *       },
   *       "title": "An item",
   *       "textAlignment": "CENTER"
   *     }
   *   ],
   *   "onClick": {
   *     "openLink": {
   *       "url": "https://www.example.com"
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Grid grid = 10;</code>
   *
   * @return Whether the grid field is set.
   */
  @java.lang.Override
  public boolean hasGrid() {
    return dataCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Displays a grid with a collection of items.
   *
   * A grid supports any number of columns and items. The number of rows is
   * determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
   * items and 2 columns has 6 rows.
   *
   * [Google Workspace Add-ons and
   * Chat apps](https://developers.google.com/workspace/extend):
   *
   * For example, the following JSON creates a 2 column grid with a single
   * item:
   *
   * ```
   * "grid": {
   *   "title": "A fine collection of items",
   *   "columnCount": 2,
   *   "borderStyle": {
   *     "type": "STROKE",
   *     "cornerRadius": 4
   *   },
   *   "items": [
   *     {
   *       "image": {
   *         "imageUri": "https://www.example.com/image.png",
   *         "cropStyle": {
   *           "type": "SQUARE"
   *         },
   *         "borderStyle": {
   *           "type": "STROKE"
   *         }
   *       },
   *       "title": "An item",
   *       "textAlignment": "CENTER"
   *     }
   *   ],
   *   "onClick": {
   *     "openLink": {
   *       "url": "https://www.example.com"
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Grid grid = 10;</code>
   *
   * @return The grid.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Grid getGrid() {
    if (dataCase_ == 10) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_;
    }
    return com.google.apps.card.v1.Grid.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays a grid with a collection of items.
   *
   * A grid supports any number of columns and items. The number of rows is
   * determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
   * items and 2 columns has 6 rows.
   *
   * [Google Workspace Add-ons and
   * Chat apps](https://developers.google.com/workspace/extend):
   *
   * For example, the following JSON creates a 2 column grid with a single
   * item:
   *
   * ```
   * "grid": {
   *   "title": "A fine collection of items",
   *   "columnCount": 2,
   *   "borderStyle": {
   *     "type": "STROKE",
   *     "cornerRadius": 4
   *   },
   *   "items": [
   *     {
   *       "image": {
   *         "imageUri": "https://www.example.com/image.png",
   *         "cropStyle": {
   *           "type": "SQUARE"
   *         },
   *         "borderStyle": {
   *           "type": "STROKE"
   *         }
   *       },
   *       "title": "An item",
   *       "textAlignment": "CENTER"
   *     }
   *   ],
   *   "onClick": {
   *     "openLink": {
   *       "url": "https://www.example.com"
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Grid grid = 10;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.GridOrBuilder getGridOrBuilder() {
    if (dataCase_ == 10) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_;
    }
    return com.google.apps.card.v1.Grid.getDefaultInstance();
  }

  public static final int COLUMNS_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Displays up to 2 columns.
   *
   * To include more than 2 columns, or to use rows, use the `Grid` widget.
   *
   * For example, the following JSON creates 2 columns that each contain
   * text paragraphs:
   *
   * ```
   * "columns": {
   *   "columnItems": [
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "First column text paragraph"
   *           }
   *         }
   *       ]
   *     },
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "Second column text paragraph"
   *           }
   *         }
   *       ]
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Columns columns = 11;</code>
   *
   * @return Whether the columns field is set.
   */
  @java.lang.Override
  public boolean hasColumns() {
    return dataCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Displays up to 2 columns.
   *
   * To include more than 2 columns, or to use rows, use the `Grid` widget.
   *
   * For example, the following JSON creates 2 columns that each contain
   * text paragraphs:
   *
   * ```
   * "columns": {
   *   "columnItems": [
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "First column text paragraph"
   *           }
   *         }
   *       ]
   *     },
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "Second column text paragraph"
   *           }
   *         }
   *       ]
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Columns columns = 11;</code>
   *
   * @return The columns.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Columns getColumns() {
    if (dataCase_ == 11) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_;
    }
    return com.google.apps.card.v1.Columns.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Displays up to 2 columns.
   *
   * To include more than 2 columns, or to use rows, use the `Grid` widget.
   *
   * For example, the following JSON creates 2 columns that each contain
   * text paragraphs:
   *
   * ```
   * "columns": {
   *   "columnItems": [
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "First column text paragraph"
   *           }
   *         }
   *       ]
   *     },
   *     {
   *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   *       "horizontalAlignment": "CENTER",
   *       "verticalAlignment": "CENTER",
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "Second column text paragraph"
   *           }
   *         }
   *       ]
   *     }
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.apps.card.v1.Columns columns = 11;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.ColumnsOrBuilder getColumnsOrBuilder() {
    if (dataCase_ == 11) {
      return (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_;
    }
    return com.google.apps.card.v1.Columns.getDefaultInstance();
  }

  public static final int HORIZONTAL_ALIGNMENT_FIELD_NUMBER = 8;
  private int horizontalAlignment_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies whether widgets align to the left, right, or center of a column.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
   *
   * @return The enum numeric value on the wire for horizontalAlignment.
   */
  @java.lang.Override
  public int getHorizontalAlignmentValue() {
    return horizontalAlignment_;
  }
  /**
   *
   *
   * <pre>
   * Specifies whether widgets align to the left, right, or center of a column.
   * </pre>
   *
   * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
   *
   * @return The horizontalAlignment.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget.HorizontalAlignment getHorizontalAlignment() {
    com.google.apps.card.v1.Widget.HorizontalAlignment result =
        com.google.apps.card.v1.Widget.HorizontalAlignment.forNumber(horizontalAlignment_);
    return result == null
        ? com.google.apps.card.v1.Widget.HorizontalAlignment.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataCase_ == 1) {
      output.writeMessage(1, (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_);
    }
    if (dataCase_ == 2) {
      output.writeMessage(2, (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_);
    }
    if (dataCase_ == 3) {
      output.writeMessage(3, (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_);
    }
    if (dataCase_ == 5) {
      output.writeMessage(5, (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_);
    }
    if (dataCase_ == 6) {
      output.writeMessage(6, (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_);
    }
    if (dataCase_ == 7) {
      output.writeMessage(7, (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_);
    }
    if (horizontalAlignment_
        != com.google.apps.card.v1.Widget.HorizontalAlignment.HORIZONTAL_ALIGNMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, horizontalAlignment_);
    }
    if (dataCase_ == 9) {
      output.writeMessage(9, (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_);
    }
    if (dataCase_ == 10) {
      output.writeMessage(10, (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_);
    }
    if (dataCase_ == 11) {
      output.writeMessage(11, (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_);
    }
    if (dataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_);
    }
    if (dataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_);
    }
    if (dataCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_);
    }
    if (dataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_);
    }
    if (dataCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_);
    }
    if (horizontalAlignment_
        != com.google.apps.card.v1.Widget.HorizontalAlignment.HORIZONTAL_ALIGNMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, horizontalAlignment_);
    }
    if (dataCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_);
    }
    if (dataCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_);
    }
    if (dataCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Widget)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Widget other = (com.couchbase.client.core.deps.com.google.apps.card.v1.Widget) obj;

    if (horizontalAlignment_ != other.horizontalAlignment_) return false;
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 1:
        if (!getTextParagraph().equals(other.getTextParagraph())) return false;
        break;
      case 2:
        if (!getImage().equals(other.getImage())) return false;
        break;
      case 3:
        if (!getDecoratedText().equals(other.getDecoratedText())) return false;
        break;
      case 4:
        if (!getButtonList().equals(other.getButtonList())) return false;
        break;
      case 5:
        if (!getTextInput().equals(other.getTextInput())) return false;
        break;
      case 6:
        if (!getSelectionInput().equals(other.getSelectionInput())) return false;
        break;
      case 7:
        if (!getDateTimePicker().equals(other.getDateTimePicker())) return false;
        break;
      case 9:
        if (!getDivider().equals(other.getDivider())) return false;
        break;
      case 10:
        if (!getGrid().equals(other.getGrid())) return false;
        break;
      case 11:
        if (!getColumns().equals(other.getColumns())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HORIZONTAL_ALIGNMENT_FIELD_NUMBER;
    hash = (53 * hash) + horizontalAlignment_;
    switch (dataCase_) {
      case 1:
        hash = (37 * hash) + TEXT_PARAGRAPH_FIELD_NUMBER;
        hash = (53 * hash) + getTextParagraph().hashCode();
        break;
      case 2:
        hash = (37 * hash) + IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getImage().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DECORATED_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getDecoratedText().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BUTTON_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getButtonList().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TEXT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getTextInput().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SELECTION_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSelectionInput().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DATE_TIME_PICKER_FIELD_NUMBER;
        hash = (53 * hash) + getDateTimePicker().hashCode();
        break;
      case 9:
        hash = (37 * hash) + DIVIDER_FIELD_NUMBER;
        hash = (53 * hash) + getDivider().hashCode();
        break;
      case 10:
        hash = (37 * hash) + GRID_FIELD_NUMBER;
        hash = (53 * hash) + getGrid().hashCode();
        break;
      case 11:
        hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getColumns().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(com.couchbase.client.core.deps.com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(com.couchbase.client.core.deps.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.couchbase.client.core.deps.com.google.apps.card.v1.Widget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Each card is made up of widgets.
   *
   * A widget is a composite object that can represent one of text, images,
   * buttons, and other object types.
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Widget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Widget)
      com.google.apps.card.v1.WidgetOrBuilder {
    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Widget_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Widget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Widget.class, com.google.apps.card.v1.Widget.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Widget.newBuilder()
    private Builder() {}

    private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (textParagraphBuilder_ != null) {
        textParagraphBuilder_.clear();
      }
      if (imageBuilder_ != null) {
        imageBuilder_.clear();
      }
      if (decoratedTextBuilder_ != null) {
        decoratedTextBuilder_.clear();
      }
      if (buttonListBuilder_ != null) {
        buttonListBuilder_.clear();
      }
      if (textInputBuilder_ != null) {
        textInputBuilder_.clear();
      }
      if (selectionInputBuilder_ != null) {
        selectionInputBuilder_.clear();
      }
      if (dateTimePickerBuilder_ != null) {
        dateTimePickerBuilder_.clear();
      }
      if (dividerBuilder_ != null) {
        dividerBuilder_.clear();
      }
      if (gridBuilder_ != null) {
        gridBuilder_.clear();
      }
      if (columnsBuilder_ != null) {
        columnsBuilder_.clear();
      }
      horizontalAlignment_ = 0;
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Widget_descriptor;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget getDefaultInstanceForType() {
      return com.google.apps.card.v1.Widget.getDefaultInstance();
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget build() {
      com.google.apps.card.v1.Widget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget buildPartial() {
      com.google.apps.card.v1.Widget result = new com.google.apps.card.v1.Widget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.couchbase.client.core.deps.com.google.apps.card.v1.Widget result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.horizontalAlignment_ = horizontalAlignment_;
      }
    }

    private void buildPartialOneofs(com.couchbase.client.core.deps.com.google.apps.card.v1.Widget result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 1 && textParagraphBuilder_ != null) {
        result.data_ = textParagraphBuilder_.build();
      }
      if (dataCase_ == 2 && imageBuilder_ != null) {
        result.data_ = imageBuilder_.build();
      }
      if (dataCase_ == 3 && decoratedTextBuilder_ != null) {
        result.data_ = decoratedTextBuilder_.build();
      }
      if (dataCase_ == 4 && buttonListBuilder_ != null) {
        result.data_ = buttonListBuilder_.build();
      }
      if (dataCase_ == 5 && textInputBuilder_ != null) {
        result.data_ = textInputBuilder_.build();
      }
      if (dataCase_ == 6 && selectionInputBuilder_ != null) {
        result.data_ = selectionInputBuilder_.build();
      }
      if (dataCase_ == 7 && dateTimePickerBuilder_ != null) {
        result.data_ = dateTimePickerBuilder_.build();
      }
      if (dataCase_ == 9 && dividerBuilder_ != null) {
        result.data_ = dividerBuilder_.build();
      }
      if (dataCase_ == 10 && gridBuilder_ != null) {
        result.data_ = gridBuilder_.build();
      }
      if (dataCase_ == 11 && columnsBuilder_ != null) {
        result.data_ = columnsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Widget) {
        return mergeFrom((com.couchbase.client.core.deps.com.google.apps.card.v1.Widget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.apps.card.v1.Widget other) {
      if (other == com.google.apps.card.v1.Widget.getDefaultInstance()) return this;
      if (other.horizontalAlignment_ != 0) {
        setHorizontalAlignmentValue(other.getHorizontalAlignmentValue());
      }
      switch (other.getDataCase()) {
        case TEXT_PARAGRAPH:
          {
            mergeTextParagraph(other.getTextParagraph());
            break;
          }
        case IMAGE:
          {
            mergeImage(other.getImage());
            break;
          }
        case DECORATED_TEXT:
          {
            mergeDecoratedText(other.getDecoratedText());
            break;
          }
        case BUTTON_LIST:
          {
            mergeButtonList(other.getButtonList());
            break;
          }
        case TEXT_INPUT:
          {
            mergeTextInput(other.getTextInput());
            break;
          }
        case SELECTION_INPUT:
          {
            mergeSelectionInput(other.getSelectionInput());
            break;
          }
        case DATE_TIME_PICKER:
          {
            mergeDateTimePicker(other.getDateTimePicker());
            break;
          }
        case DIVIDER:
          {
            mergeDivider(other.getDivider());
            break;
          }
        case GRID:
          {
            mergeGrid(other.getGrid());
            break;
          }
        case COLUMNS:
          {
            mergeColumns(other.getColumns());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTextParagraphFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getImageFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDecoratedTextFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getButtonListFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTextInputFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSelectionInputFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDateTimePickerFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 7;
                break;
              } // case 58
            case 64:
              {
                horizontalAlignment_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getDividerFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getGridFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getColumnsFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 11;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.TextParagraph,
            com.google.apps.card.v1.TextParagraph.Builder,
            com.google.apps.card.v1.TextParagraphOrBuilder>
        textParagraphBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return Whether the textParagraph field is set.
     */
    @java.lang.Override
    public boolean hasTextParagraph() {
      return dataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return The textParagraph.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph getTextParagraph() {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_;
        }
        return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
      } else {
        if (dataCase_ == 1) {
          return textParagraphBuilder_.getMessage();
        }
        return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    public Builder setTextParagraph(com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph value) {
      if (textParagraphBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        textParagraphBuilder_.setMessage(value);
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    public Builder setTextParagraph(com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph.Builder builderForValue) {
      if (textParagraphBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        textParagraphBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    public Builder mergeTextParagraph(com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph value) {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1 && data_ != com.google.apps.card.v1.TextParagraph.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.TextParagraph.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 1) {
          textParagraphBuilder_.mergeFrom(value);
        } else {
          textParagraphBuilder_.setMessage(value);
        }
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    public Builder clearTextParagraph() {
      if (textParagraphBuilder_ == null) {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
        }
        textParagraphBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph.Builder getTextParagraphBuilder() {
      return getTextParagraphFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraphOrBuilder getTextParagraphOrBuilder() {
      if ((dataCase_ == 1) && (textParagraphBuilder_ != null)) {
        return textParagraphBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 1) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_;
        }
        return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a text paragraph. Supports simple HTML formatted text. For more
     * information about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     *
     * For example, the following JSON creates a bolded text:
     * ```
     * "textParagraph": {
     *   "text": "  &lt;b&gt;bold text&lt;/b&gt;"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.TextParagraph,
            com.google.apps.card.v1.TextParagraph.Builder,
            com.google.apps.card.v1.TextParagraphOrBuilder>
        getTextParagraphFieldBuilder() {
      if (textParagraphBuilder_ == null) {
        if (!(dataCase_ == 1)) {
          data_ = com.google.apps.card.v1.TextParagraph.getDefaultInstance();
        }
        textParagraphBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.TextParagraph,
                com.google.apps.card.v1.TextParagraph.Builder,
                com.google.apps.card.v1.TextParagraphOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.TextParagraph) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 1;
      onChanged();
      return textParagraphBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Image,
            com.google.apps.card.v1.Image.Builder,
            com.google.apps.card.v1.ImageOrBuilder>
        imageBuilder_;
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     *
     * @return Whether the image field is set.
     */
    @java.lang.Override
    public boolean hasImage() {
      return dataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Image getImage() {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_;
        }
        return com.google.apps.card.v1.Image.getDefaultInstance();
      } else {
        if (dataCase_ == 2) {
          return imageBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    public Builder setImage(com.couchbase.client.core.deps.com.google.apps.card.v1.Image value) {
      if (imageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        imageBuilder_.setMessage(value);
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    public Builder setImage(com.couchbase.client.core.deps.com.google.apps.card.v1.Image.Builder builderForValue) {
      if (imageBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        imageBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    public Builder mergeImage(com.couchbase.client.core.deps.com.google.apps.card.v1.Image value) {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2 && data_ != com.google.apps.card.v1.Image.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Image.newBuilder((com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 2) {
          imageBuilder_.mergeFrom(value);
        } else {
          imageBuilder_.setMessage(value);
        }
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    public Builder clearImage() {
      if (imageBuilder_ == null) {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
        }
        imageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Image.Builder getImageBuilder() {
      return getImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.ImageOrBuilder getImageOrBuilder() {
      if ((dataCase_ == 2) && (imageBuilder_ != null)) {
        return imageBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 2) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_;
        }
        return com.google.apps.card.v1.Image.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays an image.
     *
     * For example, the following JSON creates an image with alternative text:
     * ```
     * "image": {
     *   "imageUrl":
     *   "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
     *   "altText": "Chat app avatar"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 2;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Image,
            com.google.apps.card.v1.Image.Builder,
            com.google.apps.card.v1.ImageOrBuilder>
        getImageFieldBuilder() {
      if (imageBuilder_ == null) {
        if (!(dataCase_ == 2)) {
          data_ = com.google.apps.card.v1.Image.getDefaultInstance();
        }
        imageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Image,
                com.google.apps.card.v1.Image.Builder,
                com.google.apps.card.v1.ImageOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.Image) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 2;
      onChanged();
      return imageBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.DecoratedText,
            com.google.apps.card.v1.DecoratedText.Builder,
            com.google.apps.card.v1.DecoratedTextOrBuilder>
        decoratedTextBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     *
     * @return Whether the decoratedText field is set.
     */
    @java.lang.Override
    public boolean hasDecoratedText() {
      return dataCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     *
     * @return The decoratedText.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText getDecoratedText() {
      if (decoratedTextBuilder_ == null) {
        if (dataCase_ == 3) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_;
        }
        return com.google.apps.card.v1.DecoratedText.getDefaultInstance();
      } else {
        if (dataCase_ == 3) {
          return decoratedTextBuilder_.getMessage();
        }
        return com.google.apps.card.v1.DecoratedText.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    public Builder setDecoratedText(com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText value) {
      if (decoratedTextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        decoratedTextBuilder_.setMessage(value);
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    public Builder setDecoratedText(com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText.Builder builderForValue) {
      if (decoratedTextBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        decoratedTextBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    public Builder mergeDecoratedText(com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText value) {
      if (decoratedTextBuilder_ == null) {
        if (dataCase_ == 3 && data_ != com.google.apps.card.v1.DecoratedText.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.DecoratedText.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 3) {
          decoratedTextBuilder_.mergeFrom(value);
        } else {
          decoratedTextBuilder_.setMessage(value);
        }
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    public Builder clearDecoratedText() {
      if (decoratedTextBuilder_ == null) {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
        }
        decoratedTextBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText.Builder getDecoratedTextBuilder() {
      return getDecoratedTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedTextOrBuilder getDecoratedTextOrBuilder() {
      if ((dataCase_ == 3) && (decoratedTextBuilder_ != null)) {
        return decoratedTextBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 3) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_;
        }
        return com.google.apps.card.v1.DecoratedText.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a decorated text item.
     *
     * For example, the following JSON creates a decorated text widget showing
     * email address:
     *
     * ```
     * "decoratedText": {
     *   "icon": {
     *     "knownIcon": "EMAIL"
     *   },
     *   "topLabel": "Email Address",
     *   "text": "sasha&#64;example.com",
     *   "bottomLabel": "This is a new Email address!",
     *   "switchControl": {
     *     "name": "has_send_welcome_email_to_sasha",
     *     "selected": false,
     *     "controlType": "CHECKBOX"
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DecoratedText decorated_text = 3;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.DecoratedText,
            com.google.apps.card.v1.DecoratedText.Builder,
            com.google.apps.card.v1.DecoratedTextOrBuilder>
        getDecoratedTextFieldBuilder() {
      if (decoratedTextBuilder_ == null) {
        if (!(dataCase_ == 3)) {
          data_ = com.google.apps.card.v1.DecoratedText.getDefaultInstance();
        }
        decoratedTextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.DecoratedText,
                com.google.apps.card.v1.DecoratedText.Builder,
                com.google.apps.card.v1.DecoratedTextOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.DecoratedText) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 3;
      onChanged();
      return decoratedTextBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.ButtonList,
            com.google.apps.card.v1.ButtonList.Builder,
            com.google.apps.card.v1.ButtonListOrBuilder>
        buttonListBuilder_;
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     *
     * @return Whether the buttonList field is set.
     */
    @java.lang.Override
    public boolean hasButtonList() {
      return dataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     *
     * @return The buttonList.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList getButtonList() {
      if (buttonListBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_;
        }
        return com.google.apps.card.v1.ButtonList.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return buttonListBuilder_.getMessage();
        }
        return com.google.apps.card.v1.ButtonList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    public Builder setButtonList(com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList value) {
      if (buttonListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        buttonListBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    public Builder setButtonList(com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList.Builder builderForValue) {
      if (buttonListBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        buttonListBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    public Builder mergeButtonList(com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList value) {
      if (buttonListBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.apps.card.v1.ButtonList.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.ButtonList.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          buttonListBuilder_.mergeFrom(value);
        } else {
          buttonListBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    public Builder clearButtonList() {
      if (buttonListBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        buttonListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList.Builder getButtonListBuilder() {
      return getButtonListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonListOrBuilder getButtonListOrBuilder() {
      if ((dataCase_ == 4) && (buttonListBuilder_ != null)) {
        return buttonListBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_;
        }
        return com.google.apps.card.v1.ButtonList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of buttons.
     *
     * For example, the following JSON creates two buttons. The first
     * is a blue text button and the second is an image button that opens a
     * link:
     * ```
     * "buttonList": {
     *   "buttons": [
     *     {
     *       "text": "Edit",
     *       "color": {
     *         "red": 0,
     *         "green": 0,
     *         "blue": 1,
     *         "alpha": 1
     *       },
     *       "disabled": true,
     *     },
     *     {
     *       "icon": {
     *         "knownIcon": "INVITE",
     *         "altText": "check calendar"
     *       },
     *       "onClick": {
     *         "openLink": {
     *           "url": "https://example.com/calendar"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 4;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.ButtonList,
            com.google.apps.card.v1.ButtonList.Builder,
            com.google.apps.card.v1.ButtonListOrBuilder>
        getButtonListFieldBuilder() {
      if (buttonListBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.apps.card.v1.ButtonList.getDefaultInstance();
        }
        buttonListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.ButtonList,
                com.google.apps.card.v1.ButtonList.Builder,
                com.google.apps.card.v1.ButtonListOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.ButtonList) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      return buttonListBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.TextInput,
            com.google.apps.card.v1.TextInput.Builder,
            com.google.apps.card.v1.TextInputOrBuilder>
        textInputBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     *
     * @return Whether the textInput field is set.
     */
    @java.lang.Override
    public boolean hasTextInput() {
      return dataCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     *
     * @return The textInput.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput getTextInput() {
      if (textInputBuilder_ == null) {
        if (dataCase_ == 5) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_;
        }
        return com.google.apps.card.v1.TextInput.getDefaultInstance();
      } else {
        if (dataCase_ == 5) {
          return textInputBuilder_.getMessage();
        }
        return com.google.apps.card.v1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    public Builder setTextInput(com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput value) {
      if (textInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        textInputBuilder_.setMessage(value);
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    public Builder setTextInput(com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput.Builder builderForValue) {
      if (textInputBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        textInputBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    public Builder mergeTextInput(com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput value) {
      if (textInputBuilder_ == null) {
        if (dataCase_ == 5 && data_ != com.google.apps.card.v1.TextInput.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.TextInput.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 5) {
          textInputBuilder_.mergeFrom(value);
        } else {
          textInputBuilder_.setMessage(value);
        }
      }
      dataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    public Builder clearTextInput() {
      if (textInputBuilder_ == null) {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
        }
        textInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput.Builder getTextInputBuilder() {
      return getTextInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.TextInputOrBuilder getTextInputOrBuilder() {
      if ((dataCase_ == 5) && (textInputBuilder_ != null)) {
        return textInputBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 5) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_;
        }
        return com.google.apps.card.v1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a text box that users can type into.
     *
     * For example, the following JSON creates a text input for an email
     * address:
     *
     * ```
     * "textInput": {
     *   "name": "mailing_address",
     *   "label": "Mailing Address"
     * }
     * ```
     *
     * As another example, the following JSON creates a text input for a
     * programming language with static suggestions:
     * ```
     * "textInput": {
     *   "name": "preferred_programing_language",
     *   "label": "Preferred Language",
     *   "initialSuggestions": {
     *     "items": [
     *       {
     *         "text": "C++"
     *       },
     *       {
     *         "text": "Java"
     *       },
     *       {
     *         "text": "JavaScript"
     *       },
     *       {
     *         "text": "Python"
     *       }
     *     ]
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput text_input = 5;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.TextInput,
            com.google.apps.card.v1.TextInput.Builder,
            com.google.apps.card.v1.TextInputOrBuilder>
        getTextInputFieldBuilder() {
      if (textInputBuilder_ == null) {
        if (!(dataCase_ == 5)) {
          data_ = com.google.apps.card.v1.TextInput.getDefaultInstance();
        }
        textInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.TextInput,
                com.google.apps.card.v1.TextInput.Builder,
                com.google.apps.card.v1.TextInputOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.TextInput) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 5;
      onChanged();
      return textInputBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput,
            com.google.apps.card.v1.SelectionInput.Builder,
            com.google.apps.card.v1.SelectionInputOrBuilder>
        selectionInputBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     *
     * @return Whether the selectionInput field is set.
     */
    @java.lang.Override
    public boolean hasSelectionInput() {
      return dataCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     *
     * @return The selectionInput.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput getSelectionInput() {
      if (selectionInputBuilder_ == null) {
        if (dataCase_ == 6) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_;
        }
        return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
      } else {
        if (dataCase_ == 6) {
          return selectionInputBuilder_.getMessage();
        }
        return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    public Builder setSelectionInput(com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput value) {
      if (selectionInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        selectionInputBuilder_.setMessage(value);
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    public Builder setSelectionInput(
        com.google.apps.card.v1.SelectionInput.Builder builderForValue) {
      if (selectionInputBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        selectionInputBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    public Builder mergeSelectionInput(com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput value) {
      if (selectionInputBuilder_ == null) {
        if (dataCase_ == 6
            && data_ != com.google.apps.card.v1.SelectionInput.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.SelectionInput.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 6) {
          selectionInputBuilder_.mergeFrom(value);
        } else {
          selectionInputBuilder_.setMessage(value);
        }
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    public Builder clearSelectionInput() {
      if (selectionInputBuilder_ == null) {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
        }
        selectionInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput.Builder getSelectionInputBuilder() {
      return getSelectionInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInputOrBuilder getSelectionInputOrBuilder() {
      if ((dataCase_ == 6) && (selectionInputBuilder_ != null)) {
        return selectionInputBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 6) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_;
        }
        return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a selection control that lets users select items. Selection
     * controls can be checkboxes, radio buttons, switches, or dropdown menus.
     *
     * For example, the following JSON creates a dropdown menu that lets users
     * choose a size:
     *
     * ```
     * "selectionInput": {
     *   "name": "size",
     *   "label": "Size"
     *   "type": "DROPDOWN",
     *   "items": [
     *     {
     *       "text": "S",
     *       "value": "small",
     *       "selected": false
     *     },
     *     {
     *       "text": "M",
     *       "value": "medium",
     *       "selected": true
     *     },
     *     {
     *       "text": "L",
     *       "value": "large",
     *       "selected": false
     *     },
     *     {
     *       "text": "XL",
     *       "value": "extra_large",
     *       "selected": false
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput selection_input = 6;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput,
            com.google.apps.card.v1.SelectionInput.Builder,
            com.google.apps.card.v1.SelectionInputOrBuilder>
        getSelectionInputFieldBuilder() {
      if (selectionInputBuilder_ == null) {
        if (!(dataCase_ == 6)) {
          data_ = com.google.apps.card.v1.SelectionInput.getDefaultInstance();
        }
        selectionInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.SelectionInput,
                com.google.apps.card.v1.SelectionInput.Builder,
                com.google.apps.card.v1.SelectionInputOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.SelectionInput) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 6;
      onChanged();
      return selectionInputBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.DateTimePicker,
            com.google.apps.card.v1.DateTimePicker.Builder,
            com.google.apps.card.v1.DateTimePickerOrBuilder>
        dateTimePickerBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     *
     * @return Whether the dateTimePicker field is set.
     */
    @java.lang.Override
    public boolean hasDateTimePicker() {
      return dataCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     *
     * @return The dateTimePicker.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker getDateTimePicker() {
      if (dateTimePickerBuilder_ == null) {
        if (dataCase_ == 7) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_;
        }
        return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
      } else {
        if (dataCase_ == 7) {
          return dateTimePickerBuilder_.getMessage();
        }
        return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    public Builder setDateTimePicker(com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker value) {
      if (dateTimePickerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        dateTimePickerBuilder_.setMessage(value);
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    public Builder setDateTimePicker(
        com.google.apps.card.v1.DateTimePicker.Builder builderForValue) {
      if (dateTimePickerBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        dateTimePickerBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    public Builder mergeDateTimePicker(com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker value) {
      if (dateTimePickerBuilder_ == null) {
        if (dataCase_ == 7
            && data_ != com.google.apps.card.v1.DateTimePicker.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.DateTimePicker.newBuilder(
                      (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 7) {
          dateTimePickerBuilder_.mergeFrom(value);
        } else {
          dateTimePickerBuilder_.setMessage(value);
        }
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    public Builder clearDateTimePicker() {
      if (dateTimePickerBuilder_ == null) {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
        }
        dateTimePickerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker.Builder getDateTimePickerBuilder() {
      return getDateTimePickerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePickerOrBuilder getDateTimePickerOrBuilder() {
      if ((dataCase_ == 7) && (dateTimePickerBuilder_ != null)) {
        return dateTimePickerBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 7) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_;
        }
        return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a widget that lets users input a date, time, or date and time.
     *
     * For example, the following JSON creates a date time picker to schedule an
     * appointment:
     *
     *
     * ```
     * "dateTimePicker": {
     *   "name": "appointment_time",
     *   "label": "Book your appointment at:",
     *   "type": "DATE_AND_TIME",
     *   "valueMsEpoch": "796435200000"
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker date_time_picker = 7;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.DateTimePicker,
            com.google.apps.card.v1.DateTimePicker.Builder,
            com.google.apps.card.v1.DateTimePickerOrBuilder>
        getDateTimePickerFieldBuilder() {
      if (dateTimePickerBuilder_ == null) {
        if (!(dataCase_ == 7)) {
          data_ = com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
        }
        dateTimePickerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.DateTimePicker,
                com.google.apps.card.v1.DateTimePicker.Builder,
                com.google.apps.card.v1.DateTimePickerOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.DateTimePicker) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 7;
      onChanged();
      return dateTimePickerBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Divider,
            com.google.apps.card.v1.Divider.Builder,
            com.google.apps.card.v1.DividerOrBuilder>
        dividerBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     *
     * @return Whether the divider field is set.
     */
    @java.lang.Override
    public boolean hasDivider() {
      return dataCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     *
     * @return The divider.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Divider getDivider() {
      if (dividerBuilder_ == null) {
        if (dataCase_ == 9) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_;
        }
        return com.google.apps.card.v1.Divider.getDefaultInstance();
      } else {
        if (dataCase_ == 9) {
          return dividerBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Divider.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    public Builder setDivider(com.couchbase.client.core.deps.com.google.apps.card.v1.Divider value) {
      if (dividerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        dividerBuilder_.setMessage(value);
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    public Builder setDivider(com.couchbase.client.core.deps.com.google.apps.card.v1.Divider.Builder builderForValue) {
      if (dividerBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        dividerBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    public Builder mergeDivider(com.couchbase.client.core.deps.com.google.apps.card.v1.Divider value) {
      if (dividerBuilder_ == null) {
        if (dataCase_ == 9 && data_ != com.google.apps.card.v1.Divider.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Divider.newBuilder((com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 9) {
          dividerBuilder_.mergeFrom(value);
        } else {
          dividerBuilder_.setMessage(value);
        }
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    public Builder clearDivider() {
      if (dividerBuilder_ == null) {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
        }
        dividerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Divider.Builder getDividerBuilder() {
      return getDividerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.DividerOrBuilder getDividerOrBuilder() {
      if ((dataCase_ == 9) && (dividerBuilder_ != null)) {
        return dividerBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 9) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_;
        }
        return com.google.apps.card.v1.Divider.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a horizontal line divider between widgets.
     *
     * For example, the following JSON creates a divider:
     * ```
     * "divider": {
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Divider divider = 9;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Divider,
            com.google.apps.card.v1.Divider.Builder,
            com.google.apps.card.v1.DividerOrBuilder>
        getDividerFieldBuilder() {
      if (dividerBuilder_ == null) {
        if (!(dataCase_ == 9)) {
          data_ = com.google.apps.card.v1.Divider.getDefaultInstance();
        }
        dividerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Divider,
                com.google.apps.card.v1.Divider.Builder,
                com.google.apps.card.v1.DividerOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.Divider) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 9;
      onChanged();
      return dividerBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Grid,
            com.google.apps.card.v1.Grid.Builder,
            com.google.apps.card.v1.GridOrBuilder>
        gridBuilder_;
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     *
     * @return Whether the grid field is set.
     */
    @java.lang.Override
    public boolean hasGrid() {
      return dataCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     *
     * @return The grid.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Grid getGrid() {
      if (gridBuilder_ == null) {
        if (dataCase_ == 10) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_;
        }
        return com.google.apps.card.v1.Grid.getDefaultInstance();
      } else {
        if (dataCase_ == 10) {
          return gridBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Grid.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    public Builder setGrid(com.couchbase.client.core.deps.com.google.apps.card.v1.Grid value) {
      if (gridBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        gridBuilder_.setMessage(value);
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    public Builder setGrid(com.couchbase.client.core.deps.com.google.apps.card.v1.Grid.Builder builderForValue) {
      if (gridBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        gridBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    public Builder mergeGrid(com.couchbase.client.core.deps.com.google.apps.card.v1.Grid value) {
      if (gridBuilder_ == null) {
        if (dataCase_ == 10 && data_ != com.google.apps.card.v1.Grid.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Grid.newBuilder((com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 10) {
          gridBuilder_.mergeFrom(value);
        } else {
          gridBuilder_.setMessage(value);
        }
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    public Builder clearGrid() {
      if (gridBuilder_ == null) {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
        }
        gridBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Grid.Builder getGridBuilder() {
      return getGridFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.GridOrBuilder getGridOrBuilder() {
      if ((dataCase_ == 10) && (gridBuilder_ != null)) {
        return gridBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 10) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_;
        }
        return com.google.apps.card.v1.Grid.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays a grid with a collection of items.
     *
     * A grid supports any number of columns and items. The number of rows is
     * determined by the upper bounds of the number items divided by the number
     * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11
     * items and 2 columns has 6 rows.
     *
     * [Google Workspace Add-ons and
     * Chat apps](https://developers.google.com/workspace/extend):
     *
     * For example, the following JSON creates a 2 column grid with a single
     * item:
     *
     * ```
     * "grid": {
     *   "title": "A fine collection of items",
     *   "columnCount": 2,
     *   "borderStyle": {
     *     "type": "STROKE",
     *     "cornerRadius": 4
     *   },
     *   "items": [
     *     {
     *       "image": {
     *         "imageUri": "https://www.example.com/image.png",
     *         "cropStyle": {
     *           "type": "SQUARE"
     *         },
     *         "borderStyle": {
     *           "type": "STROKE"
     *         }
     *       },
     *       "title": "An item",
     *       "textAlignment": "CENTER"
     *     }
     *   ],
     *   "onClick": {
     *     "openLink": {
     *       "url": "https://www.example.com"
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid grid = 10;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Grid,
            com.google.apps.card.v1.Grid.Builder,
            com.google.apps.card.v1.GridOrBuilder>
        getGridFieldBuilder() {
      if (gridBuilder_ == null) {
        if (!(dataCase_ == 10)) {
          data_ = com.google.apps.card.v1.Grid.getDefaultInstance();
        }
        gridBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Grid,
                com.google.apps.card.v1.Grid.Builder,
                com.google.apps.card.v1.GridOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.Grid) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 10;
      onChanged();
      return gridBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Columns,
            com.google.apps.card.v1.Columns.Builder,
            com.google.apps.card.v1.ColumnsOrBuilder>
        columnsBuilder_;
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     *
     * @return Whether the columns field is set.
     */
    @java.lang.Override
    public boolean hasColumns() {
      return dataCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     *
     * @return The columns.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Columns getColumns() {
      if (columnsBuilder_ == null) {
        if (dataCase_ == 11) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_;
        }
        return com.google.apps.card.v1.Columns.getDefaultInstance();
      } else {
        if (dataCase_ == 11) {
          return columnsBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Columns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    public Builder setColumns(com.couchbase.client.core.deps.com.google.apps.card.v1.Columns value) {
      if (columnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        columnsBuilder_.setMessage(value);
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    public Builder setColumns(com.couchbase.client.core.deps.com.google.apps.card.v1.Columns.Builder builderForValue) {
      if (columnsBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        columnsBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    public Builder mergeColumns(com.couchbase.client.core.deps.com.google.apps.card.v1.Columns value) {
      if (columnsBuilder_ == null) {
        if (dataCase_ == 11 && data_ != com.google.apps.card.v1.Columns.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Columns.newBuilder((com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 11) {
          columnsBuilder_.mergeFrom(value);
        } else {
          columnsBuilder_.setMessage(value);
        }
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    public Builder clearColumns() {
      if (columnsBuilder_ == null) {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
        }
        columnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Columns.Builder getColumnsBuilder() {
      return getColumnsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.ColumnsOrBuilder getColumnsOrBuilder() {
      if ((dataCase_ == 11) && (columnsBuilder_ != null)) {
        return columnsBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 11) {
          return (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_;
        }
        return com.google.apps.card.v1.Columns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Displays up to 2 columns.
     *
     * To include more than 2 columns, or to use rows, use the `Grid` widget.
     *
     * For example, the following JSON creates 2 columns that each contain
     * text paragraphs:
     *
     * ```
     * "columns": {
     *   "columnItems": [
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "First column text paragraph"
     *           }
     *         }
     *       ]
     *     },
     *     {
     *       "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
     *       "horizontalAlignment": "CENTER",
     *       "verticalAlignment": "CENTER",
     *       "widgets": [
     *         {
     *           "textParagraph": {
     *             "text": "Second column text paragraph"
     *           }
     *         }
     *       ]
     *     }
     *   ]
     * }
     * ```
     * </pre>
     *
     * <code>.google.apps.card.v1.Columns columns = 11;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Columns,
            com.google.apps.card.v1.Columns.Builder,
            com.google.apps.card.v1.ColumnsOrBuilder>
        getColumnsFieldBuilder() {
      if (columnsBuilder_ == null) {
        if (!(dataCase_ == 11)) {
          data_ = com.google.apps.card.v1.Columns.getDefaultInstance();
        }
        columnsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Columns,
                com.google.apps.card.v1.Columns.Builder,
                com.google.apps.card.v1.ColumnsOrBuilder>(
                (com.couchbase.client.core.deps.com.google.apps.card.v1.Columns) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 11;
      onChanged();
      return columnsBuilder_;
    }

    private int horizontalAlignment_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies whether widgets align to the left, right, or center of a column.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
     *
     * @return The enum numeric value on the wire for horizontalAlignment.
     */
    @java.lang.Override
    public int getHorizontalAlignmentValue() {
      return horizontalAlignment_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether widgets align to the left, right, or center of a column.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
     *
     * @param value The enum numeric value on the wire for horizontalAlignment to set.
     * @return This builder for chaining.
     */
    public Builder setHorizontalAlignmentValue(int value) {
      horizontalAlignment_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether widgets align to the left, right, or center of a column.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
     *
     * @return The horizontalAlignment.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget.HorizontalAlignment getHorizontalAlignment() {
      com.google.apps.card.v1.Widget.HorizontalAlignment result =
          com.google.apps.card.v1.Widget.HorizontalAlignment.forNumber(horizontalAlignment_);
      return result == null
          ? com.google.apps.card.v1.Widget.HorizontalAlignment.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether widgets align to the left, right, or center of a column.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
     *
     * @param value The horizontalAlignment to set.
     * @return This builder for chaining.
     */
    public Builder setHorizontalAlignment(
        com.google.apps.card.v1.Widget.HorizontalAlignment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      horizontalAlignment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether widgets align to the left, right, or center of a column.
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.HorizontalAlignment horizontal_alignment = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHorizontalAlignment() {
      bitField0_ = (bitField0_ & ~0x00000400);
      horizontalAlignment_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Widget)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Widget)
  private static final com.couchbase.client.core.deps.com.google.apps.card.v1.Widget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Widget();
  }

  public static com.couchbase.client.core.deps.com.google.apps.card.v1.Widget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<Widget> PARSER =
      new com.google.protobuf.AbstractParser<Widget>() {
        @java.lang.Override
        public Widget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.couchbase.client.core.deps.com.google.protobuf.Parser<Widget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Parser<Widget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.apps.card.v1.Widget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
