// SPDX-License-Identifier: BSD-3-Clause
// Copyright (c) 1999-2004 Brian Wellington (bwelling@xbill.org)

package com.couchbase.client.core.deps.org.xbill.DNS;

/**
 * NSAP Pointer Record - maps a domain name representing an NSAP Address to a hostname. (obsolete)
 *
 * @author Brian Wellington
 * @see <a href="https://datatracker.ietf.org/doc/html/rfc1706">RFC 1706: DNS NSAP Resource
 *     Records</a>
 */
public class NSAP_PTRRecord extends SingleNameBase {
  NSAP_PTRRecord() {}

  /**
   * Creates a new NSAP_PTR Record with the given data
   *
   * @param target The name of the host with this address
   */
  public NSAP_PTRRecord(Name name, int dclass, long ttl, Name target) {
    super(name, Type.NSAP_PTR, dclass, ttl, target, "target");
  }

  /** Gets the target of the NSAP_PTR Record */
  public Name getTarget() {
    return getSingleName();
  }
}
