/*
 * Copyright 2023 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.search.CoreSearchIndex;

@Stability.Internal
public class SearchIndexManagerUtil {
  private SearchIndexManagerUtil() {}

  public static SearchIndex convert(CoreSearchIndex index) {
    return new SearchIndex(index.uuid(),
            index.name(),
            index.type(),
            index.params(),
            index.sourceUuid(),
            index.sourceName(),
            index.sourceParams(),
            index.sourceType(),
            index.planParams());
  }

  public static CoreSearchIndex convert(SearchIndex index) {
    return new CoreSearchIndex(index.uuid(),
            index.name(),
            index.type(),
            index.params(),
            index.sourceUuid(),
            index.sourceName(),
            index.sourceParams(),
            index.sourceType(),
            index.planParams());
  }
}
