/*
 * Copyright 2023 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonValue;

import java.util.Map;

import static java.util.Objects.requireNonNull;

@Stability.Internal
public class QueryOptionsUtil {
  public static ObjectNode convert(Map<String, Object> in) {
    requireNonNull(in);
    Object coerced = JsonValue.coerce(in);
    return JacksonTransformers.MAPPER.convertValue(coerced, ObjectNode.class);
  }
}
